/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.tools.rumen.EventType;
import org.apache.hadoop.tools.rumen.HistoryEvent;
import org.apache.hadoop.tools.rumen.JhCounters;

public class ReduceAttemptFinishedEvent
implements HistoryEvent {
    private TaskID taskId;
    private TaskAttemptID attemptId;
    private TaskType taskType;
    private String taskStatus;
    private long shuffleFinishTime;
    private long sortFinishTime;
    private long finishTime;
    private String hostname;
    private String state;
    private JhCounters counters;

    public ReduceAttemptFinishedEvent(TaskAttemptID id, TaskType taskType, String taskStatus, long shuffleFinishTime, long sortFinishTime, long finishTime, String hostname, String state, Counters counters) {
        this.taskId = id.getTaskID();
        this.attemptId = id;
        this.taskType = taskType;
        this.taskStatus = taskStatus;
        this.shuffleFinishTime = shuffleFinishTime;
        this.sortFinishTime = sortFinishTime;
        this.finishTime = finishTime;
        this.hostname = hostname;
        this.state = state;
        this.counters = new JhCounters(counters, "COUNTERS");
    }

    public TaskID getTaskId() {
        return this.taskId;
    }

    public TaskAttemptID getAttemptId() {
        return this.attemptId;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public String getTaskStatus() {
        return this.taskStatus;
    }

    public long getSortFinishTime() {
        return this.sortFinishTime;
    }

    public long getShuffleFinishTime() {
        return this.shuffleFinishTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getState() {
        return this.state;
    }

    public JhCounters getCounters() {
        return this.counters;
    }

    @Override
    public EventType getEventType() {
        return EventType.REDUCE_ATTEMPT_FINISHED;
    }
}

