/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hcatalog.common.HCatException;
import org.apache.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hcatalog.data.schema.HCatSchemaUtils;

public class HCatTable {
    private String tableName;
    private String tabletype;
    private List<HCatFieldSchema> cols;
    private List<HCatFieldSchema> partCols;
    private List<String> bucketCols;
    private List<Order> sortCols;
    private int numBuckets;
    private String inputFileFormat;
    private String outputFileFormat;
    private String storageHandler;
    private Map<String, String> tblProps;
    private String dbName;
    private String serde;
    private String location;

    HCatTable(Table hiveTable) throws HCatException {
        this.tableName = hiveTable.getTableName();
        this.dbName = hiveTable.getDbName();
        this.tabletype = hiveTable.getTableType();
        this.cols = new ArrayList<HCatFieldSchema>();
        for (FieldSchema colFS : hiveTable.getSd().getCols()) {
            this.cols.add(HCatSchemaUtils.getHCatFieldSchema((FieldSchema)colFS));
        }
        this.partCols = new ArrayList<HCatFieldSchema>();
        for (FieldSchema colFS : hiveTable.getPartitionKeys()) {
            this.partCols.add(HCatSchemaUtils.getHCatFieldSchema((FieldSchema)colFS));
        }
        this.bucketCols = hiveTable.getSd().getBucketCols();
        this.sortCols = hiveTable.getSd().getSortCols();
        this.numBuckets = hiveTable.getSd().getNumBuckets();
        this.inputFileFormat = hiveTable.getSd().getInputFormat();
        this.outputFileFormat = hiveTable.getSd().getOutputFormat();
        this.storageHandler = (String)hiveTable.getSd().getParameters().get("storage_handler");
        this.tblProps = hiveTable.getParameters();
        this.serde = hiveTable.getSd().getSerdeInfo().getSerializationLib();
        this.location = hiveTable.getSd().getLocation();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public List<HCatFieldSchema> getCols() {
        return this.cols;
    }

    public List<HCatFieldSchema> getPartCols() {
        return this.partCols;
    }

    public List<String> getBucketCols() {
        return this.bucketCols;
    }

    public List<Order> getSortCols() {
        return this.sortCols;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public String getStorageHandler() {
        return this.storageHandler;
    }

    public Map<String, String> getTblProps() {
        return this.tblProps;
    }

    public String getTabletype() {
        return this.tabletype;
    }

    public String getInputFileFormat() {
        return this.inputFileFormat;
    }

    public String getOutputFileFormat() {
        return this.outputFileFormat;
    }

    public String getSerdeLib() {
        return this.serde;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "HCatTable [" + (this.tableName != null ? "tableName=" + this.tableName + ", " : "tableName=null") + (this.dbName != null ? "dbName=" + this.dbName + ", " : "dbName=null") + (this.tabletype != null ? "tabletype=" + this.tabletype + ", " : "tabletype=null") + (this.cols != null ? "cols=" + this.cols + ", " : "cols=null") + (this.partCols != null ? "partCols=" + this.partCols + ", " : "partCols==null") + (this.bucketCols != null ? "bucketCols=" + this.bucketCols + ", " : "bucketCols=null") + (this.sortCols != null ? "sortCols=" + this.sortCols + ", " : "sortCols=null") + "numBuckets=" + this.numBuckets + ", " + (this.inputFileFormat != null ? "inputFileFormat=" + this.inputFileFormat + ", " : "inputFileFormat=null") + (this.outputFileFormat != null ? "outputFileFormat=" + this.outputFileFormat + ", " : "outputFileFormat=null") + (this.storageHandler != null ? "storageHandler=" + this.storageHandler + ", " : "storageHandler=null") + (this.tblProps != null ? "tblProps=" + this.tblProps + ", " : "tblProps=null") + (this.serde != null ? "serde=" + this.serde + ", " : "serde=") + (this.location != null ? "location=" + this.location : "location=") + "]";
    }
}

