/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchemaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HCatCreateTableDesc {
    private static final Logger LOG = LoggerFactory.getLogger(HCatCreateTableDesc.class);
    private String tableName;
    private String dbName;
    private boolean isExternal;
    private String comment;
    private String location;
    private List<HCatFieldSchema> cols;
    private List<HCatFieldSchema> partCols;
    private List<String> bucketCols;
    private int numBuckets;
    private List<Order> sortCols;
    private Map<String, String> tblProps;
    private boolean ifNotExists;
    private String fileFormat;
    private String inputformat;
    private String outputformat;
    private String serde;
    private String storageHandler;

    private HCatCreateTableDesc(String dbName, String tableName, List<HCatFieldSchema> columns) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.cols = columns;
    }

    public static Builder create(String dbName, String tableName, List<HCatFieldSchema> columns) {
        return new Builder(dbName, tableName, columns);
    }

    Table toHiveTable(HiveConf conf) throws HCatException {
        Table newTable = new Table();
        newTable.setDbName(this.dbName);
        newTable.setTableName(this.tableName);
        if (this.tblProps != null) {
            newTable.setParameters(this.tblProps);
        }
        if (this.isExternal) {
            newTable.putToParameters("EXTERNAL", "TRUE");
            newTable.setTableType(TableType.EXTERNAL_TABLE.toString());
        } else {
            newTable.setTableType(TableType.MANAGED_TABLE.toString());
        }
        StorageDescriptor sd = new StorageDescriptor();
        sd.setSerdeInfo(new SerDeInfo());
        if (this.location != null) {
            sd.setLocation(this.location);
        }
        if (this.comment != null) {
            newTable.putToParameters("comment", this.comment);
        }
        if (!StringUtils.isEmpty((String)this.fileFormat)) {
            sd.setInputFormat(this.inputformat);
            sd.setOutputFormat(this.outputformat);
            if (this.serde != null) {
                sd.getSerdeInfo().setSerializationLib(this.serde);
            } else {
                LOG.info("Using LazySimpleSerDe for table " + this.tableName);
                sd.getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
            }
        } else {
            try {
                LOG.info("Creating instance of storage handler to get input/output, serder info.");
                HiveStorageHandler sh = HiveUtils.getStorageHandler((Configuration)conf, (String)this.storageHandler);
                sd.setInputFormat(sh.getInputFormatClass().getName());
                sd.setOutputFormat(sh.getOutputFormatClass().getName());
                sd.getSerdeInfo().setSerializationLib(sh.getSerDeClass().getName());
                newTable.putToParameters("storage_handler", this.storageHandler);
            }
            catch (HiveException e) {
                throw new HCatException("Exception while creating instance of storage handler", (Throwable)e);
            }
        }
        newTable.setSd(sd);
        if (this.partCols != null) {
            ArrayList<FieldSchema> hivePtnCols = new ArrayList<FieldSchema>();
            for (HCatFieldSchema fs : this.partCols) {
                hivePtnCols.add(HCatSchemaUtils.getFieldSchema((HCatFieldSchema)fs));
            }
            newTable.setPartitionKeys(hivePtnCols);
        }
        if (this.cols != null) {
            ArrayList<FieldSchema> hiveTblCols = new ArrayList<FieldSchema>();
            for (HCatFieldSchema fs : this.cols) {
                hiveTblCols.add(HCatSchemaUtils.getFieldSchema((HCatFieldSchema)fs));
            }
            newTable.getSd().setCols(hiveTblCols);
        }
        if (this.bucketCols != null) {
            newTable.getSd().setBucketCols(this.bucketCols);
            newTable.getSd().setNumBuckets(this.numBuckets);
        }
        if (this.sortCols != null) {
            newTable.getSd().setSortCols(this.sortCols);
        }
        newTable.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        newTable.setLastAccessTimeIsSet(false);
        return newTable;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<HCatFieldSchema> getCols() {
        return this.cols;
    }

    public List<HCatFieldSchema> getPartitionCols() {
        return this.partCols;
    }

    public List<String> getBucketCols() {
        return this.bucketCols;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public String getComments() {
        return this.comment;
    }

    public String getStorageHandler() {
        return this.storageHandler;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean getExternal() {
        return this.isExternal;
    }

    public List<Order> getSortCols() {
        return this.sortCols;
    }

    public Map<String, String> getTblProps() {
        return this.tblProps;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public String toString() {
        return "HCatCreateTableDesc [" + (this.tableName != null ? "tableName=" + this.tableName + ", " : "tableName=null") + (this.dbName != null ? "dbName=" + this.dbName + ", " : "dbName=null") + "isExternal=" + this.isExternal + ", " + (this.comment != null ? "comment=" + this.comment + ", " : "comment=null") + (this.location != null ? "location=" + this.location + ", " : "location=null") + (this.cols != null ? "cols=" + this.cols + ", " : "cols=null") + (this.partCols != null ? "partCols=" + this.partCols + ", " : "partCols=null") + (this.bucketCols != null ? "bucketCols=" + this.bucketCols + ", " : "bucketCols=null") + "numBuckets=" + this.numBuckets + ", " + (this.sortCols != null ? "sortCols=" + this.sortCols + ", " : "sortCols=null") + (this.tblProps != null ? "tblProps=" + this.tblProps + ", " : "tblProps=null") + "ifNotExists=" + this.ifNotExists + ", " + (this.fileFormat != null ? "fileFormat=" + this.fileFormat + ", " : "fileFormat=null") + (this.inputformat != null ? "inputformat=" + this.inputformat + ", " : "inputformat=null") + (this.outputformat != null ? "outputformat=" + this.outputformat + ", " : "outputformat=null") + (this.serde != null ? "serde=" + this.serde + ", " : "serde=null") + (this.storageHandler != null ? "storageHandler=" + this.storageHandler : "storageHandler=null") + "]";
    }

    public static class Builder {
        private String tableName;
        private boolean isExternal;
        private List<HCatFieldSchema> cols;
        private List<HCatFieldSchema> partCols;
        private List<String> bucketCols;
        private List<Order> sortCols;
        private int numBuckets;
        private String comment;
        private String fileFormat;
        private String location;
        private String storageHandler;
        private Map<String, String> tblProps;
        private boolean ifNotExists;
        private String dbName;

        private Builder(String dbName, String tableName, List<HCatFieldSchema> columns) {
            this.dbName = dbName;
            this.tableName = tableName;
            this.cols = columns;
        }

        public Builder ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        public Builder partCols(List<HCatFieldSchema> partCols) {
            this.partCols = partCols;
            return this;
        }

        public Builder bucketCols(List<String> bucketCols, int buckets) {
            this.bucketCols = bucketCols;
            this.numBuckets = buckets;
            return this;
        }

        public Builder storageHandler(String storageHandler) {
            this.storageHandler = storageHandler;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder comments(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder isTableExternal(boolean isExternal) {
            this.isExternal = isExternal;
            return this;
        }

        public Builder sortCols(ArrayList<Order> sortCols) {
            this.sortCols = sortCols;
            return this;
        }

        public Builder tblProps(Map<String, String> tblProps) {
            this.tblProps = tblProps;
            return this;
        }

        public Builder fileFormat(String format) {
            this.fileFormat = format;
            return this;
        }

        public HCatCreateTableDesc build() throws HCatException {
            if (this.dbName == null) {
                LOG.info("Database name found null. Setting db to :default");
                this.dbName = "default";
            }
            HCatCreateTableDesc desc = new HCatCreateTableDesc(this.dbName, this.tableName, this.cols);
            desc.ifNotExists = this.ifNotExists;
            desc.isExternal = this.isExternal;
            desc.comment = this.comment;
            desc.partCols = this.partCols;
            desc.bucketCols = this.bucketCols;
            desc.numBuckets = this.numBuckets;
            desc.location = this.location;
            desc.tblProps = this.tblProps;
            desc.sortCols = this.sortCols;
            desc.serde = null;
            if (!StringUtils.isEmpty((String)this.fileFormat)) {
                desc.fileFormat = this.fileFormat;
                if ("SequenceFile".equalsIgnoreCase(this.fileFormat)) {
                    desc.inputformat = SequenceFileInputFormat.class.getName();
                    desc.outputformat = SequenceFileOutputFormat.class.getName();
                } else if ("RCFile".equalsIgnoreCase(this.fileFormat)) {
                    desc.inputformat = RCFileInputFormat.class.getName();
                    desc.outputformat = RCFileOutputFormat.class.getName();
                    desc.serde = ColumnarSerDe.class.getName();
                }
                desc.storageHandler = "";
            } else if (!StringUtils.isEmpty((String)this.storageHandler)) {
                desc.storageHandler = this.storageHandler;
            } else {
                desc.fileFormat = "TextFile";
                LOG.info("Using text file format for the table.");
                desc.inputformat = TextInputFormat.class.getName();
                LOG.info("Table input format:" + desc.inputformat);
                desc.outputformat = IgnoreKeyTextOutputFormat.class.getName();
                LOG.info("Table output format:" + desc.outputformat);
            }
            return desc;
        }
    }
}

