/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;

public class SpecificDatumReader<T>
extends GenericDatumReader<T> {
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];
    private static final Map<Class, Constructor> CTOR_CACHE = new ConcurrentHashMap<Class, Constructor>();

    public SpecificDatumReader() {
    }

    public SpecificDatumReader(Class<T> c) {
        this(SpecificData.get().getSchema(c));
    }

    public SpecificDatumReader(Schema schema) {
        super(schema);
    }

    @Override
    protected Object newRecord(Object old, Schema schema) {
        Class c = SpecificData.get().getClass(schema);
        return c.isInstance(old) ? old : SpecificDatumReader.newInstance(c);
    }

    @Override
    protected void setField(Object record, String name, int position, Object o) {
        ((SpecificRecord)record).put(position, o);
    }

    @Override
    protected Object getField(Object record, String name, int position) {
        return ((SpecificRecord)record).get(position);
    }

    @Override
    protected Object createEnum(String symbol, Schema schema) {
        return Enum.valueOf(SpecificData.get().getClass(schema), symbol);
    }

    @Override
    protected Object createFixed(Object old, Schema schema) {
        Class c = SpecificData.get().getClass(schema);
        return c.isInstance(old) ? old : SpecificDatumReader.newInstance(c);
    }

    protected static Object newInstance(Class c) {
        Object result;
        try {
            Constructor meth = CTOR_CACHE.get(c);
            if (meth == null) {
                meth = c.getDeclaredConstructor(EMPTY_ARRAY);
                meth.setAccessible(true);
                CTOR_CACHE.put(c, meth);
            }
            result = meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

