/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cli;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;
import jline.SimpleCompletor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.cli.OptionsProcessor;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.io.CachingPrintStream;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.parse.HiveParser;
import org.apache.hadoop.hive.ql.parse.VariableSubstitution;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.service.HiveClient;
import org.apache.hadoop.hive.service.HiveServerException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.IOUtils;
import org.apache.thrift.TException;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class CliDriver {
    public static String prompt = null;
    public static String prompt2 = null;
    public static final int LINES_TO_FETCH = 40;
    public static final String HIVERCFILE = ".hiverc";
    private final SessionState.LogHelper console;
    private Configuration conf;

    public CliDriver() {
        SessionState ss = SessionState.get();
        this.conf = ss != null ? ss.getConf() : new Configuration();
        Log LOG = LogFactory.getLog((String)"CliDriver");
        this.console = new SessionState.LogHelper(LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int processCmd(String cmd) {
        CliSessionState ss = (CliSessionState)SessionState.get();
        ss.err.flush();
        String cmd_trimmed = cmd.trim();
        String[] tokens = this.tokenizeCmd(cmd_trimmed);
        int ret = 0;
        if (cmd_trimmed.toLowerCase().equals("quit") || cmd_trimmed.toLowerCase().equals("exit")) {
            ss.close();
            System.exit(0);
            return ret;
        }
        if (tokens[0].equalsIgnoreCase("source")) {
            String cmd_1 = this.getFirstCmd(cmd_trimmed, tokens[0].length());
            File sourceFile = new File(cmd_1);
            if (!sourceFile.isFile()) {
                this.console.printError("File: " + cmd_1 + " is not a file.");
                return 1;
            }
            try {
                this.processFile(cmd_1);
                return ret;
            }
            catch (IOException e) {
                this.console.printError("Failed processing file " + cmd_1 + " " + e.getLocalizedMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                return 1;
            }
        }
        if (cmd_trimmed.startsWith("!")) {
            String shell_cmd = cmd_trimmed.substring(1);
            shell_cmd = new VariableSubstitution().substitute(ss.getConf(), shell_cmd);
            try {
                Process executor = Runtime.getRuntime().exec(shell_cmd);
                Utilities.StreamPrinter outPrinter = new Utilities.StreamPrinter(executor.getInputStream(), null, ss.out);
                Utilities.StreamPrinter errPrinter = new Utilities.StreamPrinter(executor.getErrorStream(), null, ss.err);
                outPrinter.start();
                errPrinter.start();
                ret = executor.waitFor();
                if (ret == 0) return ret;
                this.console.printError("Command failed with exit code = " + ret);
                return ret;
            }
            catch (Exception e) {
                this.console.printError("Exception raised from Shell command " + e.getLocalizedMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                return 1;
            }
        }
        if (tokens[0].toLowerCase().equals("list")) {
            Set s;
            SessionState.ResourceType t;
            if (tokens.length < 2 || (t = SessionState.find_resource_type((String)tokens[1])) == null) {
                this.console.printError("Usage: list [" + StringUtils.join((Object[])SessionState.ResourceType.values(), (String)"|") + "] [<value> [<value>]*]");
                return 1;
            }
            List<String> filter = null;
            if (tokens.length >= 3) {
                System.arraycopy(tokens, 2, tokens, 0, tokens.length - 2);
                filter = Arrays.asList(tokens);
            }
            if ((s = ss.list_resource(t, filter)) == null) return ret;
            if (s.isEmpty()) return ret;
            ss.out.println(StringUtils.join((Collection)s, (String)"\n"));
            return ret;
        }
        if (ss.isRemoteMode()) {
            String errMsg;
            HiveClient client = ss.getClient();
            PrintStream out = ss.out;
            PrintStream err = ss.err;
            try {
                List results;
                client.execute(cmd_trimmed);
                do {
                    results = client.fetchN(40);
                    for (String line : results) {
                        out.println(line);
                    }
                } while (results.size() == 40);
                return ret;
            }
            catch (HiveServerException e) {
                ret = e.getErrorCode();
                if (ret == 0) return ret;
                errMsg = e.getMessage();
                if (errMsg == null) {
                    errMsg = e.toString();
                }
                ret = e.getErrorCode();
                err.println("[Hive Error]: " + errMsg);
                return ret;
            }
            catch (TException e) {
                String errMsg2 = e.getMessage();
                if (errMsg2 == null) {
                    errMsg2 = e.toString();
                }
                ret = -10002;
                err.println("[Thrift Error]: " + errMsg2);
                return ret;
            }
            finally {
                try {
                    client.clean();
                }
                catch (TException e) {
                    errMsg = e.getMessage();
                    if (errMsg == null) {
                        errMsg = e.toString();
                    }
                    err.println("[Thrift Error]: Hive server is not cleaned due to thrift exception: " + errMsg);
                }
            }
        }
        CommandProcessor proc = CommandProcessorFactory.get((String)tokens[0], (HiveConf)((HiveConf)this.conf));
        return this.processLocalCmd(cmd, proc, ss);
    }

    void setConf(Configuration conf) {
        this.conf = conf;
    }

    private String getFirstCmd(String cmd, int length) {
        return cmd.substring(length).trim();
    }

    private String[] tokenizeCmd(String cmd) {
        return cmd.split("\\s+");
    }

    int processLocalCmd(String cmd, CommandProcessor proc, CliSessionState ss) {
        boolean needRetry;
        int tryCount = 0;
        int ret = 0;
        do {
            try {
                CommandProcessorResponse res;
                needRetry = false;
                if (proc == null) continue;
                if (proc instanceof Driver) {
                    Driver qp = (Driver)proc;
                    PrintStream out = ss.out;
                    long start = System.currentTimeMillis();
                    if (ss.getIsVerbose()) {
                        out.println(cmd);
                    }
                    qp.setTryCount(tryCount);
                    ret = qp.run(cmd).getResponseCode();
                    if (ret != 0) {
                        qp.close();
                        return ret;
                    }
                    ArrayList res2 = new ArrayList();
                    this.printHeader(qp, out);
                    int counter = 0;
                    try {
                        while (qp.getResults(res2)) {
                            for (String r : res2) {
                                out.println(r);
                            }
                            counter += res2.size();
                            res2.clear();
                            if (!out.checkError()) continue;
                            break;
                        }
                    }
                    catch (IOException e) {
                        this.console.printError("Failed with exception " + e.getClass().getName() + ":" + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                        ret = 1;
                    }
                    int cret = qp.close();
                    if (ret == 0) {
                        ret = cret;
                    }
                    long end = System.currentTimeMillis();
                    double timeTaken = (double)(end - start) / 1000.0;
                    this.console.printInfo("Time taken: " + timeTaken + " seconds" + (counter == 0 ? "" : ", Fetched: " + counter + " row(s)"));
                    continue;
                }
                String firstToken = this.tokenizeCmd(cmd.trim())[0];
                String cmd_1 = this.getFirstCmd(cmd.trim(), firstToken.length());
                if (ss.getIsVerbose()) {
                    ss.out.println(firstToken + " " + cmd_1);
                }
                if ((res = proc.run(cmd_1)).getResponseCode() != 0) {
                    ss.out.println("Query returned non-zero code: " + res.getResponseCode() + ", cause: " + res.getErrorMessage());
                }
                ret = res.getResponseCode();
            }
            catch (CommandNeedRetryException e) {
                this.console.printInfo("Retry query with a different approach...");
                ++tryCount;
                needRetry = true;
            }
        } while (needRetry);
        return ret;
    }

    private void printHeader(Driver qp, PrintStream out) {
        List fieldSchemas = qp.getSchema().getFieldSchemas();
        if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_HEADER) && fieldSchemas != null) {
            boolean first_col = true;
            for (FieldSchema fs : fieldSchemas) {
                if (!first_col) {
                    out.print('\t');
                }
                out.print(fs.getName());
                first_col = false;
            }
            out.println();
        }
    }

    public int processLine(String line) {
        return this.processLine(line, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int processLine(String line, boolean allowInterupting) {
        block10: {
            block8: {
                block9: {
                    oldSignal = null;
                    interupSignal = null;
                    if (allowInterupting) {
                        interupSignal = new Signal("INT");
                        oldSignal = Signal.handle(interupSignal, new SignalHandler(){
                            private final Thread cliThread = Thread.currentThread();
                            private boolean interruptRequested;

                            @Override
                            public void handle(Signal signal) {
                                boolean initialRequest = !this.interruptRequested;
                                this.interruptRequested = true;
                                if (!initialRequest) {
                                    CliDriver.this.console.printInfo("Exiting the JVM");
                                    System.exit(127);
                                }
                                CliDriver.this.console.printInfo("Interrupting... Be patient, this might take some time.");
                                CliDriver.this.console.printInfo("Press Ctrl+C again to kill JVM");
                                HadoopJobExecHelper.killRunningJobs();
                                HiveInterruptUtils.interrupt();
                                this.cliThread.interrupt();
                            }
                        });
                    }
                    try {
                        lastRet = 0;
                        ret = 0;
                        command = "";
                        arr$ = line.split(";");
                        len$ = arr$.length;
                        i$ = 0;
lbl13:
                        // 2 sources

                        while (i$ < len$) {
                            block11: {
                                oneCmd = arr$[i$];
                                if (!StringUtils.endsWith((String)oneCmd, (String)"\\")) break block11;
                                command = command + StringUtils.chop((String)oneCmd) + ";";
                                ** GOTO lbl-1000
                            }
                            if (!StringUtils.isBlank((String)(command = command + oneCmd))) {
                                ret = this.processCmd(command);
                                ss = SessionState.get();
                                ss.setCommandType(null);
                                command = "";
                                lastRet = ret;
                                ignoreErrors = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.CLIIGNOREERRORS);
                                if (ret != 0 && !ignoreErrors) {
                                    CommandProcessorFactory.clean((HiveConf)((HiveConf)this.conf));
                                    var14_15 = ret;
                                    if (oldSignal == null || interupSignal == null) break block8;
                                    break block9;
                                }
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl46
                    }
                    catch (Throwable var15_16) {
                        if (oldSignal != null && interupSignal != null) {
                            Signal.handle(interupSignal, oldSignal);
                        }
                        throw var15_16;
                    }
                }
                Signal.handle(interupSignal, oldSignal);
            }
            return var14_15;
lbl-1000:
            // 2 sources

            {
                ++i$;
                ** GOTO lbl13
lbl46:
                // 1 sources

                CommandProcessorFactory.clean((HiveConf)((HiveConf)this.conf));
                var8_9 = lastRet;
                if (oldSignal == null || interupSignal == null) break block10;
            }
            Signal.handle(interupSignal, oldSignal);
        }
        return var8_9;
    }

    public int processReader(BufferedReader r) throws IOException {
        String line;
        StringBuilder qsb = new StringBuilder();
        while ((line = r.readLine()) != null) {
            if (line.startsWith("--")) continue;
            qsb.append(line + "\n");
        }
        return this.processLine(qsb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processFile(String fileName) throws IOException {
        FileReader fileReader = null;
        BufferedReader bufferReader = null;
        int rc = 0;
        try {
            fileReader = new FileReader(fileName);
            bufferReader = new BufferedReader(fileReader);
            rc = this.processReader(bufferReader);
            bufferReader.close();
            bufferReader = null;
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(bufferReader);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)bufferReader);
        return rc;
    }

    public void processInitFiles(CliSessionState ss) throws IOException {
        boolean saveSilent = ss.getIsSilent();
        ss.setIsSilent(true);
        for (String initFile : ss.initFiles) {
            int rc = this.processFile(initFile);
            if (rc == 0) continue;
            System.exit(rc);
        }
        if (ss.initFiles.size() == 0) {
            String hivercUser;
            int rc;
            String hivercDefault;
            if (System.getenv("HIVE_HOME") != null && new File(hivercDefault = System.getenv("HIVE_HOME") + File.separator + "bin" + File.separator + HIVERCFILE).exists()) {
                int rc2 = this.processFile(hivercDefault);
                if (rc2 != 0) {
                    System.exit(rc2);
                }
                this.console.printError("Putting the global hiverc in $HIVE_HOME/bin/.hiverc is deprecated. Please use $HIVE_CONF_DIR/.hiverc instead.");
            }
            if (System.getenv("HIVE_CONF_DIR") != null && new File(hivercDefault = System.getenv("HIVE_CONF_DIR") + File.separator + HIVERCFILE).exists() && (rc = this.processFile(hivercDefault)) != 0) {
                System.exit(rc);
            }
            if (System.getProperty("user.home") != null && new File(hivercUser = System.getProperty("user.home") + File.separator + HIVERCFILE).exists() && (rc = this.processFile(hivercUser)) != 0) {
                System.exit(rc);
            }
        }
        ss.setIsSilent(saveSilent);
    }

    public void processSelectDatabase(CliSessionState ss) throws IOException {
        int rc;
        String database = ss.database;
        if (database != null && (rc = this.processLine("use " + database + ";")) != 0) {
            System.exit(rc);
        }
    }

    public static Completor[] getCommandCompletor() {
        SimpleCompletor sc = new SimpleCompletor(new String[0]);
        for (String s : FunctionRegistry.getFunctionNames()) {
            if (s.matches("[a-z_]+")) {
                sc.addCandidateString(s + "(");
                continue;
            }
            sc.addCandidateString(s);
        }
        for (String s : HiveParser.getKeywords()) {
            sc.addCandidateString(s);
            sc.addCandidateString(s.toLowerCase());
        }
        ArgumentCompletor.AbstractArgumentDelimiter delim = new ArgumentCompletor.AbstractArgumentDelimiter(){

            public boolean isDelimiterChar(String buffer, int pos) {
                char c = buffer.charAt(pos);
                return Character.isWhitespace(c) || c == '(' || c == ')' || c == '[' || c == ']';
            }
        };
        final ArgumentCompletor ac = new ArgumentCompletor((Completor)sc, (ArgumentCompletor.ArgumentDelimiter)delim);
        ac.setStrict(false);
        Completor completor = new Completor(){

            public int complete(String buffer, int offset, List completions) {
                List comp = completions;
                int ret = ac.complete(buffer, offset, completions);
                if (completions.size() == 1 && ((String)comp.get(0)).endsWith("( ")) {
                    comp.set(0, ((String)comp.get(0)).trim());
                }
                return ret;
            }
        };
        HiveConf.ConfVars[] confs = HiveConf.ConfVars.values();
        String[] vars = new String[confs.length];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = confs[i].varname;
        }
        SimpleCompletor conf = new SimpleCompletor(vars);
        conf.setDelimiter(".");
        SimpleCompletor set = new SimpleCompletor("set"){

            public int complete(String buffer, int cursor, List clist) {
                return buffer != null && buffer.equals("set") ? super.complete(buffer, cursor, clist) : -1;
            }
        };
        ArgumentCompletor propCompletor = new ArgumentCompletor(new Completor[]{set, conf}){

            public int complete(String buffer, int offset, List completions) {
                int ret = super.complete(buffer, offset, completions);
                if (completions.size() == 1) {
                    completions.set(0, ((String)completions.get(0)).trim());
                }
                return ret;
            }
        };
        return new Completor[]{propCompletor, completor};
    }

    public static void main(String[] args) throws Exception {
        int ret = new CliDriver().run(args);
        System.exit(ret);
    }

    public int run(String[] args) throws Exception {
        String logInitDetailMessage;
        OptionsProcessor oproc = new OptionsProcessor();
        if (!oproc.process_stage1(args)) {
            return 1;
        }
        boolean logInitFailed = false;
        try {
            logInitDetailMessage = LogUtils.initHiveLog4j();
        }
        catch (LogUtils.LogInitializationException e) {
            logInitFailed = true;
            logInitDetailMessage = e.getMessage();
        }
        CliSessionState ss = new CliSessionState(new HiveConf(SessionState.class));
        ss.in = System.in;
        try {
            ss.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            ss.info = new PrintStream((OutputStream)System.err, true, "UTF-8");
            ss.err = new CachingPrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return 3;
        }
        if (!oproc.process_stage2(ss)) {
            return 2;
        }
        if (!ss.getIsSilent()) {
            if (logInitFailed) {
                System.err.println(logInitDetailMessage);
            } else {
                SessionState.getConsole().printInfo(logInitDetailMessage);
            }
        }
        HiveConf conf = ss.getConf();
        for (Map.Entry<Object, Object> item : ss.cmdProperties.entrySet()) {
            conf.set((String)item.getKey(), (String)item.getValue());
            ss.getOverriddenConfigurations().put((String)item.getKey(), (String)item.getValue());
        }
        prompt = conf.getVar(HiveConf.ConfVars.CLIPROMPT);
        prompt = new VariableSubstitution().substitute(conf, prompt);
        prompt2 = CliDriver.spacesForString(prompt);
        SessionState.start((SessionState)ss);
        int ret = 0;
        try {
            ret = this.executeDriver(ss, conf, oproc);
        }
        catch (Exception e) {
            ss.close();
            throw e;
        }
        ss.close();
        return ret;
    }

    private int executeDriver(CliSessionState ss, HiveConf conf, OptionsProcessor oproc) throws Exception {
        String line;
        if (ss.getHost() != null) {
            ss.connect();
            if (ss.isRemoteMode()) {
                prompt = "[" + ss.host + ':' + ss.port + "] " + prompt;
                char[] spaces = new char[prompt.length()];
                Arrays.fill(spaces, ' ');
                prompt2 = new String(spaces);
            }
        }
        if (!ss.isRemoteMode() && !ShimLoader.getHadoopShims().usesJobShell()) {
            ClassLoader loader = conf.getClassLoader();
            String auxJars = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEAUXJARS);
            if (StringUtils.isNotBlank((String)auxJars)) {
                loader = Utilities.addToClassPath((ClassLoader)loader, (String[])StringUtils.split((String)auxJars, (String)","));
            }
            conf.setClassLoader(loader);
            Thread.currentThread().setContextClassLoader(loader);
        }
        CliDriver cli = new CliDriver();
        cli.setHiveVariables(oproc.getHiveVariables());
        cli.processSelectDatabase(ss);
        cli.processInitFiles(ss);
        if (ss.execString != null) {
            int cmdProcessStatus = cli.processLine(ss.execString);
            return cmdProcessStatus;
        }
        try {
            if (ss.fileName != null) {
                return cli.processFile(ss.fileName);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not open input file for reading. (" + e.getMessage() + ")");
            return 3;
        }
        ConsoleReader reader = this.getConsoleReader();
        reader.setBellEnabled(false);
        for (Completor completor : CliDriver.getCommandCompletor()) {
            reader.addCompletor(completor);
        }
        String HISTORYFILE = ".hivehistory";
        String historyDirectory = System.getProperty("user.home");
        try {
            if (new File(historyDirectory).exists()) {
                String historyFile = historyDirectory + File.separator + ".hivehistory";
                reader.setHistory(new History(new File(historyFile)));
            } else {
                System.err.println("WARNING: Directory for Hive history file: " + historyDirectory + " does not exist.   History will not be available during this session.");
            }
        }
        catch (Exception e) {
            System.err.println("WARNING: Encountered an error while trying to initialize Hive's history file.  History will not be available during this session.");
            System.err.println(e.getMessage());
        }
        int ret = 0;
        String prefix = "";
        String curDB = CliDriver.getFormattedDb(conf, ss);
        String curPrompt = prompt + curDB;
        String dbSpaces = CliDriver.spacesForString(curDB);
        while ((line = reader.readLine(curPrompt + "> ")) != null) {
            if (!prefix.equals("")) {
                prefix = prefix + '\n';
            }
            if (line.trim().endsWith(";") && !line.trim().endsWith("\\;")) {
                line = prefix + line;
                ret = cli.processLine(line, true);
                prefix = "";
                curDB = CliDriver.getFormattedDb(conf, ss);
                curPrompt = prompt + curDB;
                dbSpaces = dbSpaces.length() == curDB.length() ? dbSpaces : CliDriver.spacesForString(curDB);
                continue;
            }
            prefix = prefix + line;
            curPrompt = prompt2 + dbSpaces;
        }
        return ret;
    }

    protected ConsoleReader getConsoleReader() throws IOException {
        return new ConsoleReader();
    }

    private static String getFormattedDb(HiveConf conf, CliSessionState ss) {
        if (!HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.CLIPRINTCURRENTDB)) {
            return "";
        }
        String currDb = SessionState.get().getCurrentDatabase();
        if (currDb == null) {
            return "";
        }
        return " (" + currDb + ")";
    }

    private static String spacesForString(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        return String.format("%1$-" + s.length() + "s", "");
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        SessionState.get().setHiveVariables(hiveVariables);
    }
}

