<?php
namespace metastore;
/**
 * Autogenerated by Thrift Compiler (0.9.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Exception\TApplicationException;


interface ThriftHiveMetastoreIf extends \FacebookServiceIf {
  public function create_database(\metastore\Database $database);
  public function get_database($name);
  public function drop_database($name, $deleteData, $cascade);
  public function get_databases($pattern);
  public function get_all_databases();
  public function alter_database($dbname, \metastore\Database $db);
  public function get_type($name);
  public function create_type(\metastore\Type $type);
  public function drop_type($type);
  public function get_type_all($name);
  public function get_fields($db_name, $table_name);
  public function get_schema($db_name, $table_name);
  public function create_table(\metastore\Table $tbl);
  public function create_table_with_environment_context(\metastore\Table $tbl, \metastore\EnvironmentContext $environment_context);
  public function drop_table($dbname, $name, $deleteData);
  public function drop_table_with_environment_context($dbname, $name, $deleteData, \metastore\EnvironmentContext $environment_context);
  public function get_tables($db_name, $pattern);
  public function get_all_tables($db_name);
  public function get_table($dbname, $tbl_name);
  public function get_table_objects_by_name($dbname, $tbl_names);
  public function get_table_names_by_filter($dbname, $filter, $max_tables);
  public function alter_table($dbname, $tbl_name, \metastore\Table $new_tbl);
  public function alter_table_with_environment_context($dbname, $tbl_name, \metastore\Table $new_tbl, \metastore\EnvironmentContext $environment_context);
  public function add_partition(\metastore\Partition $new_part);
  public function add_partition_with_environment_context(\metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context);
  public function add_partitions($new_parts);
  public function append_partition($db_name, $tbl_name, $part_vals);
  public function append_partition_with_environment_context($db_name, $tbl_name, $part_vals, \metastore\EnvironmentContext $environment_context);
  public function append_partition_by_name($db_name, $tbl_name, $part_name);
  public function append_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, \metastore\EnvironmentContext $environment_context);
  public function drop_partition($db_name, $tbl_name, $part_vals, $deleteData);
  public function drop_partition_with_environment_context($db_name, $tbl_name, $part_vals, $deleteData, \metastore\EnvironmentContext $environment_context);
  public function drop_partition_by_name($db_name, $tbl_name, $part_name, $deleteData);
  public function drop_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $deleteData, \metastore\EnvironmentContext $environment_context);
  public function get_partition($db_name, $tbl_name, $part_vals);
  public function exchange_partition($partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name);
  public function get_partition_with_auth($db_name, $tbl_name, $part_vals, $user_name, $group_names);
  public function get_partition_by_name($db_name, $tbl_name, $part_name);
  public function get_partitions($db_name, $tbl_name, $max_parts);
  public function get_partitions_with_auth($db_name, $tbl_name, $max_parts, $user_name, $group_names);
  public function get_partition_names($db_name, $tbl_name, $max_parts);
  public function get_partitions_ps($db_name, $tbl_name, $part_vals, $max_parts);
  public function get_partitions_ps_with_auth($db_name, $tbl_name, $part_vals, $max_parts, $user_name, $group_names);
  public function get_partition_names_ps($db_name, $tbl_name, $part_vals, $max_parts);
  public function get_partitions_by_filter($db_name, $tbl_name, $filter, $max_parts);
  public function get_partitions_by_names($db_name, $tbl_name, $names);
  public function alter_partition($db_name, $tbl_name, \metastore\Partition $new_part);
  public function alter_partitions($db_name, $tbl_name, $new_parts);
  public function alter_partition_with_environment_context($db_name, $tbl_name, \metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context);
  public function rename_partition($db_name, $tbl_name, $part_vals, \metastore\Partition $new_part);
  public function partition_name_has_valid_characters($part_vals, $throw_exception);
  public function get_config_value($name, $defaultValue);
  public function partition_name_to_vals($part_name);
  public function partition_name_to_spec($part_name);
  public function markPartitionForEvent($db_name, $tbl_name, $part_vals, $eventType);
  public function isPartitionMarkedForEvent($db_name, $tbl_name, $part_vals, $eventType);
  public function add_index(\metastore\Index $new_index, \metastore\Table $index_table);
  public function alter_index($dbname, $base_tbl_name, $idx_name, \metastore\Index $new_idx);
  public function drop_index_by_name($db_name, $tbl_name, $index_name, $deleteData);
  public function get_index_by_name($db_name, $tbl_name, $index_name);
  public function get_indexes($db_name, $tbl_name, $max_indexes);
  public function get_index_names($db_name, $tbl_name, $max_indexes);
  public function update_table_column_statistics(\metastore\ColumnStatistics $stats_obj);
  public function update_partition_column_statistics(\metastore\ColumnStatistics $stats_obj);
  public function get_table_column_statistics($db_name, $tbl_name, $col_name);
  public function get_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name);
  public function delete_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name);
  public function delete_table_column_statistics($db_name, $tbl_name, $col_name);
  public function create_role(\metastore\Role $role);
  public function drop_role($role_name);
  public function get_role_names();
  public function grant_role($role_name, $principal_name, $principal_type, $grantor, $grantorType, $grant_option);
  public function revoke_role($role_name, $principal_name, $principal_type);
  public function list_roles($principal_name, $principal_type);
  public function get_privilege_set(\metastore\HiveObjectRef $hiveObject, $user_name, $group_names);
  public function list_privileges($principal_name, $principal_type, \metastore\HiveObjectRef $hiveObject);
  public function grant_privileges(\metastore\PrivilegeBag $privileges);
  public function revoke_privileges(\metastore\PrivilegeBag $privileges);
  public function set_ugi($user_name, $group_names);
  public function get_delegation_token($token_owner, $renewer_kerberos_principal_name);
  public function renew_delegation_token($token_str_form);
  public function cancel_delegation_token($token_str_form);
}

class ThriftHiveMetastoreClient extends \FacebookServiceClient implements \metastore\ThriftHiveMetastoreIf {
  public function __construct($input, $output=null) {
    parent::__construct($input, $output);
  }

  public function create_database(\metastore\Database $database)
  {
    $this->send_create_database($database);
    $this->recv_create_database();
  }

  public function send_create_database(\metastore\Database $database)
  {
    $args = new \metastore\ThriftHiveMetastore_create_database_args();
    $args->database = $database;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_database', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_database', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_database()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_database_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_database_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function get_database($name)
  {
    $this->send_get_database($name);
    return $this->recv_get_database();
  }

  public function send_get_database($name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_database_args();
    $args->name = $name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_database', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_database', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_database()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_database_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_database_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_database failed: unknown result");
  }

  public function drop_database($name, $deleteData, $cascade)
  {
    $this->send_drop_database($name, $deleteData, $cascade);
    $this->recv_drop_database();
  }

  public function send_drop_database($name, $deleteData, $cascade)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_database_args();
    $args->name = $name;
    $args->deleteData = $deleteData;
    $args->cascade = $cascade;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_database', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_database', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_database()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_database_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_database_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function get_databases($pattern)
  {
    $this->send_get_databases($pattern);
    return $this->recv_get_databases();
  }

  public function send_get_databases($pattern)
  {
    $args = new \metastore\ThriftHiveMetastore_get_databases_args();
    $args->pattern = $pattern;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_databases', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_databases', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_databases()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_databases_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_databases_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_databases failed: unknown result");
  }

  public function get_all_databases()
  {
    $this->send_get_all_databases();
    return $this->recv_get_all_databases();
  }

  public function send_get_all_databases()
  {
    $args = new \metastore\ThriftHiveMetastore_get_all_databases_args();
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_all_databases', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_all_databases', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_all_databases()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_all_databases_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_all_databases_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_all_databases failed: unknown result");
  }

  public function alter_database($dbname, \metastore\Database $db)
  {
    $this->send_alter_database($dbname, $db);
    $this->recv_alter_database();
  }

  public function send_alter_database($dbname, \metastore\Database $db)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_database_args();
    $args->dbname = $dbname;
    $args->db = $db;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_database', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_database', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_database()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_database_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_database_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function get_type($name)
  {
    $this->send_get_type($name);
    return $this->recv_get_type();
  }

  public function send_get_type($name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_type_args();
    $args->name = $name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_type', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_type', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_type()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_type_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_type_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_type failed: unknown result");
  }

  public function create_type(\metastore\Type $type)
  {
    $this->send_create_type($type);
    return $this->recv_create_type();
  }

  public function send_create_type(\metastore\Type $type)
  {
    $args = new \metastore\ThriftHiveMetastore_create_type_args();
    $args->type = $type;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_type', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_type', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_type()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_type_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_type_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("create_type failed: unknown result");
  }

  public function drop_type($type)
  {
    $this->send_drop_type($type);
    return $this->recv_drop_type();
  }

  public function send_drop_type($type)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_type_args();
    $args->type = $type;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_type', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_type', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_type()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_type_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_type_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_type failed: unknown result");
  }

  public function get_type_all($name)
  {
    $this->send_get_type_all($name);
    return $this->recv_get_type_all();
  }

  public function send_get_type_all($name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_type_all_args();
    $args->name = $name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_type_all', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_type_all', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_type_all()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_type_all_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_type_all_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_type_all failed: unknown result");
  }

  public function get_fields($db_name, $table_name)
  {
    $this->send_get_fields($db_name, $table_name);
    return $this->recv_get_fields();
  }

  public function send_get_fields($db_name, $table_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_fields_args();
    $args->db_name = $db_name;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_fields', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_fields', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_fields()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_fields_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_fields_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_fields failed: unknown result");
  }

  public function get_schema($db_name, $table_name)
  {
    $this->send_get_schema($db_name, $table_name);
    return $this->recv_get_schema();
  }

  public function send_get_schema($db_name, $table_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_schema_args();
    $args->db_name = $db_name;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_schema', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_schema', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_schema()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_schema_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_schema_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_schema failed: unknown result");
  }

  public function create_table(\metastore\Table $tbl)
  {
    $this->send_create_table($tbl);
    $this->recv_create_table();
  }

  public function send_create_table(\metastore\Table $tbl)
  {
    $args = new \metastore\ThriftHiveMetastore_create_table_args();
    $args->tbl = $tbl;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_table()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    return;
  }

  public function create_table_with_environment_context(\metastore\Table $tbl, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_create_table_with_environment_context($tbl, $environment_context);
    $this->recv_create_table_with_environment_context();
  }

  public function send_create_table_with_environment_context(\metastore\Table $tbl, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_create_table_with_environment_context_args();
    $args->tbl = $tbl;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_table_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_table_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_table_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_table_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_table_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    return;
  }

  public function drop_table($dbname, $name, $deleteData)
  {
    $this->send_drop_table($dbname, $name, $deleteData);
    $this->recv_drop_table();
  }

  public function send_drop_table($dbname, $name, $deleteData)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_table_args();
    $args->dbname = $dbname;
    $args->name = $name;
    $args->deleteData = $deleteData;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_table()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function drop_table_with_environment_context($dbname, $name, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_drop_table_with_environment_context($dbname, $name, $deleteData, $environment_context);
    $this->recv_drop_table_with_environment_context();
  }

  public function send_drop_table_with_environment_context($dbname, $name, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_table_with_environment_context_args();
    $args->dbname = $dbname;
    $args->name = $name;
    $args->deleteData = $deleteData;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_table_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_table_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_table_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_table_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_table_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function get_tables($db_name, $pattern)
  {
    $this->send_get_tables($db_name, $pattern);
    return $this->recv_get_tables();
  }

  public function send_get_tables($db_name, $pattern)
  {
    $args = new \metastore\ThriftHiveMetastore_get_tables_args();
    $args->db_name = $db_name;
    $args->pattern = $pattern;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_tables', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_tables', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_tables()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_tables_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_tables_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_tables failed: unknown result");
  }

  public function get_all_tables($db_name)
  {
    $this->send_get_all_tables($db_name);
    return $this->recv_get_all_tables();
  }

  public function send_get_all_tables($db_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_all_tables_args();
    $args->db_name = $db_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_all_tables', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_all_tables', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_all_tables()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_all_tables_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_all_tables_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_all_tables failed: unknown result");
  }

  public function get_table($dbname, $tbl_name)
  {
    $this->send_get_table($dbname, $tbl_name);
    return $this->recv_get_table();
  }

  public function send_get_table($dbname, $tbl_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_args();
    $args->dbname = $dbname;
    $args->tbl_name = $tbl_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_table failed: unknown result");
  }

  public function get_table_objects_by_name($dbname, $tbl_names)
  {
    $this->send_get_table_objects_by_name($dbname, $tbl_names);
    return $this->recv_get_table_objects_by_name();
  }

  public function send_get_table_objects_by_name($dbname, $tbl_names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_objects_by_name_args();
    $args->dbname = $dbname;
    $args->tbl_names = $tbl_names;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_objects_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_objects_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_objects_by_name()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_objects_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_objects_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_table_objects_by_name failed: unknown result");
  }

  public function get_table_names_by_filter($dbname, $filter, $max_tables)
  {
    $this->send_get_table_names_by_filter($dbname, $filter, $max_tables);
    return $this->recv_get_table_names_by_filter();
  }

  public function send_get_table_names_by_filter($dbname, $filter, $max_tables)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_names_by_filter_args();
    $args->dbname = $dbname;
    $args->filter = $filter;
    $args->max_tables = $max_tables;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_names_by_filter', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_names_by_filter', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_names_by_filter()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_names_by_filter_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_names_by_filter_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_table_names_by_filter failed: unknown result");
  }

  public function alter_table($dbname, $tbl_name, \metastore\Table $new_tbl)
  {
    $this->send_alter_table($dbname, $tbl_name, $new_tbl);
    $this->recv_alter_table();
  }

  public function send_alter_table($dbname, $tbl_name, \metastore\Table $new_tbl)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_table_args();
    $args->dbname = $dbname;
    $args->tbl_name = $tbl_name;
    $args->new_tbl = $new_tbl;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_table()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function alter_table_with_environment_context($dbname, $tbl_name, \metastore\Table $new_tbl, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_alter_table_with_environment_context($dbname, $tbl_name, $new_tbl, $environment_context);
    $this->recv_alter_table_with_environment_context();
  }

  public function send_alter_table_with_environment_context($dbname, $tbl_name, \metastore\Table $new_tbl, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_table_with_environment_context_args();
    $args->dbname = $dbname;
    $args->tbl_name = $tbl_name;
    $args->new_tbl = $new_tbl;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_table_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_table_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_table_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_table_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_table_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function add_partition(\metastore\Partition $new_part)
  {
    $this->send_add_partition($new_part);
    return $this->recv_add_partition();
  }

  public function send_add_partition(\metastore\Partition $new_part)
  {
    $args = new \metastore\ThriftHiveMetastore_add_partition_args();
    $args->new_part = $new_part;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_partition()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_partition failed: unknown result");
  }

  public function add_partition_with_environment_context(\metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_add_partition_with_environment_context($new_part, $environment_context);
    return $this->recv_add_partition_with_environment_context();
  }

  public function send_add_partition_with_environment_context(\metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_add_partition_with_environment_context_args();
    $args->new_part = $new_part;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_partition_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_partition_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_partition_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_partition_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_partition_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_partition_with_environment_context failed: unknown result");
  }

  public function add_partitions($new_parts)
  {
    $this->send_add_partitions($new_parts);
    return $this->recv_add_partitions();
  }

  public function send_add_partitions($new_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_add_partitions_args();
    $args->new_parts = $new_parts;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_partitions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_partitions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_partitions()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_partitions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_partitions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_partitions failed: unknown result");
  }

  public function append_partition($db_name, $tbl_name, $part_vals)
  {
    $this->send_append_partition($db_name, $tbl_name, $part_vals);
    return $this->recv_append_partition();
  }

  public function send_append_partition($db_name, $tbl_name, $part_vals)
  {
    $args = new \metastore\ThriftHiveMetastore_append_partition_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'append_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('append_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_append_partition()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_append_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_append_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("append_partition failed: unknown result");
  }

  public function append_partition_with_environment_context($db_name, $tbl_name, $part_vals, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_append_partition_with_environment_context($db_name, $tbl_name, $part_vals, $environment_context);
    return $this->recv_append_partition_with_environment_context();
  }

  public function send_append_partition_with_environment_context($db_name, $tbl_name, $part_vals, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_append_partition_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'append_partition_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('append_partition_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_append_partition_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_append_partition_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_append_partition_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("append_partition_with_environment_context failed: unknown result");
  }

  public function append_partition_by_name($db_name, $tbl_name, $part_name)
  {
    $this->send_append_partition_by_name($db_name, $tbl_name, $part_name);
    return $this->recv_append_partition_by_name();
  }

  public function send_append_partition_by_name($db_name, $tbl_name, $part_name)
  {
    $args = new \metastore\ThriftHiveMetastore_append_partition_by_name_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'append_partition_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('append_partition_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_append_partition_by_name()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_append_partition_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_append_partition_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("append_partition_by_name failed: unknown result");
  }

  public function append_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_append_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $environment_context);
    return $this->recv_append_partition_by_name_with_environment_context();
  }

  public function send_append_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_append_partition_by_name_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'append_partition_by_name_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('append_partition_by_name_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_append_partition_by_name_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_append_partition_by_name_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_append_partition_by_name_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("append_partition_by_name_with_environment_context failed: unknown result");
  }

  public function drop_partition($db_name, $tbl_name, $part_vals, $deleteData)
  {
    $this->send_drop_partition($db_name, $tbl_name, $part_vals, $deleteData);
    return $this->recv_drop_partition();
  }

  public function send_drop_partition($db_name, $tbl_name, $part_vals, $deleteData)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_partition_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->deleteData = $deleteData;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_partition()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_partition failed: unknown result");
  }

  public function drop_partition_with_environment_context($db_name, $tbl_name, $part_vals, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_drop_partition_with_environment_context($db_name, $tbl_name, $part_vals, $deleteData, $environment_context);
    return $this->recv_drop_partition_with_environment_context();
  }

  public function send_drop_partition_with_environment_context($db_name, $tbl_name, $part_vals, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_partition_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->deleteData = $deleteData;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_partition_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_partition_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_partition_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_partition_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_partition_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_partition_with_environment_context failed: unknown result");
  }

  public function drop_partition_by_name($db_name, $tbl_name, $part_name, $deleteData)
  {
    $this->send_drop_partition_by_name($db_name, $tbl_name, $part_name, $deleteData);
    return $this->recv_drop_partition_by_name();
  }

  public function send_drop_partition_by_name($db_name, $tbl_name, $part_name, $deleteData)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_partition_by_name_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $args->deleteData = $deleteData;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_partition_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_partition_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_partition_by_name()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_partition_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_partition_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_partition_by_name failed: unknown result");
  }

  public function drop_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_drop_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $deleteData, $environment_context);
    return $this->recv_drop_partition_by_name_with_environment_context();
  }

  public function send_drop_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_partition_by_name_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $args->deleteData = $deleteData;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_partition_by_name_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_partition_by_name_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_partition_by_name_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_partition_by_name_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_partition_by_name_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_partition_by_name_with_environment_context failed: unknown result");
  }

  public function get_partition($db_name, $tbl_name, $part_vals)
  {
    $this->send_get_partition($db_name, $tbl_name, $part_vals);
    return $this->recv_get_partition();
  }

  public function send_get_partition($db_name, $tbl_name, $part_vals)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition failed: unknown result");
  }

  public function exchange_partition($partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name)
  {
    $this->send_exchange_partition($partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name);
    return $this->recv_exchange_partition();
  }

  public function send_exchange_partition($partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name)
  {
    $args = new \metastore\ThriftHiveMetastore_exchange_partition_args();
    $args->partitionSpecs = $partitionSpecs;
    $args->source_db = $source_db;
    $args->source_table_name = $source_table_name;
    $args->dest_db = $dest_db;
    $args->dest_table_name = $dest_table_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'exchange_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('exchange_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_exchange_partition()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_exchange_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_exchange_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("exchange_partition failed: unknown result");
  }

  public function get_partition_with_auth($db_name, $tbl_name, $part_vals, $user_name, $group_names)
  {
    $this->send_get_partition_with_auth($db_name, $tbl_name, $part_vals, $user_name, $group_names);
    return $this->recv_get_partition_with_auth();
  }

  public function send_get_partition_with_auth($db_name, $tbl_name, $part_vals, $user_name, $group_names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_with_auth_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->user_name = $user_name;
    $args->group_names = $group_names;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_with_auth', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_with_auth', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_with_auth()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_with_auth_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_with_auth_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition_with_auth failed: unknown result");
  }

  public function get_partition_by_name($db_name, $tbl_name, $part_name)
  {
    $this->send_get_partition_by_name($db_name, $tbl_name, $part_name);
    return $this->recv_get_partition_by_name();
  }

  public function send_get_partition_by_name($db_name, $tbl_name, $part_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_by_name_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_by_name()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition_by_name failed: unknown result");
  }

  public function get_partitions($db_name, $tbl_name, $max_parts)
  {
    $this->send_get_partitions($db_name, $tbl_name, $max_parts);
    return $this->recv_get_partitions();
  }

  public function send_get_partitions($db_name, $tbl_name, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions failed: unknown result");
  }

  public function get_partitions_with_auth($db_name, $tbl_name, $max_parts, $user_name, $group_names)
  {
    $this->send_get_partitions_with_auth($db_name, $tbl_name, $max_parts, $user_name, $group_names);
    return $this->recv_get_partitions_with_auth();
  }

  public function send_get_partitions_with_auth($db_name, $tbl_name, $max_parts, $user_name, $group_names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_with_auth_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_parts = $max_parts;
    $args->user_name = $user_name;
    $args->group_names = $group_names;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_with_auth', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_with_auth', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_with_auth()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_with_auth_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_with_auth_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_with_auth failed: unknown result");
  }

  public function get_partition_names($db_name, $tbl_name, $max_parts)
  {
    $this->send_get_partition_names($db_name, $tbl_name, $max_parts);
    return $this->recv_get_partition_names();
  }

  public function send_get_partition_names($db_name, $tbl_name, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_names_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_names', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_names', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_names()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_names_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_names_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition_names failed: unknown result");
  }

  public function get_partitions_ps($db_name, $tbl_name, $part_vals, $max_parts)
  {
    $this->send_get_partitions_ps($db_name, $tbl_name, $part_vals, $max_parts);
    return $this->recv_get_partitions_ps();
  }

  public function send_get_partitions_ps($db_name, $tbl_name, $part_vals, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_ps_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_ps', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_ps', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_ps()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_ps_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_ps_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_ps failed: unknown result");
  }

  public function get_partitions_ps_with_auth($db_name, $tbl_name, $part_vals, $max_parts, $user_name, $group_names)
  {
    $this->send_get_partitions_ps_with_auth($db_name, $tbl_name, $part_vals, $max_parts, $user_name, $group_names);
    return $this->recv_get_partitions_ps_with_auth();
  }

  public function send_get_partitions_ps_with_auth($db_name, $tbl_name, $part_vals, $max_parts, $user_name, $group_names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_ps_with_auth_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->max_parts = $max_parts;
    $args->user_name = $user_name;
    $args->group_names = $group_names;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_ps_with_auth', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_ps_with_auth', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_ps_with_auth()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_ps_with_auth_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_ps_with_auth_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_ps_with_auth failed: unknown result");
  }

  public function get_partition_names_ps($db_name, $tbl_name, $part_vals, $max_parts)
  {
    $this->send_get_partition_names_ps($db_name, $tbl_name, $part_vals, $max_parts);
    return $this->recv_get_partition_names_ps();
  }

  public function send_get_partition_names_ps($db_name, $tbl_name, $part_vals, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_names_ps_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_names_ps', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_names_ps', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_names_ps()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_names_ps_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_names_ps_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition_names_ps failed: unknown result");
  }

  public function get_partitions_by_filter($db_name, $tbl_name, $filter, $max_parts)
  {
    $this->send_get_partitions_by_filter($db_name, $tbl_name, $filter, $max_parts);
    return $this->recv_get_partitions_by_filter();
  }

  public function send_get_partitions_by_filter($db_name, $tbl_name, $filter, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_by_filter_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->filter = $filter;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_by_filter', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_by_filter', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_by_filter()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_by_filter_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_by_filter_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_by_filter failed: unknown result");
  }

  public function get_partitions_by_names($db_name, $tbl_name, $names)
  {
    $this->send_get_partitions_by_names($db_name, $tbl_name, $names);
    return $this->recv_get_partitions_by_names();
  }

  public function send_get_partitions_by_names($db_name, $tbl_name, $names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_by_names_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->names = $names;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_by_names', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_by_names', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_by_names()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_by_names_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_by_names_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_by_names failed: unknown result");
  }

  public function alter_partition($db_name, $tbl_name, \metastore\Partition $new_part)
  {
    $this->send_alter_partition($db_name, $tbl_name, $new_part);
    $this->recv_alter_partition();
  }

  public function send_alter_partition($db_name, $tbl_name, \metastore\Partition $new_part)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_partition_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->new_part = $new_part;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_partition()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function alter_partitions($db_name, $tbl_name, $new_parts)
  {
    $this->send_alter_partitions($db_name, $tbl_name, $new_parts);
    $this->recv_alter_partitions();
  }

  public function send_alter_partitions($db_name, $tbl_name, $new_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_partitions_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->new_parts = $new_parts;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_partitions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_partitions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_partitions()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_partitions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_partitions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function alter_partition_with_environment_context($db_name, $tbl_name, \metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_alter_partition_with_environment_context($db_name, $tbl_name, $new_part, $environment_context);
    $this->recv_alter_partition_with_environment_context();
  }

  public function send_alter_partition_with_environment_context($db_name, $tbl_name, \metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_partition_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->new_part = $new_part;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_partition_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_partition_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_partition_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_partition_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_partition_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function rename_partition($db_name, $tbl_name, $part_vals, \metastore\Partition $new_part)
  {
    $this->send_rename_partition($db_name, $tbl_name, $part_vals, $new_part);
    $this->recv_rename_partition();
  }

  public function send_rename_partition($db_name, $tbl_name, $part_vals, \metastore\Partition $new_part)
  {
    $args = new \metastore\ThriftHiveMetastore_rename_partition_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->new_part = $new_part;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'rename_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('rename_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_rename_partition()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_rename_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_rename_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function partition_name_has_valid_characters($part_vals, $throw_exception)
  {
    $this->send_partition_name_has_valid_characters($part_vals, $throw_exception);
    return $this->recv_partition_name_has_valid_characters();
  }

  public function send_partition_name_has_valid_characters($part_vals, $throw_exception)
  {
    $args = new \metastore\ThriftHiveMetastore_partition_name_has_valid_characters_args();
    $args->part_vals = $part_vals;
    $args->throw_exception = $throw_exception;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'partition_name_has_valid_characters', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('partition_name_has_valid_characters', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_partition_name_has_valid_characters()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_partition_name_has_valid_characters_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_partition_name_has_valid_characters_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("partition_name_has_valid_characters failed: unknown result");
  }

  public function get_config_value($name, $defaultValue)
  {
    $this->send_get_config_value($name, $defaultValue);
    return $this->recv_get_config_value();
  }

  public function send_get_config_value($name, $defaultValue)
  {
    $args = new \metastore\ThriftHiveMetastore_get_config_value_args();
    $args->name = $name;
    $args->defaultValue = $defaultValue;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_config_value', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_config_value', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_config_value()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_config_value_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_config_value_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_config_value failed: unknown result");
  }

  public function partition_name_to_vals($part_name)
  {
    $this->send_partition_name_to_vals($part_name);
    return $this->recv_partition_name_to_vals();
  }

  public function send_partition_name_to_vals($part_name)
  {
    $args = new \metastore\ThriftHiveMetastore_partition_name_to_vals_args();
    $args->part_name = $part_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'partition_name_to_vals', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('partition_name_to_vals', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_partition_name_to_vals()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_partition_name_to_vals_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_partition_name_to_vals_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("partition_name_to_vals failed: unknown result");
  }

  public function partition_name_to_spec($part_name)
  {
    $this->send_partition_name_to_spec($part_name);
    return $this->recv_partition_name_to_spec();
  }

  public function send_partition_name_to_spec($part_name)
  {
    $args = new \metastore\ThriftHiveMetastore_partition_name_to_spec_args();
    $args->part_name = $part_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'partition_name_to_spec', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('partition_name_to_spec', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_partition_name_to_spec()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_partition_name_to_spec_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_partition_name_to_spec_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("partition_name_to_spec failed: unknown result");
  }

  public function markPartitionForEvent($db_name, $tbl_name, $part_vals, $eventType)
  {
    $this->send_markPartitionForEvent($db_name, $tbl_name, $part_vals, $eventType);
    $this->recv_markPartitionForEvent();
  }

  public function send_markPartitionForEvent($db_name, $tbl_name, $part_vals, $eventType)
  {
    $args = new \metastore\ThriftHiveMetastore_markPartitionForEvent_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->eventType = $eventType;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'markPartitionForEvent', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('markPartitionForEvent', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_markPartitionForEvent()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_markPartitionForEvent_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_markPartitionForEvent_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    if ($result->o5 !== null) {
      throw $result->o5;
    }
    if ($result->o6 !== null) {
      throw $result->o6;
    }
    return;
  }

  public function isPartitionMarkedForEvent($db_name, $tbl_name, $part_vals, $eventType)
  {
    $this->send_isPartitionMarkedForEvent($db_name, $tbl_name, $part_vals, $eventType);
    return $this->recv_isPartitionMarkedForEvent();
  }

  public function send_isPartitionMarkedForEvent($db_name, $tbl_name, $part_vals, $eventType)
  {
    $args = new \metastore\ThriftHiveMetastore_isPartitionMarkedForEvent_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->eventType = $eventType;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'isPartitionMarkedForEvent', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('isPartitionMarkedForEvent', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_isPartitionMarkedForEvent()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_isPartitionMarkedForEvent_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_isPartitionMarkedForEvent_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    if ($result->o5 !== null) {
      throw $result->o5;
    }
    if ($result->o6 !== null) {
      throw $result->o6;
    }
    throw new \Exception("isPartitionMarkedForEvent failed: unknown result");
  }

  public function add_index(\metastore\Index $new_index, \metastore\Table $index_table)
  {
    $this->send_add_index($new_index, $index_table);
    return $this->recv_add_index();
  }

  public function send_add_index(\metastore\Index $new_index, \metastore\Table $index_table)
  {
    $args = new \metastore\ThriftHiveMetastore_add_index_args();
    $args->new_index = $new_index;
    $args->index_table = $index_table;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_index', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_index', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_index()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_index_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_index_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_index failed: unknown result");
  }

  public function alter_index($dbname, $base_tbl_name, $idx_name, \metastore\Index $new_idx)
  {
    $this->send_alter_index($dbname, $base_tbl_name, $idx_name, $new_idx);
    $this->recv_alter_index();
  }

  public function send_alter_index($dbname, $base_tbl_name, $idx_name, \metastore\Index $new_idx)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_index_args();
    $args->dbname = $dbname;
    $args->base_tbl_name = $base_tbl_name;
    $args->idx_name = $idx_name;
    $args->new_idx = $new_idx;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_index', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_index', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_index()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_index_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_index_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function drop_index_by_name($db_name, $tbl_name, $index_name, $deleteData)
  {
    $this->send_drop_index_by_name($db_name, $tbl_name, $index_name, $deleteData);
    return $this->recv_drop_index_by_name();
  }

  public function send_drop_index_by_name($db_name, $tbl_name, $index_name, $deleteData)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_index_by_name_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->index_name = $index_name;
    $args->deleteData = $deleteData;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_index_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_index_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_index_by_name()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_index_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_index_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_index_by_name failed: unknown result");
  }

  public function get_index_by_name($db_name, $tbl_name, $index_name)
  {
    $this->send_get_index_by_name($db_name, $tbl_name, $index_name);
    return $this->recv_get_index_by_name();
  }

  public function send_get_index_by_name($db_name, $tbl_name, $index_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_index_by_name_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->index_name = $index_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_index_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_index_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_index_by_name()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_index_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_index_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_index_by_name failed: unknown result");
  }

  public function get_indexes($db_name, $tbl_name, $max_indexes)
  {
    $this->send_get_indexes($db_name, $tbl_name, $max_indexes);
    return $this->recv_get_indexes();
  }

  public function send_get_indexes($db_name, $tbl_name, $max_indexes)
  {
    $args = new \metastore\ThriftHiveMetastore_get_indexes_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_indexes = $max_indexes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_indexes', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_indexes', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_indexes()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_indexes_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_indexes_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_indexes failed: unknown result");
  }

  public function get_index_names($db_name, $tbl_name, $max_indexes)
  {
    $this->send_get_index_names($db_name, $tbl_name, $max_indexes);
    return $this->recv_get_index_names();
  }

  public function send_get_index_names($db_name, $tbl_name, $max_indexes)
  {
    $args = new \metastore\ThriftHiveMetastore_get_index_names_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_indexes = $max_indexes;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_index_names', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_index_names', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_index_names()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_index_names_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_index_names_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_index_names failed: unknown result");
  }

  public function update_table_column_statistics(\metastore\ColumnStatistics $stats_obj)
  {
    $this->send_update_table_column_statistics($stats_obj);
    return $this->recv_update_table_column_statistics();
  }

  public function send_update_table_column_statistics(\metastore\ColumnStatistics $stats_obj)
  {
    $args = new \metastore\ThriftHiveMetastore_update_table_column_statistics_args();
    $args->stats_obj = $stats_obj;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'update_table_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('update_table_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_update_table_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_update_table_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_update_table_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("update_table_column_statistics failed: unknown result");
  }

  public function update_partition_column_statistics(\metastore\ColumnStatistics $stats_obj)
  {
    $this->send_update_partition_column_statistics($stats_obj);
    return $this->recv_update_partition_column_statistics();
  }

  public function send_update_partition_column_statistics(\metastore\ColumnStatistics $stats_obj)
  {
    $args = new \metastore\ThriftHiveMetastore_update_partition_column_statistics_args();
    $args->stats_obj = $stats_obj;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'update_partition_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('update_partition_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_update_partition_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_update_partition_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_update_partition_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("update_partition_column_statistics failed: unknown result");
  }

  public function get_table_column_statistics($db_name, $tbl_name, $col_name)
  {
    $this->send_get_table_column_statistics($db_name, $tbl_name, $col_name);
    return $this->recv_get_table_column_statistics();
  }

  public function send_get_table_column_statistics($db_name, $tbl_name, $col_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_column_statistics_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->col_name = $col_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("get_table_column_statistics failed: unknown result");
  }

  public function get_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name)
  {
    $this->send_get_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name);
    return $this->recv_get_partition_column_statistics();
  }

  public function send_get_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_column_statistics_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $args->col_name = $col_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("get_partition_column_statistics failed: unknown result");
  }

  public function delete_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name)
  {
    $this->send_delete_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name);
    return $this->recv_delete_partition_column_statistics();
  }

  public function send_delete_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name)
  {
    $args = new \metastore\ThriftHiveMetastore_delete_partition_column_statistics_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $args->col_name = $col_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'delete_partition_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('delete_partition_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_delete_partition_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_delete_partition_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_delete_partition_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("delete_partition_column_statistics failed: unknown result");
  }

  public function delete_table_column_statistics($db_name, $tbl_name, $col_name)
  {
    $this->send_delete_table_column_statistics($db_name, $tbl_name, $col_name);
    return $this->recv_delete_table_column_statistics();
  }

  public function send_delete_table_column_statistics($db_name, $tbl_name, $col_name)
  {
    $args = new \metastore\ThriftHiveMetastore_delete_table_column_statistics_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->col_name = $col_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'delete_table_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('delete_table_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_delete_table_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_delete_table_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_delete_table_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("delete_table_column_statistics failed: unknown result");
  }

  public function create_role(\metastore\Role $role)
  {
    $this->send_create_role($role);
    return $this->recv_create_role();
  }

  public function send_create_role(\metastore\Role $role)
  {
    $args = new \metastore\ThriftHiveMetastore_create_role_args();
    $args->role = $role;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_role()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("create_role failed: unknown result");
  }

  public function drop_role($role_name)
  {
    $this->send_drop_role($role_name);
    return $this->recv_drop_role();
  }

  public function send_drop_role($role_name)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_role_args();
    $args->role_name = $role_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_role()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("drop_role failed: unknown result");
  }

  public function get_role_names()
  {
    $this->send_get_role_names();
    return $this->recv_get_role_names();
  }

  public function send_get_role_names()
  {
    $args = new \metastore\ThriftHiveMetastore_get_role_names_args();
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_role_names', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_role_names', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_role_names()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_role_names_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_role_names_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_role_names failed: unknown result");
  }

  public function grant_role($role_name, $principal_name, $principal_type, $grantor, $grantorType, $grant_option)
  {
    $this->send_grant_role($role_name, $principal_name, $principal_type, $grantor, $grantorType, $grant_option);
    return $this->recv_grant_role();
  }

  public function send_grant_role($role_name, $principal_name, $principal_type, $grantor, $grantorType, $grant_option)
  {
    $args = new \metastore\ThriftHiveMetastore_grant_role_args();
    $args->role_name = $role_name;
    $args->principal_name = $principal_name;
    $args->principal_type = $principal_type;
    $args->grantor = $grantor;
    $args->grantorType = $grantorType;
    $args->grant_option = $grant_option;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'grant_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('grant_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_grant_role()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_grant_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_grant_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("grant_role failed: unknown result");
  }

  public function revoke_role($role_name, $principal_name, $principal_type)
  {
    $this->send_revoke_role($role_name, $principal_name, $principal_type);
    return $this->recv_revoke_role();
  }

  public function send_revoke_role($role_name, $principal_name, $principal_type)
  {
    $args = new \metastore\ThriftHiveMetastore_revoke_role_args();
    $args->role_name = $role_name;
    $args->principal_name = $principal_name;
    $args->principal_type = $principal_type;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'revoke_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('revoke_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_revoke_role()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_revoke_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_revoke_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("revoke_role failed: unknown result");
  }

  public function list_roles($principal_name, $principal_type)
  {
    $this->send_list_roles($principal_name, $principal_type);
    return $this->recv_list_roles();
  }

  public function send_list_roles($principal_name, $principal_type)
  {
    $args = new \metastore\ThriftHiveMetastore_list_roles_args();
    $args->principal_name = $principal_name;
    $args->principal_type = $principal_type;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'list_roles', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('list_roles', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_list_roles()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_list_roles_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_list_roles_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("list_roles failed: unknown result");
  }

  public function get_privilege_set(\metastore\HiveObjectRef $hiveObject, $user_name, $group_names)
  {
    $this->send_get_privilege_set($hiveObject, $user_name, $group_names);
    return $this->recv_get_privilege_set();
  }

  public function send_get_privilege_set(\metastore\HiveObjectRef $hiveObject, $user_name, $group_names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_privilege_set_args();
    $args->hiveObject = $hiveObject;
    $args->user_name = $user_name;
    $args->group_names = $group_names;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_privilege_set', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_privilege_set', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_privilege_set()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_privilege_set_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_privilege_set_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_privilege_set failed: unknown result");
  }

  public function list_privileges($principal_name, $principal_type, \metastore\HiveObjectRef $hiveObject)
  {
    $this->send_list_privileges($principal_name, $principal_type, $hiveObject);
    return $this->recv_list_privileges();
  }

  public function send_list_privileges($principal_name, $principal_type, \metastore\HiveObjectRef $hiveObject)
  {
    $args = new \metastore\ThriftHiveMetastore_list_privileges_args();
    $args->principal_name = $principal_name;
    $args->principal_type = $principal_type;
    $args->hiveObject = $hiveObject;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'list_privileges', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('list_privileges', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_list_privileges()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_list_privileges_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_list_privileges_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("list_privileges failed: unknown result");
  }

  public function grant_privileges(\metastore\PrivilegeBag $privileges)
  {
    $this->send_grant_privileges($privileges);
    return $this->recv_grant_privileges();
  }

  public function send_grant_privileges(\metastore\PrivilegeBag $privileges)
  {
    $args = new \metastore\ThriftHiveMetastore_grant_privileges_args();
    $args->privileges = $privileges;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'grant_privileges', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('grant_privileges', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_grant_privileges()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_grant_privileges_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_grant_privileges_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("grant_privileges failed: unknown result");
  }

  public function revoke_privileges(\metastore\PrivilegeBag $privileges)
  {
    $this->send_revoke_privileges($privileges);
    return $this->recv_revoke_privileges();
  }

  public function send_revoke_privileges(\metastore\PrivilegeBag $privileges)
  {
    $args = new \metastore\ThriftHiveMetastore_revoke_privileges_args();
    $args->privileges = $privileges;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'revoke_privileges', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('revoke_privileges', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_revoke_privileges()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_revoke_privileges_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_revoke_privileges_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("revoke_privileges failed: unknown result");
  }

  public function set_ugi($user_name, $group_names)
  {
    $this->send_set_ugi($user_name, $group_names);
    return $this->recv_set_ugi();
  }

  public function send_set_ugi($user_name, $group_names)
  {
    $args = new \metastore\ThriftHiveMetastore_set_ugi_args();
    $args->user_name = $user_name;
    $args->group_names = $group_names;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'set_ugi', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('set_ugi', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_set_ugi()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_set_ugi_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_set_ugi_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("set_ugi failed: unknown result");
  }

  public function get_delegation_token($token_owner, $renewer_kerberos_principal_name)
  {
    $this->send_get_delegation_token($token_owner, $renewer_kerberos_principal_name);
    return $this->recv_get_delegation_token();
  }

  public function send_get_delegation_token($token_owner, $renewer_kerberos_principal_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_delegation_token_args();
    $args->token_owner = $token_owner;
    $args->renewer_kerberos_principal_name = $renewer_kerberos_principal_name;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_delegation_token', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_delegation_token', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_delegation_token()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_delegation_token_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_delegation_token_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_delegation_token failed: unknown result");
  }

  public function renew_delegation_token($token_str_form)
  {
    $this->send_renew_delegation_token($token_str_form);
    return $this->recv_renew_delegation_token();
  }

  public function send_renew_delegation_token($token_str_form)
  {
    $args = new \metastore\ThriftHiveMetastore_renew_delegation_token_args();
    $args->token_str_form = $token_str_form;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'renew_delegation_token', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('renew_delegation_token', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_renew_delegation_token()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_renew_delegation_token_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_renew_delegation_token_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("renew_delegation_token failed: unknown result");
  }

  public function cancel_delegation_token($token_str_form)
  {
    $this->send_cancel_delegation_token($token_str_form);
    $this->recv_cancel_delegation_token();
  }

  public function send_cancel_delegation_token($token_str_form)
  {
    $args = new \metastore\ThriftHiveMetastore_cancel_delegation_token_args();
    $args->token_str_form = $token_str_form;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'cancel_delegation_token', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('cancel_delegation_token', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_cancel_delegation_token()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_cancel_delegation_token_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_cancel_delegation_token_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    return;
  }

}

// HELPER FUNCTIONS AND STRUCTURES

class ThriftHiveMetastore_create_database_args {
  static $_TSPEC;

  public $database = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'database',
          'type' => TType::STRUCT,
          'class' => '\metastore\Database',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['database'])) {
        $this->database = $vals['database'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_database_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->database = new \metastore\Database();
            $xfer += $this->database->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_database_args');
    if ($this->database !== null) {
      if (!is_object($this->database)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('database', TType::STRUCT, 1);
      $xfer += $this->database->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_database_result {
  static $_TSPEC;

  public $o1 = null;
  public $o2 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_database_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\AlreadyExistsException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_database_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_database_args {
  static $_TSPEC;

  public $name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_database_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_database_args');
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_database_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Database',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_database_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Database();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_database_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_database_args {
  static $_TSPEC;

  public $name = null;
  public $deleteData = null;
  public $cascade = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        3 => array(
          'var' => 'cascade',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
      if (isset($vals['cascade'])) {
        $this->cascade = $vals['cascade'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_database_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->cascade);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_database_args');
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 2);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cascade !== null) {
      $xfer += $output->writeFieldBegin('cascade', TType::BOOL, 3);
      $xfer += $output->writeBool($this->cascade);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_database_result {
  static $_TSPEC;

  public $o1 = null;
  public $o2 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_database_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidOperationException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_database_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_databases_args {
  static $_TSPEC;

  public $pattern = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'pattern',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['pattern'])) {
        $this->pattern = $vals['pattern'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_databases_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->pattern);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_databases_args');
    if ($this->pattern !== null) {
      $xfer += $output->writeFieldBegin('pattern', TType::STRING, 1);
      $xfer += $output->writeString($this->pattern);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_databases_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_databases_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size227 = 0;
            $_etype230 = 0;
            $xfer += $input->readListBegin($_etype230, $_size227);
            for ($_i231 = 0; $_i231 < $_size227; ++$_i231)
            {
              $elem232 = null;
              $xfer += $input->readString($elem232);
              $this->success []= $elem232;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_databases_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter233)
          {
            $xfer += $output->writeString($iter233);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_all_databases_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_all_databases_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_all_databases_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_all_databases_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_all_databases_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size234 = 0;
            $_etype237 = 0;
            $xfer += $input->readListBegin($_etype237, $_size234);
            for ($_i238 = 0; $_i238 < $_size234; ++$_i238)
            {
              $elem239 = null;
              $xfer += $input->readString($elem239);
              $this->success []= $elem239;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_all_databases_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter240)
          {
            $xfer += $output->writeString($iter240);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_database_args {
  static $_TSPEC;

  public $dbname = null;
  public $db = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'db',
          'type' => TType::STRUCT,
          'class' => '\metastore\Database',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['db'])) {
        $this->db = $vals['db'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_database_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->db = new \metastore\Database();
            $xfer += $this->db->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_database_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->db !== null) {
      if (!is_object($this->db)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('db', TType::STRUCT, 2);
      $xfer += $this->db->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_database_result {
  static $_TSPEC;

  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_database_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_database_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_type_args {
  static $_TSPEC;

  public $name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_type_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_type_args');
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_type_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Type',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_type_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Type();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_type_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_type_args {
  static $_TSPEC;

  public $type = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'type',
          'type' => TType::STRUCT,
          'class' => '\metastore\Type',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['type'])) {
        $this->type = $vals['type'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_type_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->type = new \metastore\Type();
            $xfer += $this->type->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_type_args');
    if ($this->type !== null) {
      if (!is_object($this->type)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('type', TType::STRUCT, 1);
      $xfer += $this->type->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_type_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_type_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\AlreadyExistsException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_type_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_type_args {
  static $_TSPEC;

  public $type = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'type',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['type'])) {
        $this->type = $vals['type'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_type_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->type);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_type_args');
    if ($this->type !== null) {
      $xfer += $output->writeFieldBegin('type', TType::STRING, 1);
      $xfer += $output->writeString($this->type);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_type_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_type_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_type_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_type_all_args {
  static $_TSPEC;

  public $name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_type_all_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_type_all_args');
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_type_all_result {
  static $_TSPEC;

  public $success = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRUCT,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Type',
            ),
          ),
        1 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_type_all_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::MAP) {
            $this->success = array();
            $_size241 = 0;
            $_ktype242 = 0;
            $_vtype243 = 0;
            $xfer += $input->readMapBegin($_ktype242, $_vtype243, $_size241);
            for ($_i245 = 0; $_i245 < $_size241; ++$_i245)
            {
              $key246 = '';
              $val247 = new \metastore\Type();
              $xfer += $input->readString($key246);
              $val247 = new \metastore\Type();
              $xfer += $val247->read($input);
              $this->success[$key246] = $val247;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_type_all_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::MAP, 0);
      {
        $output->writeMapBegin(TType::STRING, TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $kiter248 => $viter249)
          {
            $xfer += $output->writeString($kiter248);
            $xfer += $viter249->write($output);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 1);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_fields_args {
  static $_TSPEC;

  public $db_name = null;
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_fields_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_fields_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_fields_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\FieldSchema',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_fields_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size250 = 0;
            $_etype253 = 0;
            $xfer += $input->readListBegin($_etype253, $_size250);
            for ($_i254 = 0; $_i254 < $_size250; ++$_i254)
            {
              $elem255 = null;
              $elem255 = new \metastore\FieldSchema();
              $xfer += $elem255->read($input);
              $this->success []= $elem255;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\UnknownTableException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_fields_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter256)
          {
            $xfer += $iter256->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_schema_args {
  static $_TSPEC;

  public $db_name = null;
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_schema_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_schema_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_schema_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\FieldSchema',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_schema_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size257 = 0;
            $_etype260 = 0;
            $xfer += $input->readListBegin($_etype260, $_size257);
            for ($_i261 = 0; $_i261 < $_size257; ++$_i261)
            {
              $elem262 = null;
              $elem262 = new \metastore\FieldSchema();
              $xfer += $elem262->read($input);
              $this->success []= $elem262;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\UnknownTableException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_schema_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter263)
          {
            $xfer += $iter263->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_table_args {
  static $_TSPEC;

  public $tbl = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tbl',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tbl'])) {
        $this->tbl = $vals['tbl'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->tbl = new \metastore\Table();
            $xfer += $this->tbl->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_table_args');
    if ($this->tbl !== null) {
      if (!is_object($this->tbl)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('tbl', TType::STRUCT, 1);
      $xfer += $this->tbl->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_table_result {
  static $_TSPEC;

  public $o1 = null;
  public $o2 = null;
  public $o3 = null;
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\AlreadyExistsException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\NoSuchObjectException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_table_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_table_with_environment_context_args {
  static $_TSPEC;

  public $tbl = null;
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tbl',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        2 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tbl'])) {
        $this->tbl = $vals['tbl'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_table_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->tbl = new \metastore\Table();
            $xfer += $this->tbl->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_table_with_environment_context_args');
    if ($this->tbl !== null) {
      if (!is_object($this->tbl)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('tbl', TType::STRUCT, 1);
      $xfer += $this->tbl->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 2);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_table_with_environment_context_result {
  static $_TSPEC;

  public $o1 = null;
  public $o2 = null;
  public $o3 = null;
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_table_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\AlreadyExistsException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\NoSuchObjectException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_table_with_environment_context_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_table_args {
  static $_TSPEC;

  public $dbname = null;
  public $name = null;
  public $deleteData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_table_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 2);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 3);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_table_result {
  static $_TSPEC;

  public $o1 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_table_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 2);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_table_with_environment_context_args {
  static $_TSPEC;

  public $dbname = null;
  public $name = null;
  public $deleteData = null;
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_table_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_table_with_environment_context_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 2);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 3);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_table_with_environment_context_result {
  static $_TSPEC;

  public $o1 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_table_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_table_with_environment_context_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 2);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_tables_args {
  static $_TSPEC;

  public $db_name = null;
  public $pattern = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'pattern',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['pattern'])) {
        $this->pattern = $vals['pattern'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_tables_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->pattern);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_tables_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->pattern !== null) {
      $xfer += $output->writeFieldBegin('pattern', TType::STRING, 2);
      $xfer += $output->writeString($this->pattern);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_tables_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_tables_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size264 = 0;
            $_etype267 = 0;
            $xfer += $input->readListBegin($_etype267, $_size264);
            for ($_i268 = 0; $_i268 < $_size264; ++$_i268)
            {
              $elem269 = null;
              $xfer += $input->readString($elem269);
              $this->success []= $elem269;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_tables_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter270)
          {
            $xfer += $output->writeString($iter270);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_all_tables_args {
  static $_TSPEC;

  public $db_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_all_tables_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_all_tables_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_all_tables_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_all_tables_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size271 = 0;
            $_etype274 = 0;
            $xfer += $input->readListBegin($_etype274, $_size271);
            for ($_i275 = 0; $_i275 < $_size271; ++$_i275)
            {
              $elem276 = null;
              $xfer += $input->readString($elem276);
              $this->success []= $elem276;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_all_tables_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter277)
          {
            $xfer += $output->writeString($iter277);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_args {
  static $_TSPEC;

  public $dbname = null;
  public $tbl_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Table();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_objects_by_name_args {
  static $_TSPEC;

  public $dbname = null;
  public $tbl_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['tbl_names'])) {
        $this->tbl_names = $vals['tbl_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_objects_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->tbl_names = array();
            $_size278 = 0;
            $_etype281 = 0;
            $xfer += $input->readListBegin($_etype281, $_size278);
            for ($_i282 = 0; $_i282 < $_size278; ++$_i282)
            {
              $elem283 = null;
              $xfer += $input->readString($elem283);
              $this->tbl_names []= $elem283;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_objects_by_name_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_names !== null) {
      if (!is_array($this->tbl_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('tbl_names', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRING, count($this->tbl_names));
        {
          foreach ($this->tbl_names as $iter284)
          {
            $xfer += $output->writeString($iter284);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_objects_by_name_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Table',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_objects_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size285 = 0;
            $_etype288 = 0;
            $xfer += $input->readListBegin($_etype288, $_size285);
            for ($_i289 = 0; $_i289 < $_size285; ++$_i289)
            {
              $elem290 = null;
              $elem290 = new \metastore\Table();
              $xfer += $elem290->read($input);
              $this->success []= $elem290;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidOperationException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_objects_by_name_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter291)
          {
            $xfer += $iter291->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_names_by_filter_args {
  static $_TSPEC;

  public $dbname = null;
  public $filter = null;
  public $max_tables = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'filter',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_tables',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['filter'])) {
        $this->filter = $vals['filter'];
      }
      if (isset($vals['max_tables'])) {
        $this->max_tables = $vals['max_tables'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_names_by_filter_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->filter);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_tables);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_names_by_filter_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filter !== null) {
      $xfer += $output->writeFieldBegin('filter', TType::STRING, 2);
      $xfer += $output->writeString($this->filter);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_tables !== null) {
      $xfer += $output->writeFieldBegin('max_tables', TType::I16, 3);
      $xfer += $output->writeI16($this->max_tables);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_names_by_filter_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_names_by_filter_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size292 = 0;
            $_etype295 = 0;
            $xfer += $input->readListBegin($_etype295, $_size292);
            for ($_i296 = 0; $_i296 < $_size292; ++$_i296)
            {
              $elem297 = null;
              $xfer += $input->readString($elem297);
              $this->success []= $elem297;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidOperationException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_names_by_filter_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter298)
          {
            $xfer += $output->writeString($iter298);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_args {
  static $_TSPEC;

  public $dbname = null;
  public $tbl_name = null;
  public $new_tbl = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_tbl',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_tbl'])) {
        $this->new_tbl = $vals['new_tbl'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->new_tbl = new \metastore\Table();
            $xfer += $this->new_tbl->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_tbl !== null) {
      if (!is_object($this->new_tbl)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_tbl', TType::STRUCT, 3);
      $xfer += $this->new_tbl->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_result {
  static $_TSPEC;

  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_with_environment_context_args {
  static $_TSPEC;

  public $dbname = null;
  public $tbl_name = null;
  public $new_tbl = null;
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_tbl',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_tbl'])) {
        $this->new_tbl = $vals['new_tbl'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->new_tbl = new \metastore\Table();
            $xfer += $this->new_tbl->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_with_environment_context_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_tbl !== null) {
      if (!is_object($this->new_tbl)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_tbl', TType::STRUCT, 3);
      $xfer += $this->new_tbl->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_with_environment_context_result {
  static $_TSPEC;

  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_with_environment_context_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partition_args {
  static $_TSPEC;

  public $new_part = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'new_part',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['new_part'])) {
        $this->new_part = $vals['new_part'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->new_part = new \metastore\Partition();
            $xfer += $this->new_part->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partition_args');
    if ($this->new_part !== null) {
      if (!is_object($this->new_part)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_part', TType::STRUCT, 1);
      $xfer += $this->new_part->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partition_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partition_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partition_with_environment_context_args {
  static $_TSPEC;

  public $new_part = null;
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'new_part',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        2 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['new_part'])) {
        $this->new_part = $vals['new_part'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partition_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->new_part = new \metastore\Partition();
            $xfer += $this->new_part->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partition_with_environment_context_args');
    if ($this->new_part !== null) {
      if (!is_object($this->new_part)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_part', TType::STRUCT, 1);
      $xfer += $this->new_part->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 2);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partition_with_environment_context_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partition_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partition_with_environment_context_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partitions_args {
  static $_TSPEC;

  public $new_parts = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'new_parts',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['new_parts'])) {
        $this->new_parts = $vals['new_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partitions_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::LST) {
            $this->new_parts = array();
            $_size299 = 0;
            $_etype302 = 0;
            $xfer += $input->readListBegin($_etype302, $_size299);
            for ($_i303 = 0; $_i303 < $_size299; ++$_i303)
            {
              $elem304 = null;
              $elem304 = new \metastore\Partition();
              $xfer += $elem304->read($input);
              $this->new_parts []= $elem304;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partitions_args');
    if ($this->new_parts !== null) {
      if (!is_array($this->new_parts)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_parts', TType::LST, 1);
      {
        $output->writeListBegin(TType::STRUCT, count($this->new_parts));
        {
          foreach ($this->new_parts as $iter305)
          {
            $xfer += $iter305->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partitions_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I32,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partitions_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partitions_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_vals = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size306 = 0;
            $_etype309 = 0;
            $xfer += $input->readListBegin($_etype309, $_size306);
            for ($_i310 = 0; $_i310 < $_size306; ++$_i310)
            {
              $elem311 = null;
              $xfer += $input->readString($elem311);
              $this->part_vals []= $elem311;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter312)
          {
            $xfer += $output->writeString($iter312);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_with_environment_context_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_vals = null;
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size313 = 0;
            $_etype316 = 0;
            $xfer += $input->readListBegin($_etype316, $_size313);
            for ($_i317 = 0; $_i317 < $_size313; ++$_i317)
            {
              $elem318 = null;
              $xfer += $input->readString($elem318);
              $this->part_vals []= $elem318;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter319)
          {
            $xfer += $output->writeString($iter319);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_with_environment_context_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_with_environment_context_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_by_name_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_by_name_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_by_name_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_by_name_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_by_name_with_environment_context_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_name = null;
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_by_name_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_by_name_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_by_name_with_environment_context_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_by_name_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_by_name_with_environment_context_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_vals = null;
  public $deleteData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size320 = 0;
            $_etype323 = 0;
            $xfer += $input->readListBegin($_etype323, $_size320);
            for ($_i324 = 0; $_i324 < $_size320; ++$_i324)
            {
              $elem325 = null;
              $xfer += $input->readString($elem325);
              $this->part_vals []= $elem325;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter326)
          {
            $xfer += $output->writeString($iter326);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 4);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_with_environment_context_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_vals = null;
  public $deleteData = null;
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        5 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size327 = 0;
            $_etype330 = 0;
            $xfer += $input->readListBegin($_etype330, $_size327);
            for ($_i331 = 0; $_i331 < $_size327; ++$_i331)
            {
              $elem332 = null;
              $xfer += $input->readString($elem332);
              $this->part_vals []= $elem332;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter333)
          {
            $xfer += $output->writeString($iter333);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 4);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 5);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_with_environment_context_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_with_environment_context_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_by_name_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_name = null;
  public $deleteData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_by_name_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 4);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_by_name_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_by_name_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_by_name_with_environment_context_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_name = null;
  public $deleteData = null;
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        5 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_by_name_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_by_name_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 4);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 5);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_by_name_with_environment_context_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_by_name_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_by_name_with_environment_context_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_vals = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size334 = 0;
            $_etype337 = 0;
            $xfer += $input->readListBegin($_etype337, $_size334);
            for ($_i338 = 0; $_i338 < $_size334; ++$_i338)
            {
              $elem339 = null;
              $xfer += $input->readString($elem339);
              $this->part_vals []= $elem339;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter340)
          {
            $xfer += $output->writeString($iter340);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_exchange_partition_args {
  static $_TSPEC;

  public $partitionSpecs = null;
  public $source_db = null;
  public $source_table_name = null;
  public $dest_db = null;
  public $dest_table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'partitionSpecs',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        2 => array(
          'var' => 'source_db',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'source_table_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'dest_db',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'dest_table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['partitionSpecs'])) {
        $this->partitionSpecs = $vals['partitionSpecs'];
      }
      if (isset($vals['source_db'])) {
        $this->source_db = $vals['source_db'];
      }
      if (isset($vals['source_table_name'])) {
        $this->source_table_name = $vals['source_table_name'];
      }
      if (isset($vals['dest_db'])) {
        $this->dest_db = $vals['dest_db'];
      }
      if (isset($vals['dest_table_name'])) {
        $this->dest_table_name = $vals['dest_table_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_exchange_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::MAP) {
            $this->partitionSpecs = array();
            $_size341 = 0;
            $_ktype342 = 0;
            $_vtype343 = 0;
            $xfer += $input->readMapBegin($_ktype342, $_vtype343, $_size341);
            for ($_i345 = 0; $_i345 < $_size341; ++$_i345)
            {
              $key346 = '';
              $val347 = '';
              $xfer += $input->readString($key346);
              $xfer += $input->readString($val347);
              $this->partitionSpecs[$key346] = $val347;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->source_db);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->source_table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dest_db);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dest_table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_exchange_partition_args');
    if ($this->partitionSpecs !== null) {
      if (!is_array($this->partitionSpecs)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('partitionSpecs', TType::MAP, 1);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->partitionSpecs));
        {
          foreach ($this->partitionSpecs as $kiter348 => $viter349)
          {
            $xfer += $output->writeString($kiter348);
            $xfer += $output->writeString($viter349);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->source_db !== null) {
      $xfer += $output->writeFieldBegin('source_db', TType::STRING, 2);
      $xfer += $output->writeString($this->source_db);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->source_table_name !== null) {
      $xfer += $output->writeFieldBegin('source_table_name', TType::STRING, 3);
      $xfer += $output->writeString($this->source_table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->dest_db !== null) {
      $xfer += $output->writeFieldBegin('dest_db', TType::STRING, 4);
      $xfer += $output->writeString($this->dest_db);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->dest_table_name !== null) {
      $xfer += $output->writeFieldBegin('dest_table_name', TType::STRING, 5);
      $xfer += $output->writeString($this->dest_table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_exchange_partition_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_exchange_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\InvalidObjectException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_exchange_partition_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_with_auth_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_vals = null;
  public $user_name = null;
  public $group_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'user_name',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'group_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['user_name'])) {
        $this->user_name = $vals['user_name'];
      }
      if (isset($vals['group_names'])) {
        $this->group_names = $vals['group_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_with_auth_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size350 = 0;
            $_etype353 = 0;
            $xfer += $input->readListBegin($_etype353, $_size350);
            for ($_i354 = 0; $_i354 < $_size350; ++$_i354)
            {
              $elem355 = null;
              $xfer += $input->readString($elem355);
              $this->part_vals []= $elem355;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->user_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::LST) {
            $this->group_names = array();
            $_size356 = 0;
            $_etype359 = 0;
            $xfer += $input->readListBegin($_etype359, $_size356);
            for ($_i360 = 0; $_i360 < $_size356; ++$_i360)
            {
              $elem361 = null;
              $xfer += $input->readString($elem361);
              $this->group_names []= $elem361;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_with_auth_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter362)
          {
            $xfer += $output->writeString($iter362);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->user_name !== null) {
      $xfer += $output->writeFieldBegin('user_name', TType::STRING, 4);
      $xfer += $output->writeString($this->user_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->group_names !== null) {
      if (!is_array($this->group_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('group_names', TType::LST, 5);
      {
        $output->writeListBegin(TType::STRING, count($this->group_names));
        {
          foreach ($this->group_names as $iter363)
          {
            $xfer += $output->writeString($iter363);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_with_auth_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_with_auth_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_with_auth_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_by_name_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_by_name_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_by_name_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_by_name_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 3);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size364 = 0;
            $_etype367 = 0;
            $xfer += $input->readListBegin($_etype367, $_size364);
            for ($_i368 = 0; $_i368 < $_size364; ++$_i368)
            {
              $elem369 = null;
              $elem369 = new \metastore\Partition();
              $xfer += $elem369->read($input);
              $this->success []= $elem369;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter370)
          {
            $xfer += $iter370->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_with_auth_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $max_parts = -1;
  public $user_name = null;
  public $group_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        4 => array(
          'var' => 'user_name',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'group_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
      if (isset($vals['user_name'])) {
        $this->user_name = $vals['user_name'];
      }
      if (isset($vals['group_names'])) {
        $this->group_names = $vals['group_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_with_auth_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->user_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::LST) {
            $this->group_names = array();
            $_size371 = 0;
            $_etype374 = 0;
            $xfer += $input->readListBegin($_etype374, $_size371);
            for ($_i375 = 0; $_i375 < $_size371; ++$_i375)
            {
              $elem376 = null;
              $xfer += $input->readString($elem376);
              $this->group_names []= $elem376;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_with_auth_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 3);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->user_name !== null) {
      $xfer += $output->writeFieldBegin('user_name', TType::STRING, 4);
      $xfer += $output->writeString($this->user_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->group_names !== null) {
      if (!is_array($this->group_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('group_names', TType::LST, 5);
      {
        $output->writeListBegin(TType::STRING, count($this->group_names));
        {
          foreach ($this->group_names as $iter377)
          {
            $xfer += $output->writeString($iter377);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_with_auth_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_with_auth_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size378 = 0;
            $_etype381 = 0;
            $xfer += $input->readListBegin($_etype381, $_size378);
            for ($_i382 = 0; $_i382 < $_size378; ++$_i382)
            {
              $elem383 = null;
              $elem383 = new \metastore\Partition();
              $xfer += $elem383->read($input);
              $this->success []= $elem383;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_with_auth_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter384)
          {
            $xfer += $iter384->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_names_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_names_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_names_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 3);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_names_result {
  static $_TSPEC;

  public $success = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_names_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size385 = 0;
            $_etype388 = 0;
            $xfer += $input->readListBegin($_etype388, $_size385);
            for ($_i389 = 0; $_i389 < $_size385; ++$_i389)
            {
              $elem390 = null;
              $xfer += $input->readString($elem390);
              $this->success []= $elem390;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_names_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter391)
          {
            $xfer += $output->writeString($iter391);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 1);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_ps_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_vals = null;
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_ps_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size392 = 0;
            $_etype395 = 0;
            $xfer += $input->readListBegin($_etype395, $_size392);
            for ($_i396 = 0; $_i396 < $_size392; ++$_i396)
            {
              $elem397 = null;
              $xfer += $input->readString($elem397);
              $this->part_vals []= $elem397;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_ps_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter398)
          {
            $xfer += $output->writeString($iter398);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 4);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_ps_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_ps_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size399 = 0;
            $_etype402 = 0;
            $xfer += $input->readListBegin($_etype402, $_size399);
            for ($_i403 = 0; $_i403 < $_size399; ++$_i403)
            {
              $elem404 = null;
              $elem404 = new \metastore\Partition();
              $xfer += $elem404->read($input);
              $this->success []= $elem404;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_ps_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter405)
          {
            $xfer += $iter405->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_ps_with_auth_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_vals = null;
  public $max_parts = -1;
  public $user_name = null;
  public $group_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        5 => array(
          'var' => 'user_name',
          'type' => TType::STRING,
          ),
        6 => array(
          'var' => 'group_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
      if (isset($vals['user_name'])) {
        $this->user_name = $vals['user_name'];
      }
      if (isset($vals['group_names'])) {
        $this->group_names = $vals['group_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_ps_with_auth_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size406 = 0;
            $_etype409 = 0;
            $xfer += $input->readListBegin($_etype409, $_size406);
            for ($_i410 = 0; $_i410 < $_size406; ++$_i410)
            {
              $elem411 = null;
              $xfer += $input->readString($elem411);
              $this->part_vals []= $elem411;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->user_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::LST) {
            $this->group_names = array();
            $_size412 = 0;
            $_etype415 = 0;
            $xfer += $input->readListBegin($_etype415, $_size412);
            for ($_i416 = 0; $_i416 < $_size412; ++$_i416)
            {
              $elem417 = null;
              $xfer += $input->readString($elem417);
              $this->group_names []= $elem417;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_ps_with_auth_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter418)
          {
            $xfer += $output->writeString($iter418);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 4);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->user_name !== null) {
      $xfer += $output->writeFieldBegin('user_name', TType::STRING, 5);
      $xfer += $output->writeString($this->user_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->group_names !== null) {
      if (!is_array($this->group_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('group_names', TType::LST, 6);
      {
        $output->writeListBegin(TType::STRING, count($this->group_names));
        {
          foreach ($this->group_names as $iter419)
          {
            $xfer += $output->writeString($iter419);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_ps_with_auth_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_ps_with_auth_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size420 = 0;
            $_etype423 = 0;
            $xfer += $input->readListBegin($_etype423, $_size420);
            for ($_i424 = 0; $_i424 < $_size420; ++$_i424)
            {
              $elem425 = null;
              $elem425 = new \metastore\Partition();
              $xfer += $elem425->read($input);
              $this->success []= $elem425;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_ps_with_auth_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter426)
          {
            $xfer += $iter426->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_names_ps_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_vals = null;
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_names_ps_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size427 = 0;
            $_etype430 = 0;
            $xfer += $input->readListBegin($_etype430, $_size427);
            for ($_i431 = 0; $_i431 < $_size427; ++$_i431)
            {
              $elem432 = null;
              $xfer += $input->readString($elem432);
              $this->part_vals []= $elem432;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_names_ps_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter433)
          {
            $xfer += $output->writeString($iter433);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 4);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_names_ps_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_names_ps_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size434 = 0;
            $_etype437 = 0;
            $xfer += $input->readListBegin($_etype437, $_size434);
            for ($_i438 = 0; $_i438 < $_size434; ++$_i438)
            {
              $elem439 = null;
              $xfer += $input->readString($elem439);
              $this->success []= $elem439;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_names_ps_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter440)
          {
            $xfer += $output->writeString($iter440);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_filter_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $filter = null;
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'filter',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['filter'])) {
        $this->filter = $vals['filter'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_filter_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->filter);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_filter_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filter !== null) {
      $xfer += $output->writeFieldBegin('filter', TType::STRING, 3);
      $xfer += $output->writeString($this->filter);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 4);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_filter_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_filter_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size441 = 0;
            $_etype444 = 0;
            $xfer += $input->readListBegin($_etype444, $_size441);
            for ($_i445 = 0; $_i445 < $_size441; ++$_i445)
            {
              $elem446 = null;
              $elem446 = new \metastore\Partition();
              $xfer += $elem446->read($input);
              $this->success []= $elem446;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_filter_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter447)
          {
            $xfer += $iter447->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_names_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['names'])) {
        $this->names = $vals['names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_names_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->names = array();
            $_size448 = 0;
            $_etype451 = 0;
            $xfer += $input->readListBegin($_etype451, $_size448);
            for ($_i452 = 0; $_i452 < $_size448; ++$_i452)
            {
              $elem453 = null;
              $xfer += $input->readString($elem453);
              $this->names []= $elem453;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_names_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->names !== null) {
      if (!is_array($this->names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('names', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->names));
        {
          foreach ($this->names as $iter454)
          {
            $xfer += $output->writeString($iter454);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_names_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_names_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size455 = 0;
            $_etype458 = 0;
            $xfer += $input->readListBegin($_etype458, $_size455);
            for ($_i459 = 0; $_i459 < $_size455; ++$_i459)
            {
              $elem460 = null;
              $elem460 = new \metastore\Partition();
              $xfer += $elem460->read($input);
              $this->success []= $elem460;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_names_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter461)
          {
            $xfer += $iter461->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partition_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $new_part = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_part',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_part'])) {
        $this->new_part = $vals['new_part'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->new_part = new \metastore\Partition();
            $xfer += $this->new_part->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partition_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_part !== null) {
      if (!is_object($this->new_part)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_part', TType::STRUCT, 3);
      $xfer += $this->new_part->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partition_result {
  static $_TSPEC;

  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partition_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partitions_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $new_parts = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_parts',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_parts'])) {
        $this->new_parts = $vals['new_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partitions_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->new_parts = array();
            $_size462 = 0;
            $_etype465 = 0;
            $xfer += $input->readListBegin($_etype465, $_size462);
            for ($_i466 = 0; $_i466 < $_size462; ++$_i466)
            {
              $elem467 = null;
              $elem467 = new \metastore\Partition();
              $xfer += $elem467->read($input);
              $this->new_parts []= $elem467;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partitions_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_parts !== null) {
      if (!is_array($this->new_parts)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_parts', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRUCT, count($this->new_parts));
        {
          foreach ($this->new_parts as $iter468)
          {
            $xfer += $iter468->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partitions_result {
  static $_TSPEC;

  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partitions_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partitions_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partition_with_environment_context_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $new_part = null;
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_part',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_part'])) {
        $this->new_part = $vals['new_part'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partition_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->new_part = new \metastore\Partition();
            $xfer += $this->new_part->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partition_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_part !== null) {
      if (!is_object($this->new_part)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_part', TType::STRUCT, 3);
      $xfer += $this->new_part->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partition_with_environment_context_result {
  static $_TSPEC;

  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partition_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partition_with_environment_context_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_rename_partition_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_vals = null;
  public $new_part = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'new_part',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['new_part'])) {
        $this->new_part = $vals['new_part'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_rename_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size469 = 0;
            $_etype472 = 0;
            $xfer += $input->readListBegin($_etype472, $_size469);
            for ($_i473 = 0; $_i473 < $_size469; ++$_i473)
            {
              $elem474 = null;
              $xfer += $input->readString($elem474);
              $this->part_vals []= $elem474;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->new_part = new \metastore\Partition();
            $xfer += $this->new_part->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_rename_partition_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter475)
          {
            $xfer += $output->writeString($iter475);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_part !== null) {
      if (!is_object($this->new_part)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_part', TType::STRUCT, 4);
      $xfer += $this->new_part->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_rename_partition_result {
  static $_TSPEC;

  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_rename_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_rename_partition_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_has_valid_characters_args {
  static $_TSPEC;

  public $part_vals = null;
  public $throw_exception = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        2 => array(
          'var' => 'throw_exception',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['throw_exception'])) {
        $this->throw_exception = $vals['throw_exception'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_has_valid_characters_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size476 = 0;
            $_etype479 = 0;
            $xfer += $input->readListBegin($_etype479, $_size476);
            for ($_i480 = 0; $_i480 < $_size476; ++$_i480)
            {
              $elem481 = null;
              $xfer += $input->readString($elem481);
              $this->part_vals []= $elem481;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->throw_exception);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_has_valid_characters_args');
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 1);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter482)
          {
            $xfer += $output->writeString($iter482);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->throw_exception !== null) {
      $xfer += $output->writeFieldBegin('throw_exception', TType::BOOL, 2);
      $xfer += $output->writeBool($this->throw_exception);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_has_valid_characters_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_has_valid_characters_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_has_valid_characters_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_config_value_args {
  static $_TSPEC;

  public $name = null;
  public $defaultValue = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'defaultValue',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['defaultValue'])) {
        $this->defaultValue = $vals['defaultValue'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_config_value_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->defaultValue);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_config_value_args');
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->defaultValue !== null) {
      $xfer += $output->writeFieldBegin('defaultValue', TType::STRING, 2);
      $xfer += $output->writeString($this->defaultValue);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_config_value_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\ConfigValSecurityException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_config_value_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\ConfigValSecurityException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_config_value_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_to_vals_args {
  static $_TSPEC;

  public $part_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_to_vals_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_to_vals_args');
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 1);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_to_vals_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_to_vals_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size483 = 0;
            $_etype486 = 0;
            $xfer += $input->readListBegin($_etype486, $_size483);
            for ($_i487 = 0; $_i487 < $_size483; ++$_i487)
            {
              $elem488 = null;
              $xfer += $input->readString($elem488);
              $this->success []= $elem488;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_to_vals_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter489)
          {
            $xfer += $output->writeString($iter489);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_to_spec_args {
  static $_TSPEC;

  public $part_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_to_spec_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_to_spec_args');
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 1);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_to_spec_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_to_spec_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::MAP) {
            $this->success = array();
            $_size490 = 0;
            $_ktype491 = 0;
            $_vtype492 = 0;
            $xfer += $input->readMapBegin($_ktype491, $_vtype492, $_size490);
            for ($_i494 = 0; $_i494 < $_size490; ++$_i494)
            {
              $key495 = '';
              $val496 = '';
              $xfer += $input->readString($key495);
              $xfer += $input->readString($val496);
              $this->success[$key495] = $val496;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_to_spec_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::MAP, 0);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->success));
        {
          foreach ($this->success as $kiter497 => $viter498)
          {
            $xfer += $output->writeString($kiter497);
            $xfer += $output->writeString($viter498);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_markPartitionForEvent_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_vals = null;
  public $eventType = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'eventType',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['eventType'])) {
        $this->eventType = $vals['eventType'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_markPartitionForEvent_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::MAP) {
            $this->part_vals = array();
            $_size499 = 0;
            $_ktype500 = 0;
            $_vtype501 = 0;
            $xfer += $input->readMapBegin($_ktype500, $_vtype501, $_size499);
            for ($_i503 = 0; $_i503 < $_size499; ++$_i503)
            {
              $key504 = '';
              $val505 = '';
              $xfer += $input->readString($key504);
              $xfer += $input->readString($val505);
              $this->part_vals[$key504] = $val505;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->eventType);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_markPartitionForEvent_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::MAP, 3);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $kiter506 => $viter507)
          {
            $xfer += $output->writeString($kiter506);
            $xfer += $output->writeString($viter507);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->eventType !== null) {
      $xfer += $output->writeFieldBegin('eventType', TType::I32, 4);
      $xfer += $output->writeI32($this->eventType);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_markPartitionForEvent_result {
  static $_TSPEC;

  public $o1 = null;
  public $o2 = null;
  public $o3 = null;
  public $o4 = null;
  public $o5 = null;
  public $o6 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        5 => array(
          'var' => 'o5',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownPartitionException',
          ),
        6 => array(
          'var' => 'o6',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidPartitionException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
      if (isset($vals['o5'])) {
        $this->o5 = $vals['o5'];
      }
      if (isset($vals['o6'])) {
        $this->o6 = $vals['o6'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_markPartitionForEvent_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\UnknownTableException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->o5 = new \metastore\UnknownPartitionException();
            $xfer += $this->o5->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::STRUCT) {
            $this->o6 = new \metastore\InvalidPartitionException();
            $xfer += $this->o6->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_markPartitionForEvent_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o5 !== null) {
      $xfer += $output->writeFieldBegin('o5', TType::STRUCT, 5);
      $xfer += $this->o5->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o6 !== null) {
      $xfer += $output->writeFieldBegin('o6', TType::STRUCT, 6);
      $xfer += $this->o6->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_isPartitionMarkedForEvent_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_vals = null;
  public $eventType = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'eventType',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['eventType'])) {
        $this->eventType = $vals['eventType'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_isPartitionMarkedForEvent_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::MAP) {
            $this->part_vals = array();
            $_size508 = 0;
            $_ktype509 = 0;
            $_vtype510 = 0;
            $xfer += $input->readMapBegin($_ktype509, $_vtype510, $_size508);
            for ($_i512 = 0; $_i512 < $_size508; ++$_i512)
            {
              $key513 = '';
              $val514 = '';
              $xfer += $input->readString($key513);
              $xfer += $input->readString($val514);
              $this->part_vals[$key513] = $val514;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->eventType);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_isPartitionMarkedForEvent_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::MAP, 3);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $kiter515 => $viter516)
          {
            $xfer += $output->writeString($kiter515);
            $xfer += $output->writeString($viter516);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->eventType !== null) {
      $xfer += $output->writeFieldBegin('eventType', TType::I32, 4);
      $xfer += $output->writeI32($this->eventType);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_isPartitionMarkedForEvent_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;
  public $o4 = null;
  public $o5 = null;
  public $o6 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        5 => array(
          'var' => 'o5',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownPartitionException',
          ),
        6 => array(
          'var' => 'o6',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidPartitionException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
      if (isset($vals['o5'])) {
        $this->o5 = $vals['o5'];
      }
      if (isset($vals['o6'])) {
        $this->o6 = $vals['o6'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_isPartitionMarkedForEvent_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\UnknownTableException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->o5 = new \metastore\UnknownPartitionException();
            $xfer += $this->o5->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::STRUCT) {
            $this->o6 = new \metastore\InvalidPartitionException();
            $xfer += $this->o6->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_isPartitionMarkedForEvent_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o5 !== null) {
      $xfer += $output->writeFieldBegin('o5', TType::STRUCT, 5);
      $xfer += $this->o5->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o6 !== null) {
      $xfer += $output->writeFieldBegin('o6', TType::STRUCT, 6);
      $xfer += $this->o6->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_index_args {
  static $_TSPEC;

  public $new_index = null;
  public $index_table = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'new_index',
          'type' => TType::STRUCT,
          'class' => '\metastore\Index',
          ),
        2 => array(
          'var' => 'index_table',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['new_index'])) {
        $this->new_index = $vals['new_index'];
      }
      if (isset($vals['index_table'])) {
        $this->index_table = $vals['index_table'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_index_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->new_index = new \metastore\Index();
            $xfer += $this->new_index->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->index_table = new \metastore\Table();
            $xfer += $this->index_table->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_index_args');
    if ($this->new_index !== null) {
      if (!is_object($this->new_index)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_index', TType::STRUCT, 1);
      $xfer += $this->new_index->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->index_table !== null) {
      if (!is_object($this->index_table)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('index_table', TType::STRUCT, 2);
      $xfer += $this->index_table->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_index_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Index',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_index_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Index();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_index_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_index_args {
  static $_TSPEC;

  public $dbname = null;
  public $base_tbl_name = null;
  public $idx_name = null;
  public $new_idx = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'base_tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'idx_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'new_idx',
          'type' => TType::STRUCT,
          'class' => '\metastore\Index',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['base_tbl_name'])) {
        $this->base_tbl_name = $vals['base_tbl_name'];
      }
      if (isset($vals['idx_name'])) {
        $this->idx_name = $vals['idx_name'];
      }
      if (isset($vals['new_idx'])) {
        $this->new_idx = $vals['new_idx'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_index_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->base_tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->idx_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->new_idx = new \metastore\Index();
            $xfer += $this->new_idx->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_index_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->base_tbl_name !== null) {
      $xfer += $output->writeFieldBegin('base_tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->base_tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->idx_name !== null) {
      $xfer += $output->writeFieldBegin('idx_name', TType::STRING, 3);
      $xfer += $output->writeString($this->idx_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_idx !== null) {
      if (!is_object($this->new_idx)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_idx', TType::STRUCT, 4);
      $xfer += $this->new_idx->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_index_result {
  static $_TSPEC;

  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_index_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_index_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_index_by_name_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $index_name = null;
  public $deleteData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'index_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['index_name'])) {
        $this->index_name = $vals['index_name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_index_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->index_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_index_by_name_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->index_name !== null) {
      $xfer += $output->writeFieldBegin('index_name', TType::STRING, 3);
      $xfer += $output->writeString($this->index_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 4);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_index_by_name_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_index_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_index_by_name_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_index_by_name_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $index_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'index_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['index_name'])) {
        $this->index_name = $vals['index_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_index_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->index_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_index_by_name_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->index_name !== null) {
      $xfer += $output->writeFieldBegin('index_name', TType::STRING, 3);
      $xfer += $output->writeString($this->index_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_index_by_name_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Index',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_index_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Index();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_index_by_name_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_indexes_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $max_indexes = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_indexes',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_indexes'])) {
        $this->max_indexes = $vals['max_indexes'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_indexes_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_indexes);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_indexes_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_indexes !== null) {
      $xfer += $output->writeFieldBegin('max_indexes', TType::I16, 3);
      $xfer += $output->writeI16($this->max_indexes);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_indexes_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Index',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_indexes_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size517 = 0;
            $_etype520 = 0;
            $xfer += $input->readListBegin($_etype520, $_size517);
            for ($_i521 = 0; $_i521 < $_size517; ++$_i521)
            {
              $elem522 = null;
              $elem522 = new \metastore\Index();
              $xfer += $elem522->read($input);
              $this->success []= $elem522;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_indexes_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter523)
          {
            $xfer += $iter523->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_index_names_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $max_indexes = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_indexes',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_indexes'])) {
        $this->max_indexes = $vals['max_indexes'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_index_names_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_indexes);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_index_names_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_indexes !== null) {
      $xfer += $output->writeFieldBegin('max_indexes', TType::I16, 3);
      $xfer += $output->writeI16($this->max_indexes);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_index_names_result {
  static $_TSPEC;

  public $success = null;
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_index_names_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size524 = 0;
            $_etype527 = 0;
            $xfer += $input->readListBegin($_etype527, $_size524);
            for ($_i528 = 0; $_i528 < $_size524; ++$_i528)
            {
              $elem529 = null;
              $xfer += $input->readString($elem529);
              $this->success []= $elem529;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_index_names_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter530)
          {
            $xfer += $output->writeString($iter530);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 1);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_update_table_column_statistics_args {
  static $_TSPEC;

  public $stats_obj = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'stats_obj',
          'type' => TType::STRUCT,
          'class' => '\metastore\ColumnStatistics',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['stats_obj'])) {
        $this->stats_obj = $vals['stats_obj'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_update_table_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->stats_obj = new \metastore\ColumnStatistics();
            $xfer += $this->stats_obj->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_update_table_column_statistics_args');
    if ($this->stats_obj !== null) {
      if (!is_object($this->stats_obj)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('stats_obj', TType::STRUCT, 1);
      $xfer += $this->stats_obj->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_update_table_column_statistics_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_update_table_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_update_table_column_statistics_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_update_partition_column_statistics_args {
  static $_TSPEC;

  public $stats_obj = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'stats_obj',
          'type' => TType::STRUCT,
          'class' => '\metastore\ColumnStatistics',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['stats_obj'])) {
        $this->stats_obj = $vals['stats_obj'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_update_partition_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->stats_obj = new \metastore\ColumnStatistics();
            $xfer += $this->stats_obj->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_update_partition_column_statistics_args');
    if ($this->stats_obj !== null) {
      if (!is_object($this->stats_obj)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('stats_obj', TType::STRUCT, 1);
      $xfer += $this->stats_obj->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_update_partition_column_statistics_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_update_partition_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_update_partition_column_statistics_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_column_statistics_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $col_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'col_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['col_name'])) {
        $this->col_name = $vals['col_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->col_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_column_statistics_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->col_name !== null) {
      $xfer += $output->writeFieldBegin('col_name', TType::STRING, 3);
      $xfer += $output->writeString($this->col_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_column_statistics_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\ColumnStatistics',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\ColumnStatistics();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\InvalidInputException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidObjectException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_column_statistics_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_column_statistics_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_name = null;
  public $col_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'col_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
      if (isset($vals['col_name'])) {
        $this->col_name = $vals['col_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->col_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_column_statistics_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->col_name !== null) {
      $xfer += $output->writeFieldBegin('col_name', TType::STRING, 4);
      $xfer += $output->writeString($this->col_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_column_statistics_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\ColumnStatistics',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\ColumnStatistics();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\InvalidInputException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidObjectException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_column_statistics_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_delete_partition_column_statistics_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $part_name = null;
  public $col_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'col_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
      if (isset($vals['col_name'])) {
        $this->col_name = $vals['col_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_delete_partition_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->col_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_delete_partition_column_statistics_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->col_name !== null) {
      $xfer += $output->writeFieldBegin('col_name', TType::STRING, 4);
      $xfer += $output->writeString($this->col_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_delete_partition_column_statistics_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_delete_partition_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\InvalidObjectException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_delete_partition_column_statistics_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_delete_table_column_statistics_args {
  static $_TSPEC;

  public $db_name = null;
  public $tbl_name = null;
  public $col_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'col_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['col_name'])) {
        $this->col_name = $vals['col_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_delete_table_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->col_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_delete_table_column_statistics_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->col_name !== null) {
      $xfer += $output->writeFieldBegin('col_name', TType::STRING, 3);
      $xfer += $output->writeString($this->col_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_delete_table_column_statistics_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;
  public $o2 = null;
  public $o3 = null;
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_delete_table_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\InvalidObjectException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_delete_table_column_statistics_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_role_args {
  static $_TSPEC;

  public $role = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'role',
          'type' => TType::STRUCT,
          'class' => '\metastore\Role',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['role'])) {
        $this->role = $vals['role'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_role_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->role = new \metastore\Role();
            $xfer += $this->role->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_role_args');
    if ($this->role !== null) {
      if (!is_object($this->role)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('role', TType::STRUCT, 1);
      $xfer += $this->role->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_role_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_role_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_role_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_role_args {
  static $_TSPEC;

  public $role_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'role_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['role_name'])) {
        $this->role_name = $vals['role_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_role_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->role_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_role_args');
    if ($this->role_name !== null) {
      $xfer += $output->writeFieldBegin('role_name', TType::STRING, 1);
      $xfer += $output->writeString($this->role_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_role_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_role_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_role_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_role_names_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_role_names_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_role_names_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_role_names_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_role_names_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size531 = 0;
            $_etype534 = 0;
            $xfer += $input->readListBegin($_etype534, $_size531);
            for ($_i535 = 0; $_i535 < $_size531; ++$_i535)
            {
              $elem536 = null;
              $xfer += $input->readString($elem536);
              $this->success []= $elem536;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_role_names_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter537)
          {
            $xfer += $output->writeString($iter537);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_grant_role_args {
  static $_TSPEC;

  public $role_name = null;
  public $principal_name = null;
  public $principal_type = null;
  public $grantor = null;
  public $grantorType = null;
  public $grant_option = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'role_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'principal_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'principal_type',
          'type' => TType::I32,
          ),
        4 => array(
          'var' => 'grantor',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'grantorType',
          'type' => TType::I32,
          ),
        6 => array(
          'var' => 'grant_option',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['role_name'])) {
        $this->role_name = $vals['role_name'];
      }
      if (isset($vals['principal_name'])) {
        $this->principal_name = $vals['principal_name'];
      }
      if (isset($vals['principal_type'])) {
        $this->principal_type = $vals['principal_type'];
      }
      if (isset($vals['grantor'])) {
        $this->grantor = $vals['grantor'];
      }
      if (isset($vals['grantorType'])) {
        $this->grantorType = $vals['grantorType'];
      }
      if (isset($vals['grant_option'])) {
        $this->grant_option = $vals['grant_option'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_grant_role_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->role_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->principal_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->principal_type);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->grantor);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->grantorType);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->grant_option);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_grant_role_args');
    if ($this->role_name !== null) {
      $xfer += $output->writeFieldBegin('role_name', TType::STRING, 1);
      $xfer += $output->writeString($this->role_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->principal_name !== null) {
      $xfer += $output->writeFieldBegin('principal_name', TType::STRING, 2);
      $xfer += $output->writeString($this->principal_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->principal_type !== null) {
      $xfer += $output->writeFieldBegin('principal_type', TType::I32, 3);
      $xfer += $output->writeI32($this->principal_type);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->grantor !== null) {
      $xfer += $output->writeFieldBegin('grantor', TType::STRING, 4);
      $xfer += $output->writeString($this->grantor);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->grantorType !== null) {
      $xfer += $output->writeFieldBegin('grantorType', TType::I32, 5);
      $xfer += $output->writeI32($this->grantorType);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->grant_option !== null) {
      $xfer += $output->writeFieldBegin('grant_option', TType::BOOL, 6);
      $xfer += $output->writeBool($this->grant_option);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_grant_role_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_grant_role_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_grant_role_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_revoke_role_args {
  static $_TSPEC;

  public $role_name = null;
  public $principal_name = null;
  public $principal_type = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'role_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'principal_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'principal_type',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['role_name'])) {
        $this->role_name = $vals['role_name'];
      }
      if (isset($vals['principal_name'])) {
        $this->principal_name = $vals['principal_name'];
      }
      if (isset($vals['principal_type'])) {
        $this->principal_type = $vals['principal_type'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_revoke_role_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->role_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->principal_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->principal_type);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_revoke_role_args');
    if ($this->role_name !== null) {
      $xfer += $output->writeFieldBegin('role_name', TType::STRING, 1);
      $xfer += $output->writeString($this->role_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->principal_name !== null) {
      $xfer += $output->writeFieldBegin('principal_name', TType::STRING, 2);
      $xfer += $output->writeString($this->principal_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->principal_type !== null) {
      $xfer += $output->writeFieldBegin('principal_type', TType::I32, 3);
      $xfer += $output->writeI32($this->principal_type);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_revoke_role_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_revoke_role_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_revoke_role_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_list_roles_args {
  static $_TSPEC;

  public $principal_name = null;
  public $principal_type = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'principal_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'principal_type',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['principal_name'])) {
        $this->principal_name = $vals['principal_name'];
      }
      if (isset($vals['principal_type'])) {
        $this->principal_type = $vals['principal_type'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_list_roles_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->principal_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->principal_type);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_list_roles_args');
    if ($this->principal_name !== null) {
      $xfer += $output->writeFieldBegin('principal_name', TType::STRING, 1);
      $xfer += $output->writeString($this->principal_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->principal_type !== null) {
      $xfer += $output->writeFieldBegin('principal_type', TType::I32, 2);
      $xfer += $output->writeI32($this->principal_type);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_list_roles_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Role',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_list_roles_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size538 = 0;
            $_etype541 = 0;
            $xfer += $input->readListBegin($_etype541, $_size538);
            for ($_i542 = 0; $_i542 < $_size538; ++$_i542)
            {
              $elem543 = null;
              $elem543 = new \metastore\Role();
              $xfer += $elem543->read($input);
              $this->success []= $elem543;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_list_roles_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter544)
          {
            $xfer += $iter544->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_privilege_set_args {
  static $_TSPEC;

  public $hiveObject = null;
  public $user_name = null;
  public $group_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'hiveObject',
          'type' => TType::STRUCT,
          'class' => '\metastore\HiveObjectRef',
          ),
        2 => array(
          'var' => 'user_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'group_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['hiveObject'])) {
        $this->hiveObject = $vals['hiveObject'];
      }
      if (isset($vals['user_name'])) {
        $this->user_name = $vals['user_name'];
      }
      if (isset($vals['group_names'])) {
        $this->group_names = $vals['group_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_privilege_set_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->hiveObject = new \metastore\HiveObjectRef();
            $xfer += $this->hiveObject->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->user_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->group_names = array();
            $_size545 = 0;
            $_etype548 = 0;
            $xfer += $input->readListBegin($_etype548, $_size545);
            for ($_i549 = 0; $_i549 < $_size545; ++$_i549)
            {
              $elem550 = null;
              $xfer += $input->readString($elem550);
              $this->group_names []= $elem550;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_privilege_set_args');
    if ($this->hiveObject !== null) {
      if (!is_object($this->hiveObject)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('hiveObject', TType::STRUCT, 1);
      $xfer += $this->hiveObject->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->user_name !== null) {
      $xfer += $output->writeFieldBegin('user_name', TType::STRING, 2);
      $xfer += $output->writeString($this->user_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->group_names !== null) {
      if (!is_array($this->group_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('group_names', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->group_names));
        {
          foreach ($this->group_names as $iter551)
          {
            $xfer += $output->writeString($iter551);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_privilege_set_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\PrincipalPrivilegeSet',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_privilege_set_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\PrincipalPrivilegeSet();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_privilege_set_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_list_privileges_args {
  static $_TSPEC;

  public $principal_name = null;
  public $principal_type = null;
  public $hiveObject = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'principal_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'principal_type',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'hiveObject',
          'type' => TType::STRUCT,
          'class' => '\metastore\HiveObjectRef',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['principal_name'])) {
        $this->principal_name = $vals['principal_name'];
      }
      if (isset($vals['principal_type'])) {
        $this->principal_type = $vals['principal_type'];
      }
      if (isset($vals['hiveObject'])) {
        $this->hiveObject = $vals['hiveObject'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_list_privileges_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->principal_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->principal_type);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->hiveObject = new \metastore\HiveObjectRef();
            $xfer += $this->hiveObject->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_list_privileges_args');
    if ($this->principal_name !== null) {
      $xfer += $output->writeFieldBegin('principal_name', TType::STRING, 1);
      $xfer += $output->writeString($this->principal_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->principal_type !== null) {
      $xfer += $output->writeFieldBegin('principal_type', TType::I32, 2);
      $xfer += $output->writeI32($this->principal_type);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->hiveObject !== null) {
      if (!is_object($this->hiveObject)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('hiveObject', TType::STRUCT, 3);
      $xfer += $this->hiveObject->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_list_privileges_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\HiveObjectPrivilege',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_list_privileges_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size552 = 0;
            $_etype555 = 0;
            $xfer += $input->readListBegin($_etype555, $_size552);
            for ($_i556 = 0; $_i556 < $_size552; ++$_i556)
            {
              $elem557 = null;
              $elem557 = new \metastore\HiveObjectPrivilege();
              $xfer += $elem557->read($input);
              $this->success []= $elem557;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_list_privileges_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter558)
          {
            $xfer += $iter558->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_grant_privileges_args {
  static $_TSPEC;

  public $privileges = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'privileges',
          'type' => TType::STRUCT,
          'class' => '\metastore\PrivilegeBag',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['privileges'])) {
        $this->privileges = $vals['privileges'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_grant_privileges_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->privileges = new \metastore\PrivilegeBag();
            $xfer += $this->privileges->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_grant_privileges_args');
    if ($this->privileges !== null) {
      if (!is_object($this->privileges)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('privileges', TType::STRUCT, 1);
      $xfer += $this->privileges->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_grant_privileges_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_grant_privileges_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_grant_privileges_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_revoke_privileges_args {
  static $_TSPEC;

  public $privileges = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'privileges',
          'type' => TType::STRUCT,
          'class' => '\metastore\PrivilegeBag',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['privileges'])) {
        $this->privileges = $vals['privileges'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_revoke_privileges_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->privileges = new \metastore\PrivilegeBag();
            $xfer += $this->privileges->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_revoke_privileges_args');
    if ($this->privileges !== null) {
      if (!is_object($this->privileges)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('privileges', TType::STRUCT, 1);
      $xfer += $this->privileges->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_revoke_privileges_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_revoke_privileges_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_revoke_privileges_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_set_ugi_args {
  static $_TSPEC;

  public $user_name = null;
  public $group_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'user_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'group_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['user_name'])) {
        $this->user_name = $vals['user_name'];
      }
      if (isset($vals['group_names'])) {
        $this->group_names = $vals['group_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_set_ugi_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->user_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->group_names = array();
            $_size559 = 0;
            $_etype562 = 0;
            $xfer += $input->readListBegin($_etype562, $_size559);
            for ($_i563 = 0; $_i563 < $_size559; ++$_i563)
            {
              $elem564 = null;
              $xfer += $input->readString($elem564);
              $this->group_names []= $elem564;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_set_ugi_args');
    if ($this->user_name !== null) {
      $xfer += $output->writeFieldBegin('user_name', TType::STRING, 1);
      $xfer += $output->writeString($this->user_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->group_names !== null) {
      if (!is_array($this->group_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('group_names', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRING, count($this->group_names));
        {
          foreach ($this->group_names as $iter565)
          {
            $xfer += $output->writeString($iter565);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_set_ugi_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_set_ugi_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size566 = 0;
            $_etype569 = 0;
            $xfer += $input->readListBegin($_etype569, $_size566);
            for ($_i570 = 0; $_i570 < $_size566; ++$_i570)
            {
              $elem571 = null;
              $xfer += $input->readString($elem571);
              $this->success []= $elem571;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_set_ugi_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter572)
          {
            $xfer += $output->writeString($iter572);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_delegation_token_args {
  static $_TSPEC;

  public $token_owner = null;
  public $renewer_kerberos_principal_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'token_owner',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'renewer_kerberos_principal_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['token_owner'])) {
        $this->token_owner = $vals['token_owner'];
      }
      if (isset($vals['renewer_kerberos_principal_name'])) {
        $this->renewer_kerberos_principal_name = $vals['renewer_kerberos_principal_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_delegation_token_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->token_owner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->renewer_kerberos_principal_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_delegation_token_args');
    if ($this->token_owner !== null) {
      $xfer += $output->writeFieldBegin('token_owner', TType::STRING, 1);
      $xfer += $output->writeString($this->token_owner);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->renewer_kerberos_principal_name !== null) {
      $xfer += $output->writeFieldBegin('renewer_kerberos_principal_name', TType::STRING, 2);
      $xfer += $output->writeString($this->renewer_kerberos_principal_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_delegation_token_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_delegation_token_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_delegation_token_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_renew_delegation_token_args {
  static $_TSPEC;

  public $token_str_form = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'token_str_form',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['token_str_form'])) {
        $this->token_str_form = $vals['token_str_form'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_renew_delegation_token_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->token_str_form);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_renew_delegation_token_args');
    if ($this->token_str_form !== null) {
      $xfer += $output->writeFieldBegin('token_str_form', TType::STRING, 1);
      $xfer += $output->writeString($this->token_str_form);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_renew_delegation_token_result {
  static $_TSPEC;

  public $success = null;
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I64,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_renew_delegation_token_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_renew_delegation_token_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I64, 0);
      $xfer += $output->writeI64($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_cancel_delegation_token_args {
  static $_TSPEC;

  public $token_str_form = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'token_str_form',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['token_str_form'])) {
        $this->token_str_form = $vals['token_str_form'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_cancel_delegation_token_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->token_str_form);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_cancel_delegation_token_args');
    if ($this->token_str_form !== null) {
      $xfer += $output->writeFieldBegin('token_str_form', TType::STRING, 1);
      $xfer += $output->writeString($this->token_str_form);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_cancel_delegation_token_result {
  static $_TSPEC;

  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_cancel_delegation_token_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_cancel_delegation_token_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}


