/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.ExportOutputFormat;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.manager.oracle.OraOopLog;
import org.apache.sqoop.manager.oracle.OraOopLogFactory;
import org.apache.sqoop.manager.oracle.OraOopOracleQueries;
import org.apache.sqoop.manager.oracle.OraOopUtilities;
import org.apache.sqoop.manager.oracle.OracleConnectionFactory;
import org.apache.sqoop.manager.oracle.OracleTable;
import org.apache.sqoop.manager.oracle.OracleTableColumn;
import org.apache.sqoop.manager.oracle.OracleTableColumns;
import org.apache.sqoop.manager.oracle.OracleVersion;

abstract class OraOopOutputFormatBase<K extends SqoopRecord, V>
extends ExportOutputFormat<K, V> {
    private static final OraOopLog LOG = OraOopLogFactory.getLog(OraOopOutputFormatBase.class);

    OraOopOutputFormatBase() {
    }

    @Override
    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        super.checkOutputSpecs(context);
        Configuration conf = context.getConfiguration();
        OraOopUtilities.enableDebugLoggingIfRequired(conf);
    }

    protected int getMapperId(TaskAttemptContext context) {
        return context.getTaskAttemptID().getTaskID().getId();
    }

    protected void applyMapperJdbcUrl(TaskAttemptContext context, int mapperId) {
        Configuration conf = context.getConfiguration();
        String mapperJdbcUrlPropertyName = OraOopUtilities.getMapperJdbcUrlPropertyName(mapperId, conf);
        String mapperJdbcUrl = conf.get(mapperJdbcUrlPropertyName, null);
        LOG.debug(String.format("Mapper %d has a JDBC URL of: %s", mapperId, mapperJdbcUrl == null ? "<null>" : mapperJdbcUrl));
        if (mapperJdbcUrl != null) {
            conf.set("mapreduce.jdbc.url", mapperJdbcUrl);
        }
    }

    protected boolean canUseOracleAppendValuesHint(TaskAttemptContext context) {
        Configuration conf = context.getConfiguration();
        OracleVersion oracleVersion = new OracleVersion(conf.getInt("oraoop.oracle.database.version.major", 0), conf.getInt("oraoop.oracle.database.version.minor", 0), 0, 0, "");
        boolean result = oracleVersion.isGreaterThanOrEqualTo(11, 2, 0, 0);
        if (result) {
            boolean binaryDoubleColumnExists = conf.getBoolean("oraoop.table.contains.binary.double.column", false);
            boolean binaryFloatColumnExists = conf.getBoolean("oraoop.table.contains.binary.float.column", false);
            if (binaryDoubleColumnExists || binaryFloatColumnExists) {
                result = false;
                LOG.info("The APPEND_VALUES Oracle hint will not be used for the INSERT SQL statement, as the Oracle table contains either a BINARY_DOUBLE or BINARY_FLOAT column.");
            }
        }
        return result;
    }

    protected boolean allowUserToOverrideUseOfTheOracleAppendValuesHint(TaskAttemptContext context, boolean useAppendValuesOracleHint) {
        Configuration conf = context.getConfiguration();
        boolean result = useAppendValuesOracleHint;
        switch (OraOopUtilities.getOracleAppendValuesHintUsage(conf)) {
            case OFF: {
                result = false;
                LOG.debug(String.format("Use of the APPEND_VALUES Oracle hint has been forced OFF. (It was %s to used).", useAppendValuesOracleHint ? "going" : "not going"));
                break;
            }
            case ON: {
                result = true;
                LOG.debug(String.format("Use of the APPEND_VALUES Oracle hint has been forced ON. (It was %s to used).", useAppendValuesOracleHint ? "going" : "not going"));
                break;
            }
            case AUTO: {
                LOG.debug(String.format("The APPEND_VALUES Oracle hint %s be used.", result ? "will" : "will not"));
                break;
            }
            default: {
                throw new RuntimeException("Invalid value for APPEND_VALUES.");
            }
        }
        return result;
    }

    protected void updateBatchSizeInConfigurationToAllowOracleAppendValuesHint(TaskAttemptContext context) {
        int minAppendValuesBatchSize;
        int originalBatchSize;
        Configuration conf = context.getConfiguration();
        int originalBatchesPerCommit = conf.getInt("sqoop.export.statements.per.transaction", 0);
        if (originalBatchesPerCommit != 1) {
            conf.setInt("sqoop.export.statements.per.transaction", 1);
            LOG.info(String.format("The number of batch-inserts to perform per commit has been changed from %d to %d. This is in response to the Oracle APPEND_VALUES hint being used.", originalBatchesPerCommit, 1));
        }
        if ((originalBatchSize = conf.getInt("sqoop.export.records.per.statement", 0)) < (minAppendValuesBatchSize = OraOopUtilities.getMinAppendValuesBatchSize(conf))) {
            conf.setInt("sqoop.export.records.per.statement", minAppendValuesBatchSize);
            LOG.info(String.format("The number of rows per batch-insert has been changed from %d to %d. This is in response to the Oracle APPEND_VALUES hint being used.", originalBatchSize, minAppendValuesBatchSize));
        }
    }

    abstract class OraOopDBRecordWriterBase
    extends ExportOutputFormat.ExportRecordWriter<K, V> {
        protected OracleTable oracleTable;
        private OracleTableColumns oracleTableColumns;
        protected int mapperId;
        protected boolean tableHasMapperRowNumberColumn;
        protected long mapperRowNumber;

        public OraOopDBRecordWriterBase(TaskAttemptContext context, int mapperId) throws ClassNotFoundException, SQLException {
            super(context);
            this.mapperId = mapperId;
            this.mapperRowNumber = 1L;
            Configuration conf = context.getConfiguration();
            this.logBatchSettings();
            Connection connection = this.getConnection();
            String thisOracleInstanceName = OraOopOracleQueries.getCurrentOracleInstanceName(connection);
            LOG.info(String.format("This record writer is connected to Oracle via the JDBC URL: \n\t\"%s\"\n\tto the Oracle instance: \"%s\"", connection.toString(), thisOracleInstanceName));
            OracleConnectionFactory.initializeOracleConnection(connection, conf);
            connection.setAutoCommit(false);
        }

        protected void setOracleTableColumns(OracleTableColumns newOracleTableColumns) {
            this.oracleTableColumns = newOracleTableColumns;
            this.tableHasMapperRowNumberColumn = this.oracleTableColumns.findColumnByName("ORAOOP_MAPPER_ROW") != null;
        }

        protected OracleTableColumns getOracleTableColumns() {
            return this.oracleTableColumns;
        }

        protected void getExportTableAndColumns(TaskAttemptContext context) throws SQLException {
            Configuration conf = context.getConfiguration();
            String schema = context.getConfiguration().get("oraoop.table.owner");
            String localTableName = context.getConfiguration().get("oraoop.table.name");
            if (schema == null || schema.isEmpty() || localTableName == null || localTableName.isEmpty()) {
                throw new RuntimeException("Unable to recall the schema and name of the Oracle table being exported.");
            }
            this.oracleTable = new OracleTable(schema, localTableName);
            this.setOracleTableColumns(OraOopOracleQueries.getTableColumns(this.getConnection(), this.oracleTable, OraOopUtilities.omitLobAndLongColumnsDuringImport(conf), OraOopUtilities.recallSqoopJobType(conf), true, false));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected PreparedStatement getPreparedStatement(List<SqoopRecord> userRecords) throws SQLException {
            PreparedStatement statement;
            Connection connection = this.getConnection();
            String sql = this.getBatchSqlStatement();
            LOG.debug(String.format("Prepared Statement SQL:\n%s", sql));
            try {
                Connection connection2 = connection;
                synchronized (connection2) {
                    statement = connection.prepareStatement(sql);
                }
                this.configurePreparedStatement(statement, userRecords);
            }
            catch (Exception ex) {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                LOG.error(String.format("The following error occurred during %s", OraOopUtilities.getCurrentMethodName()), ex);
                throw new SQLException(ex);
            }
            return statement;
        }

        @Override
        protected boolean isBatchExec() {
            return true;
        }

        @Override
        protected String getInsertStatement(int numRows) {
            throw new UnsupportedOperationException(String.format("%s should not be called, as %s operates in batch mode.", OraOopUtilities.getCurrentMethodName(), ((Object)((Object)this)).getClass().getName()));
        }

        protected String getBatchInsertSqlStatement(String oracleHint) {
            StringBuilder sqlNames = new StringBuilder();
            StringBuilder sqlValues = new StringBuilder();
            int colCount = 0;
            for (int idx = 0; idx < this.oracleTableColumns.size(); ++idx) {
                OracleTableColumn oracleTableColumn = (OracleTableColumn)this.oracleTableColumns.get(idx);
                String columnName = oracleTableColumn.getName();
                if (colCount > 0) {
                    sqlNames.append("\n,");
                }
                sqlNames.append(columnName);
                if (colCount > 0) {
                    sqlValues.append("\n,");
                }
                String pseudoColumnValue = this.generateInsertValueForPseudoColumn(columnName);
                String bindVarName = null;
                if (pseudoColumnValue != null) {
                    bindVarName = pseudoColumnValue;
                } else if (oracleTableColumn.getOracleType() == OraOopOracleQueries.getOracleType("STRUCT")) {
                    if (oracleTableColumn.getDataType().equals("URITYPE")) {
                        bindVarName = String.format("urifactory.getUri(%s)", this.columnNameToBindVariable(columnName));
                    }
                } else if (this.getConf().getBoolean("oraoop.timestamp.string", true)) {
                    if (oracleTableColumn.getOracleType() == OraOopOracleQueries.getOracleType("DATE")) {
                        bindVarName = String.format("to_date(%s, 'yyyy-mm-dd hh24:mi:ss')", this.columnNameToBindVariable(columnName));
                    } else if (oracleTableColumn.getOracleType() == OraOopOracleQueries.getOracleType("TIMESTAMP")) {
                        bindVarName = String.format("to_timestamp(%s, 'yyyy-mm-dd hh24:mi:ss.ff')", this.columnNameToBindVariable(columnName));
                    } else if (oracleTableColumn.getOracleType() == OraOopOracleQueries.getOracleType("TIMESTAMPTZ")) {
                        bindVarName = String.format("to_timestamp_tz(%s, 'yyyy-mm-dd hh24:mi:ss.ff TZR')", this.columnNameToBindVariable(columnName));
                    } else if (oracleTableColumn.getOracleType() == OraOopOracleQueries.getOracleType("TIMESTAMPLTZ")) {
                        bindVarName = String.format("to_timestamp_tz(%s, 'yyyy-mm-dd hh24:mi:ss.ff TZR')", this.columnNameToBindVariable(columnName));
                    }
                }
                if (bindVarName == null) {
                    bindVarName = this.columnNameToBindVariable(columnName);
                }
                sqlValues.append(bindVarName);
                ++colCount;
            }
            String sql = String.format("insert %s into %s\n(%s)\nvalues\n(%s)\n", oracleHint, this.oracleTable.toString(), sqlNames.toString(), sqlValues.toString());
            LOG.info("Batch-Mode insert statement:\n" + sql);
            return sql;
        }

        abstract void configurePreparedStatement(PreparedStatement var1, List<SqoopRecord> var2) throws SQLException;

        /*
         * Enabled aggressive block sorting
         */
        private void setBindValueAtName(PreparedStatement statement, String bindValueName, Object bindValue, OracleTableColumn column) throws SQLException {
            if (column.getOracleType() == OraOopOracleQueries.getOracleType("NUMBER")) {
                OraOopOracleQueries.setBigDecimalAtName(statement, bindValueName, (BigDecimal)bindValue);
                return;
            }
            if (column.getOracleType() == OraOopOracleQueries.getOracleType("VARCHAR")) {
                OraOopOracleQueries.setStringAtName(statement, bindValueName, (String)bindValue);
                return;
            }
            if (column.getOracleType() == OraOopOracleQueries.getOracleType("TIMESTAMP") || column.getOracleType() == OraOopOracleQueries.getOracleType("TIMESTAMPTZ") || column.getOracleType() == OraOopOracleQueries.getOracleType("TIMESTAMPLTZ")) {
                Object objValue = bindValue;
                if (objValue instanceof Timestamp) {
                    Timestamp value = (Timestamp)objValue;
                    OraOopOracleQueries.setTimestampAtName(statement, bindValueName, value);
                    return;
                }
                String value = (String)objValue;
                if (value == null || value.equalsIgnoreCase("null")) {
                    value = "";
                }
                OraOopOracleQueries.setStringAtName(statement, bindValueName, value);
                return;
            }
            if (column.getOracleType() == OraOopOracleQueries.getOracleType("BINARY_DOUBLE")) {
                Double value = (Double)bindValue;
                if (value != null) {
                    OraOopOracleQueries.setBinaryDoubleAtName(statement, bindValueName, value);
                    return;
                }
                OraOopOracleQueries.setObjectAtName(statement, bindValueName, null);
                return;
            }
            if (column.getOracleType() == OraOopOracleQueries.getOracleType("BINARY_FLOAT")) {
                Float value = (Float)bindValue;
                if (value != null) {
                    OraOopOracleQueries.setBinaryFloatAtName(statement, bindValueName, value.floatValue());
                    return;
                }
                OraOopOracleQueries.setObjectAtName(statement, bindValueName, null);
                return;
            }
            if (column.getOracleType() != OraOopOracleQueries.getOracleType("STRUCT")) {
                String msg = String.format("%s may need to be updated to cope with the data-type: %s", OraOopUtilities.getCurrentMethodName(), column.getOracleType());
                LOG.debug(msg);
                OraOopOracleQueries.setObjectAtName(statement, bindValueName, bindValue);
                return;
            }
            if (column.getDataType().equals("URITYPE")) {
                String value = (String)bindValue;
                OraOopOracleQueries.setStringAtName(statement, bindValueName, value);
                return;
            }
            String msg = String.format("%s needs to be updated to cope with the data-type: %s where the Oracle data_type is \"%s\".", OraOopUtilities.getCurrentMethodName(), column.getDataType(), column.getOracleType());
            LOG.error(msg);
            throw new UnsupportedOperationException(msg);
        }

        protected void configurePreparedStatementColumns(PreparedStatement statement, Map<String, Object> fieldMap) throws SQLException {
            String bindValueName;
            if (this.tableHasMapperRowNumberColumn) {
                bindValueName = this.columnNameToBindVariable("ORAOOP_MAPPER_ROW").replaceFirst(":", "");
                try {
                    OraOopOracleQueries.setLongAtName(statement, bindValueName, this.mapperRowNumber);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                ++this.mapperRowNumber;
            }
            for (String colName : fieldMap.keySet()) {
                bindValueName = this.columnNameToBindVariable(colName).replaceFirst(":", "");
                OracleTableColumn oracleTableColumn = this.oracleTableColumns.findColumnByName(colName);
                this.setBindValueAtName(statement, bindValueName, fieldMap.get(colName), oracleTableColumn);
            }
            statement.addBatch();
        }

        abstract String getBatchSqlStatement();

        protected String columnNameToBindVariable(String columnName) {
            return ":" + columnName;
        }

        @Override
        public void write(K key, V value) throws InterruptedException, IOException {
            try {
                super.write(key, value);
            }
            catch (IOException ex) {
                this.showSqlBatchErrorDetails(ex);
                throw ex;
            }
        }

        @Override
        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            try {
                super.close(context);
            }
            catch (IOException ex) {
                this.showSqlBatchErrorDetails(ex);
                throw ex;
            }
        }

        private void showSqlBatchErrorDetails(Exception exception) {
            if (OraOopUtilities.oracleSessionHasBeenKilled(exception)) {
                LOG.info("\n*********************************************************\nThe Oracle session in use has been killed by a 3rd party.\n*********************************************************");
            }
        }

        protected Object getJobSysDate(TaskAttemptContext context) {
            Configuration conf = context.getConfiguration();
            return OraOopUtilities.recallOracleDateTime(conf, "oraoop.job.sysdate");
        }

        protected OracleTable createUniqueMapperTable(TaskAttemptContext context) throws SQLException {
            Configuration conf = context.getConfiguration();
            Object sysDateTime = this.getJobSysDate(context);
            String schema = conf.get("oraoop.table.owner");
            String localTableName = conf.get("oraoop.table.name");
            OracleTable templateTable = new OracleTable(schema, localTableName);
            OracleTable mapperTable = OraOopUtilities.generateExportTableMapperTableName(this.mapperId, sysDateTime, null);
            OraOopOracleQueries.dropTable(this.getConnection(), mapperTable);
            String temporaryTableStorageClause = OraOopUtilities.getTemporaryTableStorageClause(conf);
            OraOopOracleQueries.createExportTableForMapper(this.getConnection(), mapperTable, temporaryTableStorageClause, templateTable, false);
            LOG.debug(String.format("Created temporary mapper table %s", mapperTable.toString()));
            return mapperTable;
        }

        protected String generateInsertValueForPseudoColumn(String columnName) {
            if (columnName.equalsIgnoreCase("ORAOOP_EXPORT_SYSDATE")) {
                String partitionValueStr = this.getConf().get("oraoop.export.partition.date.value", null);
                if (partitionValueStr == null) {
                    throw new RuntimeException("Unable to recall the value of the partition date-time.");
                }
                return String.format("to_date('%s', '%s')", partitionValueStr, "yyyy-mm-dd hh24:mi:ss");
            }
            if (columnName.equalsIgnoreCase("ORAOOP_MAPPER_ID")) {
                return Integer.toString(this.mapperId);
            }
            return null;
        }

        protected void logBatchSettings() {
            LOG.info(String.format("The number of rows per batch is: %d", this.rowsPerStmt));
            int stmtsPerTx = this.getConf().getInt("sqoop.export.statements.per.transaction", 100);
            LOG.info(String.format("The number of batches per commit is: %d", stmtsPerTx));
        }
    }
}

