/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.manager.oracle.OraOopLog;
import org.apache.sqoop.manager.oracle.OraOopLogFactory;
import org.apache.sqoop.manager.oracle.OraOopOracleQueries;
import org.apache.sqoop.manager.oracle.OraOopUtilities;

public class OracleConnectionFactory {
    protected static final OraOopLog LOG = OraOopLogFactory.getLog(OracleConnectionFactory.class.getName());

    protected OracleConnectionFactory() {
    }

    public static Connection createOracleJdbcConnection(String jdbcDriverClassName, String jdbcUrl, String username, String password) throws SQLException {
        Properties props = null;
        return OracleConnectionFactory.createOracleJdbcConnection(jdbcDriverClassName, jdbcUrl, username, password, props);
    }

    public static Connection createOracleJdbcConnection(String jdbcDriverClassName, String jdbcUrl, String username, String password, Properties additionalProps) throws SQLException {
        OracleConnectionFactory.loadJdbcDriver(jdbcDriverClassName);
        Connection connection = OracleConnectionFactory.createConnection(jdbcUrl, username, password, additionalProps);
        return connection;
    }

    private static void loadJdbcDriver(String jdbcDriverClassName) {
        try {
            Class.forName(jdbcDriverClassName);
        }
        catch (ClassNotFoundException ex) {
            String errorMsg = "Unable to load the jdbc driver class : " + jdbcDriverClassName;
            LOG.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
    }

    private static Connection createConnection(String jdbcUrl, String username, String password, Properties additionalProps) throws SQLException {
        Properties props = new Properties();
        if (username != null) {
            props.put("user", username);
        }
        if (password != null) {
            props.put("password", password);
        }
        if (additionalProps != null && additionalProps.size() > 0) {
            props.putAll((Map<?, ?>)additionalProps);
        }
        try {
            return DriverManager.getConnection(jdbcUrl, props);
        }
        catch (SQLException ex) {
            String errorMsg = String.format("Unable to obtain a JDBC connection to the URL \"%s\" as user \"%s\": ", jdbcUrl, username != null ? username : "[null]");
            LOG.error(errorMsg, ex);
            throw ex;
        }
    }

    public static void initializeOracleConnection(Connection connection, Configuration conf) throws SQLException {
        connection.setTransactionIsolation(2);
        OraOopOracleQueries.setConnectionTimeZone(connection, conf);
        OracleConnectionFactory.setSessionClientInfo(connection, conf);
        OraOopOracleQueries.setJdbcFetchSize(connection, conf);
        OracleConnectionFactory.executeOraOopSessionInitializationStatements(connection, conf);
    }

    protected static void setSessionClientInfo(Connection connection, Configuration conf) {
        String sql = "";
        try {
            sql = "begin \n  dbms_application_info.set_module(module_name => '%s', action_name => '%s'); \nend;";
            String oracleSessionActionName = conf.get("oraoop.oracle.session.module.action");
            sql = String.format(sql, "Data Connector for Oracle and Hadoop", oracleSessionActionName);
            Statement statement = connection.createStatement();
            statement.execute(sql);
            LOG.info("Initializing Oracle session with SQL :\n" + sql);
        }
        catch (Exception ex) {
            LOG.error(String.format("An error occurred while attempting to execute the following Oracle session-initialization statement:\n%s\nError:\n%s", sql, ex.getMessage()));
        }
    }

    protected static void executeOraOopSessionInitializationStatements(Connection connection, Configuration conf) {
        List<String> statements = OracleConnectionFactory.parseOraOopSessionInitializationStatements(conf);
        if (statements.size() == 0) {
            LOG.warn(String.format("No Oracle 'session initialization' statements were found to execute.\nCheck that your %s and/or %s files are correctly installed in the ${SQOOP_HOME}/conf directory.", "oraoop-site-template.xml", "oraoop-site.xml"));
        } else {
            for (String statement : statements) {
                try {
                    connection.createStatement().execute(statement);
                    LOG.info("Initializing Oracle session with SQL : " + statement);
                }
                catch (Exception ex) {
                    LOG.error(String.format("An error occurred while attempting to execute the following Oracle session-initialization statement:\n%s\nError:\n%s", statement, ex.getMessage()));
                }
            }
        }
    }

    protected static List<String> parseOraOopSessionInitializationStatements(Configuration conf) {
        ArrayList<String> result = new ArrayList<String>();
        if (conf == null) {
            throw new IllegalArgumentException("No configuration argument must be specified.");
        }
        String sessionInitializationStatements = conf.get("oraoop.oracle.session.initialization.statements");
        if (sessionInitializationStatements != null && !sessionInitializationStatements.isEmpty()) {
            String[] initializationStatements;
            for (String initializationStatement : initializationStatements = sessionInitializationStatements.split(";")) {
                if ((initializationStatement = initializationStatement.trim()) == null || initializationStatement.isEmpty() || initializationStatement.startsWith("--")) continue;
                LOG.debug(String.format("initializationStatement (quoted & pre-expression evaluation) = \"%s\"", initializationStatement));
                initializationStatement = OraOopUtilities.replaceConfigurationExpression(initializationStatement, conf);
                result.add(initializationStatement);
            }
        }
        return result;
    }
}

