/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.SynchronousQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.mapreduce.db.SQLFailureHandler;

public abstract class SQLServerAsyncDBExecThread
extends Thread {
    private static final Log LOG = LogFactory.getLog(SQLServerAsyncDBExecThread.class);
    protected static final int RETRY_MAX = 3;
    protected static final int RETRY_INTERVAL = 5000;
    private Connection conn;
    private DBConfiguration dbConf = null;
    private SynchronousQueue<List<SqoopRecord>> recordListQueue = new SynchronousQueue();
    private boolean stop = false;
    private Exception err;
    private SQLFailureHandler failureHandler = null;
    protected Configuration conf = null;
    protected String tableName;
    protected String[] columnNames;
    protected int columnCount;

    public void initialize(Configuration c) throws IOException {
        this.conf = c;
        this.dbConf = new DBConfiguration(this.conf);
        this.tableName = this.dbConf.getOutputTableName();
        this.columnNames = this.dbConf.getOutputFieldNames();
        this.columnCount = this.dbConf.getOutputFieldCount();
        this.failureHandler = this.getSQLFailureHandler();
        this.failureHandler.initialize(this.conf);
    }

    protected SQLFailureHandler getSQLFailureHandler() throws IOException {
        if (this.failureHandler == null) {
            Class connHandlerClass;
            try {
                String className = this.conf.get("sqoop.export.failure.handler.class");
                connHandlerClass = this.conf.getClassByName(className);
            }
            catch (ClassNotFoundException ex) {
                LOG.error((Object)"Failed to find class: sqoop.export.failure.handler.class");
                throw new IOException(ex);
            }
            if (!SQLFailureHandler.class.isAssignableFrom(connHandlerClass)) {
                String error = "A subclass of " + SQLFailureHandler.class.getName() + " is expected. Actual class set is: " + connHandlerClass.getName();
                LOG.error((Object)error);
                throw new IOException(error);
            }
            LOG.trace((Object)("Using connection handler class: " + connHandlerClass));
            this.failureHandler = (SQLFailureHandler)ReflectionUtils.newInstance((Class)connHandlerClass, (Configuration)this.conf);
        }
        return this.failureHandler;
    }

    protected DBConfiguration getDBConfiguration() {
        return this.dbConf;
    }

    protected Connection getConnection() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            try {
                this.conn = this.dbConf.getConnection();
                this.configureConnection();
            }
            catch (ClassNotFoundException cnfEx) {
                LOG.error((Object)("Cannot create connection. Driver class not found: " + cnfEx));
            }
        }
        return this.conn;
    }

    protected Configuration getConf() {
        return this.conf;
    }

    protected void configureConnection() throws SQLException {
        this.conn.setAutoCommit(false);
    }

    public void put(List<SqoopRecord> recordList) throws InterruptedException, IOException {
        Exception lastException = this.getLastError();
        if (lastException != null) {
            LOG.error((Object)("Asynchronous writer thread encountered the following exception: " + lastException.toString()));
            throw new IOException(lastException);
        }
        this.recordListQueue.put(recordList);
    }

    protected List<SqoopRecord> take() throws InterruptedException {
        return this.recordListQueue.take();
    }

    @Override
    public void start() {
        this.stop = false;
        super.start();
    }

    public void close() {
        this.stop = true;
        this.recordListQueue.offer(new ArrayList());
    }

    public boolean isRunning() {
        return !this.stop;
    }

    @Override
    public void run() {
        while (!this.stop) {
            List<SqoopRecord> recordList = null;
            try {
                recordList = this.take();
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)"Interrupted while waiting for more records");
                continue;
            }
            if (recordList == null || recordList.size() == 0) {
                LOG.warn((Object)"Got a Null or empty list. skipping");
                continue;
            }
            try {
                this.write(recordList);
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to write records.", (Throwable)ex);
                this.setLastError(ex);
                this.close();
                this.recordListQueue.poll();
            }
        }
    }

    protected void write(List<SqoopRecord> records) throws SQLException, IOException {
        PreparedStatement stmt = null;
        int retryCount = 3;
        boolean doRetry = true;
        do {
            try {
                this.getConnection();
                stmt = this.getPreparedStatement(records);
                this.executeStatement(stmt, records);
                doRetry = false;
            }
            catch (SQLException sqlEx) {
                LOG.warn((Object)"Trying to recover from DB write failure: ", (Throwable)sqlEx);
                if (this.failureHandler.canHandleFailure(sqlEx)) {
                    this.conn = this.failureHandler.recover();
                    this.configureConnection();
                    doRetry = --retryCount >= 0;
                    continue;
                }
                throw new IOException("Registered handler cannot recover error with SQL State: " + sqlEx.getSQLState() + ", error code: " + sqlEx.getErrorCode(), sqlEx);
            }
        } while (doRetry);
        if (retryCount < 0) {
            throw new IOException("Failed to write to database after 3 retries.");
        }
    }

    protected abstract PreparedStatement getPreparedStatement(List<SqoopRecord> var1) throws SQLException;

    protected abstract void executeStatement(PreparedStatement var1, List<SqoopRecord> var2) throws SQLException;

    public synchronized Exception getLastError() {
        Exception e = this.err;
        this.err = null;
        return e;
    }

    private synchronized void setLastError(Exception e) {
        if (this.err == null) {
            LOG.error((Object)("Got exception in update thread: " + StringUtils.stringifyException((Throwable)e)));
            this.err = e;
        } else {
            LOG.error((Object)("Exception in update thread but error slot full: " + StringUtils.stringifyException((Throwable)e)));
        }
    }
}

