/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.hcat;

import com.cloudera.sqoop.lib.BlobRef;
import com.cloudera.sqoop.lib.ClobRef;
import com.cloudera.sqoop.lib.DelimiterSet;
import com.cloudera.sqoop.lib.FieldFormatter;
import com.cloudera.sqoop.lib.LargeObjectLoader;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.IntWritable;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.DefaultHCatRecord;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.InputJobInfo;
import org.apache.hive.hcatalog.mapreduce.StorerInfo;
import org.apache.sqoop.lib.SqoopRecord;

public class SqoopHCatImportHelper {
    public static final Log LOG = LogFactory.getLog((String)SqoopHCatImportHelper.class.getName());
    private static boolean debugHCatImportMapper = false;
    private InputJobInfo jobInfo;
    private HCatSchema hCatFullTableSchema;
    private int fieldCount;
    private boolean bigDecimalFormatString;
    private LargeObjectLoader lobLoader;
    private HCatSchema partitionSchema = null;
    private HCatSchema dataColsSchema = null;
    private String hiveDelimsReplacement;
    private boolean doHiveDelimsReplacement = false;
    private DelimiterSet hiveDelimiters;
    private String[] staticPartitionKeys;
    private int[] hCatFieldPositions;
    private int colCount;

    public SqoopHCatImportHelper(Configuration conf) throws IOException, InterruptedException {
        String inputJobInfoStr = conf.get("mapreduce.lib.hcat.job.info");
        this.jobInfo = (InputJobInfo)HCatUtil.deserialize((String)inputJobInfoStr);
        this.dataColsSchema = this.jobInfo.getTableInfo().getDataColumns();
        this.partitionSchema = this.jobInfo.getTableInfo().getPartitionColumns();
        StringBuilder storerInfoStr = new StringBuilder(1024);
        StorerInfo storerInfo = this.jobInfo.getTableInfo().getStorerInfo();
        storerInfoStr.append("HCatalog Storer Info : ").append("\n\tHandler = ").append(storerInfo.getStorageHandlerClass()).append("\n\tInput format class = ").append(storerInfo.getIfClass()).append("\n\tOutput format class = ").append(storerInfo.getOfClass()).append("\n\tSerde class = ").append(storerInfo.getSerdeClass());
        Properties storerProperties = storerInfo.getProperties();
        if (!storerProperties.isEmpty()) {
            storerInfoStr.append("\nStorer properties ");
            for (Map.Entry<Object, Object> entry : storerProperties.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                storerInfoStr.append("\n\t").append(key).append('=').append(val);
            }
        }
        storerInfoStr.append("\n");
        LOG.info((Object)storerInfoStr);
        this.hCatFullTableSchema = new HCatSchema(this.dataColsSchema.getFields());
        for (HCatFieldSchema hfs : this.partitionSchema.getFields()) {
            this.hCatFullTableSchema.append(hfs);
        }
        this.fieldCount = this.hCatFullTableSchema.size();
        this.lobLoader = new LargeObjectLoader(conf, new Path(this.jobInfo.getTableInfo().getTableLocation()));
        this.bigDecimalFormatString = conf.getBoolean("sqoop.bigdecimal.format.string", true);
        debugHCatImportMapper = conf.getBoolean("sqoop.hcat.debug.import.mapper", false);
        IntWritable[] delimChars = (IntWritable[])DefaultStringifier.loadArray((Configuration)conf, (String)"sqoop.hive.delims.to.replace", IntWritable.class);
        this.hiveDelimiters = new DelimiterSet((char)delimChars[0].get(), (char)delimChars[1].get(), (char)delimChars[2].get(), (char)delimChars[3].get(), delimChars[4].get() == 1);
        this.hiveDelimsReplacement = conf.get("sqoop.hive.delims.replacement");
        if (this.hiveDelimsReplacement == null) {
            this.hiveDelimsReplacement = "";
        }
        this.doHiveDelimsReplacement = Boolean.valueOf(conf.get("sqoop.hive.delims.replacement.enabled"));
        IntWritable[] fPos = (IntWritable[])DefaultStringifier.loadArray((Configuration)conf, (String)"sqoop.hcat.field.positions", IntWritable.class);
        this.hCatFieldPositions = new int[fPos.length];
        for (int i = 0; i < fPos.length; ++i) {
            this.hCatFieldPositions[i] = fPos[i].get();
        }
        LOG.debug((Object)("Hive delims replacement enabled : " + this.doHiveDelimsReplacement));
        LOG.debug((Object)("Hive Delimiters : " + this.hiveDelimiters.toString()));
        LOG.debug((Object)("Hive delimiters replacement : " + this.hiveDelimsReplacement));
        this.staticPartitionKeys = conf.getStrings("sqoop.hcat.partition.key");
        String partKeysString = this.staticPartitionKeys == null ? "" : Arrays.toString(this.staticPartitionKeys);
        LOG.debug((Object)("Static partition key used : " + partKeysString));
    }

    public HCatRecord convertToHCatRecord(SqoopRecord sqr) throws IOException, InterruptedException {
        try {
            sqr.loadLargeObjects(this.lobLoader);
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE);
        }
        if (this.colCount == -1) {
            this.colCount = sqr.getFieldMap().size();
        }
        Map<String, Object> fieldMap = sqr.getFieldMap();
        DefaultHCatRecord result = new DefaultHCatRecord(this.fieldCount);
        for (Map.Entry<String, Object> entry : fieldMap.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            String hfn = key.toLowerCase();
            boolean skip = false;
            if (this.staticPartitionKeys != null && this.staticPartitionKeys.length > 0) {
                for (int i = 0; i < this.staticPartitionKeys.length; ++i) {
                    if (!this.staticPartitionKeys[i].equals(hfn)) continue;
                    skip = true;
                    break;
                }
            }
            if (skip) continue;
            HCatFieldSchema hfs = this.hCatFullTableSchema.get(hfn);
            if (debugHCatImportMapper) {
                LOG.debug((Object)("SqoopRecordVal: field = " + key + " Val " + val + " of type " + (val == null ? null : val.getClass().getName()) + ", hcattype " + hfs.getTypeString()));
            }
            Object hCatVal = this.toHCat(val, hfs);
            result.set(hfn, this.hCatFullTableSchema, hCatVal);
        }
        return result;
    }

    private Object toHCat(Object val, HCatFieldSchema hfs) {
        HCatFieldSchema.Type hfsType = hfs.getType();
        if (val == null) {
            return null;
        }
        Object retVal = null;
        if (val instanceof Number) {
            retVal = this.convertNumberTypes(val, hfs);
        } else if (val instanceof Boolean) {
            retVal = this.convertBooleanTypes(val, hfs);
        } else if (val instanceof String) {
            retVal = this.convertStringTypes(val, hfs);
        } else if (val instanceof java.util.Date) {
            retVal = this.converDateTypes(val, hfs);
        } else if (val instanceof BytesWritable) {
            if (hfsType == HCatFieldSchema.Type.BINARY) {
                BytesWritable bw = (BytesWritable)val;
                retVal = bw.getBytes();
            }
        } else if (val instanceof BlobRef) {
            if (hfsType == HCatFieldSchema.Type.BINARY) {
                BlobRef br = (BlobRef)val;
                byte[] bytes = br.isExternal() ? br.toString().getBytes() : (byte[])br.getData();
                retVal = bytes;
            }
        } else if (val instanceof ClobRef) {
            retVal = this.convertClobType(val, hfs);
        } else {
            throw new UnsupportedOperationException("Objects of type " + val.getClass().getName() + " are not suported");
        }
        if (retVal == null) {
            LOG.error((Object)("Unable to convert [" + val + "]  of type " + val.getClass().getName() + " to HCatalog type " + hfs.getTypeString()));
        }
        return retVal;
    }

    private Object convertClobType(Object val, HCatFieldSchema hfs) {
        String s;
        HCatFieldSchema.Type hfsType = hfs.getType();
        ClobRef cr = (ClobRef)val;
        String string = s = cr.isExternal() ? cr.toString() : (String)cr.getData();
        if (hfsType == HCatFieldSchema.Type.STRING) {
            return s;
        }
        return null;
    }

    private Object converDateTypes(Object val, HCatFieldSchema hfs) {
        HCatFieldSchema.Type hfsType = hfs.getType();
        if (val instanceof Date) {
            Date d = (Date)val;
            if (hfsType == HCatFieldSchema.Type.BIGINT) {
                return d.getTime();
            }
            if (hfsType == HCatFieldSchema.Type.STRING) {
                return val.toString();
            }
        } else if (val instanceof Time) {
            Time t = (Time)val;
            if (hfsType == HCatFieldSchema.Type.BIGINT) {
                return ((Time)val).getTime();
            }
            if (hfsType == HCatFieldSchema.Type.STRING) {
                return val.toString();
            }
        } else if (val instanceof Timestamp) {
            Timestamp ts = (Timestamp)val;
            if (hfsType == HCatFieldSchema.Type.BIGINT) {
                return ts.getTime();
            }
            if (hfsType == HCatFieldSchema.Type.STRING) {
                return val.toString();
            }
        }
        return null;
    }

    private Object convertStringTypes(Object val, HCatFieldSchema hfs) {
        HCatFieldSchema.Type hfsType = hfs.getType();
        if (hfsType == HCatFieldSchema.Type.STRING) {
            String str = val.toString();
            if (this.doHiveDelimsReplacement) {
                str = FieldFormatter.hiveStringReplaceDelims(str, this.hiveDelimsReplacement, this.hiveDelimiters);
            }
            if (hfsType == HCatFieldSchema.Type.STRING) {
                return str;
            }
        }
        return null;
    }

    private Object convertBooleanTypes(Object val, HCatFieldSchema hfs) {
        HCatFieldSchema.Type hfsType = hfs.getType();
        Boolean b = (Boolean)val;
        if (hfsType == HCatFieldSchema.Type.BOOLEAN) {
            return b;
        }
        if (hfsType == HCatFieldSchema.Type.TINYINT) {
            return (byte)(b != false ? 1 : 0);
        }
        if (hfsType == HCatFieldSchema.Type.SMALLINT) {
            return (short)(b != false ? 1 : 0);
        }
        if (hfsType == HCatFieldSchema.Type.INT) {
            return b != false ? 1 : 0;
        }
        if (hfsType == HCatFieldSchema.Type.BIGINT) {
            return (long)(b != false ? 1 : 0);
        }
        if (hfsType == HCatFieldSchema.Type.FLOAT) {
            return Float.valueOf(b != false ? 1 : 0);
        }
        if (hfsType == HCatFieldSchema.Type.DOUBLE) {
            return (double)(b != false ? 1 : 0);
        }
        if (hfsType == HCatFieldSchema.Type.STRING) {
            return val.toString();
        }
        return null;
    }

    private Object convertNumberTypes(Object val, HCatFieldSchema hfs) {
        HCatFieldSchema.Type hfsType = hfs.getType();
        if (!(val instanceof Number)) {
            return null;
        }
        if (val instanceof BigDecimal && hfsType == HCatFieldSchema.Type.STRING) {
            BigDecimal bd = (BigDecimal)val;
            String bdStr = null;
            bdStr = this.bigDecimalFormatString ? bd.toPlainString() : bd.toString();
            return bdStr;
        }
        Number n = (Number)val;
        if (hfsType == HCatFieldSchema.Type.TINYINT) {
            return n.byteValue();
        }
        if (hfsType == HCatFieldSchema.Type.SMALLINT) {
            return n.shortValue();
        }
        if (hfsType == HCatFieldSchema.Type.INT) {
            return n.intValue();
        }
        if (hfsType == HCatFieldSchema.Type.BIGINT) {
            return n.longValue();
        }
        if (hfsType == HCatFieldSchema.Type.FLOAT) {
            return Float.valueOf(n.floatValue());
        }
        if (hfsType == HCatFieldSchema.Type.DOUBLE) {
            return n.doubleValue();
        }
        if (hfsType == HCatFieldSchema.Type.BOOLEAN) {
            return n.byteValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (hfsType == HCatFieldSchema.Type.STRING) {
            return n.toString();
        }
        return null;
    }

    public void cleanup() throws IOException {
        if (null != this.lobLoader) {
            this.lobLoader.close();
        }
    }
}

