/*
 * Decompiled with CFR 0.152.
 */
package prantl.ant.eclipse;

import java.io.IOException;
import java.io.Writer;

class XmlWriter {
    private Writer writer;
    private int nestedLevel = 0;
    private boolean insideDocument = false;
    private boolean containsText = false;

    XmlWriter(Writer writer) {
        this.writer = writer;
    }

    void appendAttribute(String name, String value) throws IOException {
        this.writer.write(32);
        this.writer.write(name);
        this.writer.write("=\"");
        this.writer.write(this.escapeAttributeValue(value));
        this.writer.write(34);
    }

    void close() throws IOException {
        this.writer.close();
    }

    void closeDegeneratedElement() throws IOException {
        this.writer.write(" />");
    }

    void closeElement(String name) throws IOException {
        --this.nestedLevel;
        if (!this.containsText) {
            this.writer.write(10);
            this.writeIndentation();
        } else {
            this.containsText = false;
        }
        this.writer.write("</");
        this.writer.write(name);
        this.writer.write(">");
    }

    void closeOpeningTag() throws IOException {
        this.writer.write(62);
        ++this.nestedLevel;
    }

    String escapeAttributeValue(String text) {
        if (text.indexOf(38) < 0 && text.indexOf(60) < 0 && text.indexOf(62) < 0 && text.indexOf(34) < 0 && text.indexOf(39) < 0) {
            return text;
        }
        int length = text.length();
        StringBuffer result = new StringBuffer(length);
        int i = 0;
        while (i != length) {
            char ch = text.charAt(i);
            switch (ch) {
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                case '\'': {
                    result.append("&apos;");
                    break;
                }
                default: {
                    result.append(ch);
                }
            }
            ++i;
        }
        return result.toString();
    }

    String escapeCharacterData(String text) {
        if (text.indexOf(38) < 0 && text.indexOf(60) < 0 && text.indexOf(62) < 0) {
            return text;
        }
        int length = text.length();
        StringBuffer result = new StringBuffer(length);
        int i = 0;
        while (i != length) {
            char ch = text.charAt(i);
            switch (ch) {
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                default: {
                    result.append(ch);
                }
            }
            ++i;
        }
        return result.toString();
    }

    void openElement(String name) throws IOException {
        this.openOpeningTag(name);
        this.closeOpeningTag();
    }

    void openOpeningTag(String name) throws IOException {
        if (this.insideDocument) {
            this.writer.write(10);
        } else {
            this.insideDocument = true;
        }
        this.writeIndentation();
        this.writer.write(60);
        this.writer.write(name);
    }

    private void writeIndentation() throws IOException {
        int i = 0;
        while (i != this.nestedLevel) {
            this.writer.write("  ");
            ++i;
        }
    }

    void writeText(String text) throws IOException {
        this.writer.write(this.escapeCharacterData(text));
        this.containsText = true;
    }

    void writeXmlDeclaration() throws IOException {
        this.writer.write("<?xml version=\"1.0\"?>");
        this.insideDocument = true;
    }

    void writeXmlDeclaration(String encoding) throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
        this.insideDocument = true;
    }

    void writeXmlDeclaration(boolean standalone, String encoding) throws IOException {
        this.writer.write("<?xml version=\"1.0\" standalone=\"" + (standalone ? "yes" : "no") + "\" encoding=\"" + encoding + "\"?>");
        this.insideDocument = true;
    }
}

