@echo off
rem
rem Copyright 2011 The Apache Software Foundation
rem
rem Licensed to the Apache Software Foundation (ASF) under one
rem or more contributor license agreements.  See the NOTICE file
rem distributed with this work for additional information
rem regarding copyright ownership.  The ASF licenses this file
rem to you under the Apache License, Version 2.0 (the
rem "License"); you may not use this file except in compliance
rem with the License.  You may obtain a copy of the License at
rem
rem     http://www.apache.org/licenses/LICENSE-2.0
rem
rem Unless required by applicable law or agreed to in writing, software
rem distributed under the License is distributed on an "AS IS" BASIS,
rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
rem See the License for the specific language governing permissions and
rem limitations under the License.
rem
rem Arguments are:
rem    path to the root of the build directory
rem    the version number
rem    the git hash of the current checkout. If empty, auto-detect.
rem
rem e.g., $ write-version-info.cmd ./build/ 1.0.0

set buildroot=%1
set version=%2
set specifiedgithash=%3

set outputdir=%buildroot%\src\com\cloudera\sqoop
set outputfile=%outputdir%\SqoopVersion.java

set newoutputdir=%buildroot%\src\org\apache\sqoop
set newoutputfile=%newoutputdir%\SqoopVersion.java

set signature=%specifiedgithash%
if "%signature%"=="" (
   FOR /F "tokens=*" %%X IN (
     '"git log -1 --pretty=format:%%H"'
   ) DO SET signature=%%X
)

set host=%COMPUTERNAME%
set compiledate=%date%-%time%

mkdir %outputdir%

(
  echo.// generated by src/scripts/write-version-info.cmd
  echo.package com.cloudera.sqoop;
  echo.
  echo./**
  echo. * @deprecated use org.apache.sqoop.SqoopVersion instead
  echo. * @see org.apache.sqoop.SqoopVersion
  echo. */
  echo.public final class SqoopVersion extends org.apache.sqoop.SqoopVersion {
  echo.  public SqoopVersion^(^) {
  echo.    super^(^);
  echo.  }
  echo.  public static final String VERSION =
  echo.    org.apache.sqoop.SqoopVersion.VERSION;
  echo.  public static final String GIT_HASH =
  echo.    org.apache.sqoop.SqoopVersion.GIT_HASH;
  echo.  public static final String COMPILE_USER =
  echo.    org.apache.sqoop.SqoopVersion.COMPILE_USER;
  echo.  public static final String COMPILE_DATE =
  echo.    org.apache.sqoop.SqoopVersion.COMPILE_DATE;
  echo.}
) > %outputfile%

mkdir %newoutputdir%

(
  echo.// generated by src/scripts/write-version-info.cmd
  echo.package org.apache.sqoop;
  echo.
  echo.public class SqoopVersion {
  echo.  public SqoopVersion^(^) {
  echo.  }
  echo.
  echo.  public static final String VERSION="%version%";
  echo.  public static final String GIT_HASH="%signature%";
  echo.  public static final String COMPILE_USER="%USER%";
  echo.  public static final String COMPILE_DATE="%compiledate%";
  echo.
  echo.  @Override
  echo.  public String toString^(^) {
  echo.    return "Sqoop " + VERSION + "\n"
  echo.        + "git commit id " + GIT_HASH + "\n"
  echo.        + "Compiled by " + COMPILE_USER
  echo.        + " on " + COMPILE_DATE + "\n";
  echo.  }
  echo.}
) > %newoutputfile%
