#include <gtest/gtest.h>
#include "UniFileStream.h"

namespace
{
	// The fixture for testing paths functions.
	class UniFileStreamTest : public testing::Test
	{
	protected:
		// You can remove any or all of the following functions if its body
		// is	empty.

		UniFileStreamTest()
		{
			// You can do set-up work for each test	here.
		}

		virtual ~UniFileStreamTest()
		{
			// You can do clean-up work	that doesn't throw exceptions here.
		}

		// If	the	constructor	and	destructor are not enough for setting up
		// and cleaning up each test, you can define the following methods:

		virtual void SetUp()
		{
			// Code	here will be called	immediately	after the constructor (right
			// before each test).
		}

		virtual void TearDown()
		{
			// Code	here will be called	immediately	after each test	(right
			// before the destructor).
		}

		// Objects declared here can be used by all tests in the test case for Foo.
	};

	TEST_F(UniFileStreamTest, Construct1)
	{
		String str;
		EXPECT_TRUE(str.empty());
	}

	TEST_F(UniFileStreamTest, ReplaceNotFound)
	{
		String orig(_T("OneTwoThree"));
		String find(_T("Blaa"));
		String rep(_T("Five"));
		string_replace(orig, find, rep);
		EXPECT_EQ(_T("OneTwoThree"), orig);
	}

	TEST_F(UniFileStreamTest, ReplaceMiddle1)
	{
		String orig(_T("OneTwoThree"));
		String find(_T("Two"));
		String rep(_T("Five"));
		string_replace(orig, find, rep);
		EXPECT_EQ(_T("OneFiveThree"), orig);
	}

	TEST_F(UniFileStreamTest, ReplaceMiddle2)
	{
		String orig(_T("OneTwoThree"));
		String find(_T("Two"));
		String rep(_T(""));
		string_replace(orig, find, rep);
		EXPECT_EQ(_T("OneThree"), orig);
	}

	TEST_F(UniFileStreamTest, ReplaceBegin1)
	{
		String orig(_T("OneTwoThree"));
		String find(_T("One"));
		String rep(_T("five"));
		string_replace(orig, find, rep);
		EXPECT_EQ(_T("fiveTwoThree"), orig);
	}

	TEST_F(UniFileStreamTest, ReplaceBegin2)
	{
		String orig(_T("OneTwoThree"));
		String find(_T("One"));
		String rep(_T(""));
		string_replace(orig, find, rep);
		EXPECT_EQ(_T("TwoThree"), orig);
	}

	TEST_F(UniFileStreamTest, ReplaceEnd1)
	{
		String orig(_T("OneTwoThree"));
		String find(_T("Three"));
		String rep(_T("seven"));
		string_replace(orig, find, rep);
		EXPECT_EQ(_T("OneTwoseven"), orig);
	}

	TEST_F(UniFileStreamTest, ReplaceEnd2)
	{
		String orig(_T("OneTwoThree"));
		String find(_T("Three"));
		String rep(_T(""));
		string_replace(orig, find, rep);
		EXPECT_EQ(_T("OneTwo"), orig);
	}

	TEST_F(UniFileStreamTest, MakelowerEmpty)
	{
		String orig(_T(""));
		String result = string_makelower(orig);
		EXPECT_EQ(_T(""), result);
	}

	TEST_F(UniFileStreamTest, MakelowerWhitespace)
	{
		String orig(_T(" \t"));
		String result = string_makelower(orig);
		EXPECT_EQ(_T(" \t"), result);
	}

	TEST_F(UniFileStreamTest, Makelower1)
	{
		String orig(_T("onetwothree"));
		String result = string_makelower(orig);
		EXPECT_EQ(_T("onetwothree"), result);
	}

	TEST_F(UniFileStreamTest, Makelower2)
	{
		String orig(_T("OneTwoThree"));
		String result = string_makelower(orig);
		EXPECT_EQ(_T("onetwothree"), result);
	}

	TEST_F(UniFileStreamTest, TrimwsbeginEmpty)
	{
		String orig(_T(""));
		String result = string_trim_ws_begin(orig);
		EXPECT_EQ(_T(""), result);
	}

	TEST_F(UniFileStreamTest, TrimwsbeginNoWs)
	{
		String orig(_T("abc"));
		String result = string_trim_ws_begin(orig);
		EXPECT_EQ(_T("abc"), result);
	}

	TEST_F(UniFileStreamTest, TrimwsbeginWsEnd)
	{
		String orig(_T("abc\t"));
		String result = string_trim_ws_begin(orig);
		EXPECT_EQ(_T("abc\t"), result);
	}

	TEST_F(UniFileStreamTest, TrimwsbeginWsOnly)
	{
		String orig(_T("\t"));
		String result = string_trim_ws_begin(orig);
		EXPECT_EQ(_T(""), result);
	}

	TEST_F(UniFileStreamTest, TrimwsbeginWs1)
	{
		String orig(_T("\tabc"));
		String result = string_trim_ws_begin(orig);
		EXPECT_EQ(_T("abc"), result);
	}
	
	TEST_F(UniFileStreamTest, TrimwsbeginWs2)
	{
		String orig(_T("\t\n abc"));
		String result = string_trim_ws_begin(orig);
		EXPECT_EQ(_T("abc"), result);
	}

	TEST_F(UniFileStreamTest, TrimwsendEmpty)
	{
		String orig(_T(""));
		String result = string_trim_ws_end(orig);
		EXPECT_EQ(_T(""), result);
	}

	TEST_F(UniFileStreamTest, TrimwsendNoWs)
	{
		String orig(_T("abc"));
		String result = string_trim_ws_end(orig);
		EXPECT_EQ(_T("abc"), result);
	}

	TEST_F(UniFileStreamTest, TrimwsendWsBegin)
	{
		String orig(_T("\tabc"));
		String result = string_trim_ws_end(orig);
		EXPECT_EQ(_T("\tabc"), result);
	}

	TEST_F(UniFileStreamTest, TrimwsendWsOnly)
	{
		String orig(_T("\t"));
		String result = string_trim_ws_end(orig);
		EXPECT_EQ(_T(""), result);
	}

	TEST_F(UniFileStreamTest, TrimwsendWs1)
	{
		String orig(_T("abc\t"));
		String result = string_trim_ws_end(orig);
		EXPECT_EQ(_T("abc"), result);
	}
	
	TEST_F(UniFileStreamTest, TrimwsendWs2)
	{
		String orig(_T("abc\t\n "));
		String result = string_trim_ws_end(orig);
		EXPECT_EQ(_T("abc"), result);
	}

	TEST_F(UniFileStreamTest, TrimwsEmpty)
	{
		String orig(_T(""));
		String result = string_trim_ws(orig);
		EXPECT_EQ(_T(""), result);
	}

	TEST_F(UniFileStreamTest, TrimwsNoWs)
	{
		String orig(_T("abc"));
		String result = string_trim_ws(orig);
		EXPECT_EQ(_T("abc"), result);
	}

	TEST_F(UniFileStreamTest, TrimwsWsOnly)
	{
		String orig(_T("\t"));
		String result = string_trim_ws(orig);
		EXPECT_EQ(_T(""), result);
	}

	TEST_F(UniFileStreamTest, TrimwsWsOnly2)
	{
		String orig(_T("\t \n"));
		String result = string_trim_ws(orig);
		EXPECT_EQ(_T(""), result);
	}

	TEST_F(UniFileStreamTest, TrimwsWsOnly3)
	{
		String orig(_T(" \t  \t "));
		String result = string_trim_ws(orig);
		EXPECT_EQ(_T(""), result);
	}

	TEST_F(UniFileStreamTest, TrimwsWsBegin)
	{
		String orig(_T("\tabc"));
		String result = string_trim_ws(orig);
		EXPECT_EQ(_T("abc"), result);
	}

	TEST_F(UniFileStreamTest, TrimwsWsBegin2)
	{
		String orig(_T("\t\n abc"));
		String result = string_trim_ws(orig);
		EXPECT_EQ(_T("abc"), result);
	}

	TEST_F(UniFileStreamTest, TrimwsWsEnd1)
	{
		String orig(_T("abc\t"));
		String result = string_trim_ws(orig);
		EXPECT_EQ(_T("abc"), result);
	}
	
	TEST_F(UniFileStreamTest, TrimwsWsEnd2)
	{
		String orig(_T("abc\t\n "));
		String result = string_trim_ws(orig);
		EXPECT_EQ(_T("abc"), result);
	}

	TEST_F(UniFileStreamTest, TrimwsWsBoth1)
	{
		String orig(_T("\tabc\t"));
		String result = string_trim_ws(orig);
		EXPECT_EQ(_T("abc"), result);
	}

	TEST_F(UniFileStreamTest, TrimwsWsBoth2)
	{
		String orig(_T("\n \tabc \t\n"));
		String result = string_trim_ws(orig);
		EXPECT_EQ(_T("abc"), result);
	}

	TEST_F(UniFileStreamTest, ComparenocaseEmpty)
	{
		EXPECT_EQ(0, string_compare_nocase(_T(""), _T("")));
	}

	TEST_F(UniFileStreamTest, ComparenocaseWhitespace1)
	{
		EXPECT_EQ(0, string_compare_nocase(_T(" "), _T(" ")));
	}

	TEST_F(UniFileStreamTest, ComparenocaseWhitespace)
	{
		EXPECT_NE(0, string_compare_nocase(_T(" "), _T("\t")));
	}

	TEST_F(UniFileStreamTest, ComparenocaseLowercase)
	{
		EXPECT_EQ(0, string_compare_nocase(_T("abc"), _T("abc")));
	}

	TEST_F(UniFileStreamTest, ComparenocaseUppercase)
	{
		EXPECT_EQ(0, string_compare_nocase(_T("ABC"), _T("ABC")));
	}

	TEST_F(UniFileStreamTest, ComparenocaseMixedcase)
	{
		EXPECT_EQ(0, string_compare_nocase(_T("AbC"), _T("AbC")));
	}

	TEST_F(UniFileStreamTest, ComparenocaseIdentical1)
	{
		EXPECT_EQ(0, string_compare_nocase(_T("abc"), _T("aBc")));
	}

	TEST_F(UniFileStreamTest, ComparenocaseIdentical2)
	{
		EXPECT_EQ(0, string_compare_nocase(_T("ABc"), _T("abc")));
	}

	TEST_F(UniFileStreamTest, ComparenocaseDifferent1)
	{
		EXPECT_NE(0, string_compare_nocase(_T("abc"), _T("adc")));
	}

	TEST_F(UniFileStreamTest, ComparenocaseDifferent2)
	{
		EXPECT_NE(0, string_compare_nocase(_T("aBc"), _T("adc")));
	}

	TEST_F(UniFileStreamTest, ComparenocaseDifferent3)
	{
		EXPECT_NE(0, string_compare_nocase(_T("abc"), _T("aDc")));
	}

}  // namespace
