﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace com.ast8.fw.forms
{
    /// <summary>
    /// Windows GDI 用 static クラス
    /// </summary>
    public static class GDIMagician
    {
        // 魔法使いは1%の努力と99%の発汗である..
        public const uint DT_TOP = 0x00000000;
        public const uint DT_LEFT = 0x00000000;
        public const uint DT_CENTER = 0x00000001;
        public const uint DT_RIGHT = 0x00000002;
        public const uint DT_VCENTER = 0x00000004;
        public const uint DT_BOTTOM = 0x00000008;
        public const uint DT_WORDBREAK = 0x00000010;
        public const uint DT_SINGLELINE = 0x00000020;
        public const uint DT_EXPANDTABS = 0x00000040;
        public const uint DT_TABSTOP = 0x00000080;
        public const uint DT_NOCLIP = 0x00000100;
        public const uint DT_EXTERNALLEADING = 0x00000200;
        public const uint DT_CALCRECT = 0x00000400;
        public const uint DT_NOPREFIX = 0x00000800;
        public const uint DT_INTERNAL = 0x00001000;
        public const uint DT_EDITCONTROL = 0x00002000;
        public const uint DT_PATH_ELLIPSIS = 0x00004000;
        public const uint DT_END_ELLIPSIS = 0x00008000;
        public const uint DT_MODIFYSTRING = 0x00010000;
        public const uint DT_RTLREADING = 0x00020000;
        public const uint DT_WORD_ELLIPSIS = 0x00040000;

        public const uint WitchDTFlag = DT_NOCLIP | DT_NOPREFIX;

        /* Logical Font */
        public const int LF_FACESIZE = 32;
        ///*
        [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
        public struct LOGFONT
        {
            public int lfHeight;
            public int lfWidth;
            public int lfEscapement;
            public int lfOrientation;
            public int lfWeight;
            public byte lfItalic;
            public byte lfUnderline;
            public byte lfStrikeOut;
            public byte lfCharSet;
            public byte lfOutPrecision;
            public byte lfClipPrecision;
            public byte lfQuality;
            public byte lfPitchAndFamily;
            /*
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = LF_FACESIZE)]
            public string lfFaceName;
            */
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = LF_FACESIZE * 2)]
            public byte[] lfFaceName;
        }
        //*/
        /*
        [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
        public class LOGFONT
        {
            public uint lfHeight;
            public uint lfWidth;
            public uint lfEscapement;
            public uint lfOrientation;
            public uint lfWeight;
            public byte lfItalic;
            public byte lfUnderline;
            public byte lfStrikeOut;
            public byte lfCharSet;
            public byte lfOutPrecision;
            public byte lfClipPrecision;
            public byte lfQuality;
            public byte lfPitchAndFamily;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = LF_FACESIZE)]
            public string lfFaceName;
        }
        */

        [StructLayout(LayoutKind.Sequential)]
        public struct RECT
        {
            public int Left;
            public int Top;
            public int Right;
            public int Bottom;
            public RECT(int left, int top, int right, int bottom)
            {
                this.Left = left;
                this.Top = top;
                this.Right = right;
                this.Bottom = bottom;
            }
            public void setPosition(int left, int top)
            {
                this.Left = left;
                this.Top = top;
            }
            public void setPosition(System.Drawing.Point point)
            {
                this.Left = point.X;
                this.Top = point.Y;
            }
        }
        [DllImport("user32.dll")]
        public static extern int DrawText(IntPtr hDC, string lpString, int nCount, ref RECT lpRect, uint uFormat);
        [DllImport("gdi32.dll")]
        public static extern bool TextOut(IntPtr hDC, int nXStart, int nYStart, string lpString, int cbString);
        [DllImport("gdi32.dll")]
        //public static extern bool TextOutW(IntPtr hDC, int nXStart, int nYStart, byte[] lpString, int cbString);
        public static extern bool TextOutW(IntPtr hDC, int nXStart, int nYStart, byte[] lpString, int cbString);
        [DllImport("gdi32.dll")]
        public static extern IntPtr SelectObject(IntPtr hDC, IntPtr hGDIOBJ);
        [DllImport("gdi32.dll")]
        public static extern IntPtr CreateFontIndirect(ref LOGFONT lplf);
        [DllImport("gdi32.dll")]
        public static extern int GetObject(IntPtr hgdiobj, int cbBuffer, out LOGFONT lpvObject);
        [DllImport("gdi32.dll")]
        public static extern bool DeleteObject(IntPtr hGDIOBJ);
        [DllImport("gdi32.dll")]
        public static extern IntPtr CreateCompatibleDC(IntPtr hDC);
        [DllImport("gdi32.dll")]
        public static extern IntPtr DeleteDC(IntPtr hDC);
    }
}
