﻿using System;
using System.Collections.Generic;
using System.Text;

namespace com.ast8.fw.forms
{
    public static class IMEMagician
    {
        #region IME API 関連
        // めんどくさすぎです
        public const int CFS_DEFAULT = 0x0000;
        public const int CFS_RECT = 0x0001;
        public const int CFS_POINT = 0x0002;
        public const int CFS_FORCE_POSITION = 0x0020;
        public const int CFS_CANDIDATEPOS = 0x0040;
        public const int CFS_EXCLUDE = 0x0080;

        /// <summary>詳細不明</summary>
        public const int WM_IME_SETCONTEXT = 0x0281;
        /// <summary>IME初期化時に送られてくる？</summary>
        public const int WM_IME_NOTIFY                  = 0x0282;
        /// <summary>詳細不明</summary>
        public const int WM_IME_CONTROL = 0x0283;
        /// <summary>詳細不明</summary>
        public const int WM_IME_COMPOSITIONFULL = 0x0284;
        /// <summary>詳細不明</summary>
        public const int WM_IME_SELECT = 0x0285;
        /// <summary>IMEを通して入力されたキャラクタ送信メッセージ</summary>
        public const int WM_IME_CHAR                    = 0x0286;

        /// <summary>詳細不明</summary>
        public const int WM_IME_REQUEST = 0x0288;
        /// <summary>詳細不明</summary>
        public const int WM_IME_KEYDOWN = 0x0290;
        /// <summary>詳細不明</summary>
        public const int WM_IME_KEYUP = 0x0291;

        /// <summary>WM_IME_STARTCOMPOSITION->WM_IME_CHAR->WM_IME_CHAR->WM_IME_CHAR...->WM_IME_ENDCOMPOSITION</summary>
        public const int WM_IME_STARTCOMPOSITION        = 0x010D;
        /// <summary>WM_IME_STARTCOMPOSITION->WM_IME_CHAR->WM_IME_CHAR->WM_IME_CHAR...->WM_IME_ENDCOMPOSITION</summary>
        public const int WM_IME_ENDCOMPOSITION = 0x010E;
        /// <summary>詳細不明</summary>
        public const int WM_IME_COMPOSITION = 0x010F;
        /// <summary>詳細不明</summary>
        public const int WM_IME_KEYLAST                 = 0x010F;

        #region Imm系メソッド
        // LPVOID → StringBuilder?
        [System.Runtime.InteropServices.DllImport("imm32.dll")]
        public static extern int ImmReleaseContext(IntPtr hWnd, IntPtr hIMC);
        [System.Runtime.InteropServices.DllImport("imm32.dll")]
        public static extern IntPtr ImmGetContext(IntPtr hWnd);
        [System.Runtime.InteropServices.DllImport("imm32.dll")]
        public static extern IntPtr ImmCreateContext();
        [System.Runtime.InteropServices.DllImport("imm32.dll")]
        public static extern int ImmDestroyContext(IntPtr hIMC);
        [System.Runtime.InteropServices.DllImport("imm32.dll")]
        public static extern int ImmGetCompositionString(IntPtr hIMC, uint dwIndex, StringBuilder lpBuf, uint dwBufLen);
        [System.Runtime.InteropServices.DllImport("imm32.dll")]
        public static extern int ImmGetCompositionFont(IntPtr hIMC, ref GDIMagician.LOGFONT lplf);
        [System.Runtime.InteropServices.DllImport("imm32.dll")]
        public static extern int ImmSetCompositionString(IntPtr hIMC, uint dwIndex, string lpComp, uint dwCompLen, string lpRead, uint dwReadLen);
        [System.Runtime.InteropServices.DllImport("imm32.dll")]
        public static extern int ImmSetCompositionFont(IntPtr hIMC, ref GDIMagician.LOGFONT lplf);
        [System.Runtime.InteropServices.DllImport("imm32.dll")]
        public static extern bool ImmSetCompositionWindow(IntPtr hIMC, ref COMPOSITIONFORM lpCompForm);
        #endregion

        [System.Runtime.InteropServices.StructLayout(System.Runtime.InteropServices.LayoutKind.Sequential)]
        public struct POINTAPI
        {
            public int x;
            public int y;
        }

        [System.Runtime.InteropServices.StructLayout(System.Runtime.InteropServices.LayoutKind.Sequential)]
        public struct COMPOSITIONFORM
        {
            public uint dwStyle;
            public POINTAPI ptCurrentPos;
            public GDIMagician.RECT rcArea;
        }
        #endregion
    }
}
