﻿using System;
using System.Collections.Generic;
using System.Text;

namespace com.ast8.fw.forms
{
    /// <summary>
    /// WitchPaperで提供されるデフォルトのカスタムクリップボード。
    /// </summary>
    /// <remarks>
    /// 特に履歴機能等を持たない<c>System.Windows.Forms.Clipboard</c>クラスのラッパです。
    /// </remarks>
    public class WitchClip : CustomClipboardIF
    {
        #region コンストラクタ
        /// <summary>
        /// デフォルトコンストラクタ。クラスの使用準備を整える
        /// </summary>
        public WitchClip()
        {
            // 何もせず
        }
        #endregion

        #region CustomClipboardIF メンバ
        /// <summary>
        /// クリップボードに格納されている文字列を返す
        /// </summary>
        /// <exception cref="System.Runtime.InteropServices.ExternalException">
        /// クリップボードのクリアに失敗した場合に送出される例外。
        /// 本例外は通常他のプロセスがクリップボードを占有している場合に発生する。
        /// </exception>
        /// <returns>クリップボードに格納されている文字列。格納されていない場合は<seealso cref="System.String.Empty"/>が返却される。</returns>
        public string GetText()
        {
            return System.Windows.Forms.Clipboard.GetText(System.Windows.Forms.TextDataFormat.UnicodeText);
        }

        /// <summary>
        /// クリップボードに指定した文字列を格納する
        /// </summary>
        /// <remarks>
        /// 引数<paramref name="value"/>がnullまたは<seealso cref="System.String.Empty"/>の場合、本メソッドは何もせずに処理を戻します。
        /// </remarks>
        /// <exception cref="System.Runtime.InteropServices.ExternalException">
        /// クリップボードのクリアに失敗した場合に送出される例外。
        /// 本例外は通常他のプロセスがクリップボードを占有している場合に発生する。
        /// </exception>
        /// <param name="value">クリップボードに格納する文字列</param>
        public void SetText(string value)
        {
            if (string.IsNullOrEmpty(value))
                return;
            System.Windows.Forms.Clipboard.SetText(value, System.Windows.Forms.TextDataFormat.UnicodeText);
        }
        #endregion
    }
}
