﻿using System;
using System.Drawing;
using System.Text;
using System.ComponentModel;

// partialってみました。TextBoxBase互換のみ記述予定
namespace com.ast8.fw.forms
{
    public partial class WitchPaper : MicrosoftSelectionAreaIF
    {
        #region MicrosoftSelectionAreaIF メンバ
        /// <summary>
        /// 物理座標からTextプロパティと整合性のある長さを返す
        /// </summary>
        /// <param name="x">物理X</param>
        /// <param name="y">物理Y</param>
        /// <returns>Textプロパティと整合性のある長さ</returns>
        private int getTextLength(int x, int y)
        {
            int length = 0;
            int prevY = -1;
            for (int i = 0; i < y; i++)
            {
                if (prevY != PhysicalAddressList[i].Y)
                {
                    length += Lines[PhysicalAddressList[i].Y].Length;
                    prevY = PhysicalAddressList[i].Y;
                }
            }
            if (prevY == PhysicalAddressList[y].Y)
                length -= Lines[PhysicalAddressList[y].Y].Length;
            length += PhysicalAddressList[y].X + x;
            return length;
        }

        /// <summary>
        /// 物理座標からTextプロパティと整合性のある長さを返す
        /// </summary>
        /// <param name="p">物理座標</param>
        /// <returns>Textプロパティと整合性のある長さ</returns>
        private int getTextLength(Point p)
        {
            return getTextLength(p.X, p.Y);
        }

        /// <summary>
        /// Textプロパティと整合性のある文字インデックスから物理アドレスを返す
        /// </summary>
        /// <param name="textIndex">Textプロパティと整合性のある長さ</param>
        /// <returns>該当する物理アドレス</returns>
        private Point getPhysicalPoint(int textIndex)
        {
            int index = 0;
            for (int i = 0; i < Lines.Count; i++)
            {
                index += Lines[i].Length;
                if (index > textIndex)
                {
                    int physicalX = textIndex - (index - Lines[i].Length);
                    // この論理行
                    for (int j = i; j < PhysicalAddressList.Count; j++)
                    {
                        if (PhysicalAddressList[j].Y == i)
                        {
                            // この付近の物理行
                            if ((PhysicalAddressList[j].X + getPALLineLength(j)) >= physicalX)
                            {
                                // この物理行
                                return new Point(physicalX - PhysicalAddressList[j].X, j);
                            }
                        }
                    }
                    // ここまできたらX座標が不正
                    break;
                }
            }
            // 該当なし
            return GetLastXY();
        }

        /// <summary>
        /// テキスト ボックスで選択されている文字数を取得または設定します。
        /// </summary>
        /// <exception cref="System.ArgumentOutOfRangeException">割り当てられた値が 0 未満です。</exception>
        [DesignerSerializationVisibility(0)]
        [Browsable(false)]
        public int SelectionLength
        {
            get
            {
                int x, y;
                bool start = false;
                if (SelectionArea.StartX == -1)
                    return 0;
                if (SelectionArea.StartY > SelectionArea.EndY)
                {
                    start = true;
                }
                else if (SelectionArea.StartY == SelectionArea.EndY)
                {
                    if (SelectionArea.StartX > SelectionArea.EndX)
                        start = true;
                }
                if (start)
                {
                    x = SelectionArea.StartX;
                    y = SelectionArea.StartY;
                }
                else
                {
                    x = SelectionArea.EndX;
                    y = SelectionArea.EndY;
                }
                return getTextLength(x, y) - SelectionStart;
            }
            set
            {
                if (value < 0)
                    return;
                // セッター呼び出し
                SelectionStart = SelectionStart;
                // set
                Point p = getPhysicalPoint(SelectionStart + value);
                TextSelectionArea area = new TextSelectionArea();
                area.CurrentX = SelectionArea.CurrentX;
                area.CurrentY = SelectionArea.CurrentY;
                area.StartX = SelectionArea.StartX;
                area.StartY = SelectionArea.StartY;
                area.EndX = p.X;
                area.EndY = p.Y;
                // refresh
                SelectionArea = area;
                //ScrollToCaret();
                //this.Refresh();
            }
        }

        /// <summary>
        /// テキスト ボックスで選択されているテキストの開始点を取得または設定します。
        /// </summary>
        /// <exception cref="System.ArgumentOutOfRangeException">割り当てられた値が 0 未満です。</exception>
        [DesignerSerializationVisibility(0)]
        [Browsable(false)]
        public int SelectionStart
        {
            get
            {
                bool start = false;
                if (SelectionArea.StartX == -1)
                    return getTextLength(this.SelectionArea.CurrentX, this.SelectionArea.CurrentY);
                int x, y;
                if (SelectionArea.StartY > SelectionArea.EndY)
                {
                    start = true;
                }
                else if (SelectionArea.StartY == SelectionArea.EndY)
                {
                    if (SelectionArea.StartX > SelectionArea.EndX)
                        start = true;
                }
                if (start)
                {
                    x = SelectionArea.EndX;
                    y = SelectionArea.EndY;
                }
                else
                {
                    x = SelectionArea.StartX;
                    y = SelectionArea.StartY;
                }
                return getTextLength(x, y);
            }
            set
            {
                if (value < 0)
                    return;
                SelectMode = SelectMode.Normal;
                TextSelectionArea area = new TextSelectionArea();
                Point p = getPhysicalPoint(value);
                area.CurrentX = p.X;
                area.CurrentY = p.Y;
                area.StartX = p.X;
                area.StartY = p.Y;
                Point p2 = getPhysicalPoint(value + SelectionLength);
                area.EndX = p2.X;
                area.EndY = p2.Y;
                // refresh
                SelectionArea = area;
                //ScrollToCaret();
                //this.Refresh();
            }
        }

        /// <summary>
        /// コントロールで現在選択されているテキストを示す値を取得または設定します。
        /// </summary>
        [DesignerSerializationVisibility(0)]
        [Browsable(false)]
        public string SelectedText
        {
            get
            {
                if (SelectMode == SelectMode.Rectangle)
                {
                    // サポートせず
                    return "";
                }
                if (SelectionLength == 0)
                    return "";
                return this.Text.Substring(SelectionStart, SelectionLength);
            }
            set
            {
                // セッター呼び出し
                SelectionStart = SelectionStart;
                if (SelectMode == SelectMode.Rectangle)
                {
                    SelectMode = SelectMode.Normal; // Rectangleの指定は不可（現状）
                }
                Insert(value);
                //ScrollToCaret();
                //this.Refresh();
            }
        }

        /// <summary>
        /// テキスト ボックスでテキストの範囲を選択します。
        /// </summary>
        /// <param name="start">テキスト ボックス内で現在選択されているテキストの最初の文字の位置。</param>
            /// <param name="length">選択する文字数。</param>
        /// <exception cref="System.ArgumentOutOfRangeException:">start パラメータの値が 0 未満です。</exception>
        public void Select(int start, int length)
        {
            SelectionStart = start;
            SelectionLength = length;
        }

        /// <summary>
        /// テキスト ボックスのすべてのテキストを選択します。
        /// </summary>
        public void SelectAll()
        {
            Point p1 = this.GetFirstXY();
            Point p2 = this.GetLastXY();
            this.SelectMode = SelectMode.Normal;
            this.SelectionArea = new com.ast8.fw.forms.TextSelectionArea(
                p2.X, p2.Y,
                p1.X, p1.Y,
                p2.X, p2.Y
                );
            this.ScrollToCaret();
            this.Refresh();
        }

        /// <summary>
        /// <seealso cref="SelectionLength"/> プロパティの値を 0 にするよう指定して、コントロール内で文字が選択されないようにします。
        /// </summary>
        public void DeselectAll()
        {
            SelectionLength = 0;    // clearSelectAreaのがいいんだけどね
        }

        #endregion

        #region MicrosoftSelectionAreaIF 明示的実装
        /// <summary>
        /// テキスト ボックスの現在の選択項目をクリップボードに移動します。
        /// </summary>
        void MicrosoftSelectionAreaIF.Cut()
        {
            Clipboard.SetText(this.SelectedText);
            this.SelectedText = "";
        }

        /// <summary>
        /// テキスト ボックスの現在の選択項目をクリップボードにコピーします。
        /// </summary>
        void MicrosoftSelectionAreaIF.Copy()
        {
            Clipboard.SetText(this.SelectedText);
        }

        /// <summary>
        /// テキスト ボックスの現在の選択項目をクリップボードの内容と置き換えます。
        /// </summary>
        void MicrosoftSelectionAreaIF.Paste()
        {
            this.SelectedText = Clipboard.GetText();
        }

        #endregion
    }
}
