/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DataSetDataSourceSelectionPage
extends AbstractDescriptionPropertyPage
implements Listener {
    Combo combo;
    int lastSelectedDataSourceIndex = -1;

    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString((String)"dataset.editor.label.selectDataSource"));
        this.combo = new Combo(composite, 2056);
        this.combo.setLayoutData((Object)new GridData(768));
        this.combo.setItems(this.getSimilarDataSources());
        this.combo.setVisibleItemCount(30);
        this.selectCurrentDataSource();
        ((DataSetHandle)this.getContainer().getModel()).addListener((Listener)this);
        return composite;
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.dataSource"), 0);
        this.lastSelectedDataSourceIndex = this.combo.getSelectionIndex();
    }

    private void selectCurrentDataSource() {
        String current = this.getCurrentDataSource().getName();
        String[] items = this.combo.getItems();
        int n = 0;
        while (n < items.length) {
            if (items[n].equals(current)) {
                this.combo.select(n);
                break;
            }
            ++n;
        }
    }

    private DataSourceHandle getCurrentDataSource() {
        return ((DataSetHandle)this.getContainer().getModel()).getDataSource();
    }

    private String[] getSimilarDataSources() {
        DataSourceHandle currentDataSource = this.getCurrentDataSource();
        return this.getSimilarDataSources(currentDataSource);
    }

    private String[] getSimilarDataSources(DataSourceHandle currentDataSource) {
        ArrayList<String> similarDataSources = new ArrayList<String>();
        List dataSources = Utility.getDataSources();
        Class<?> clazz = currentDataSource.getClass();
        if (dataSources != null && !dataSources.isEmpty()) {
            for (DataSourceHandle dataSource : dataSources) {
                if (!dataSource.getClass().equals(clazz)) continue;
                if (clazz.equals(OdaDataSourceHandle.class)) {
                    if (!((OdaDataSourceHandle)dataSource).getExtensionID().equals(((OdaDataSourceHandle)currentDataSource).getExtensionID())) continue;
                    similarDataSources.add(dataSource.getName());
                    continue;
                }
                similarDataSources.add(dataSource.getName());
            }
        }
        return similarDataSources.toArray(new String[0]);
    }

    public boolean canLeave() {
        try {
            if (this.combo != null && !this.combo.isDisposed() && this.lastSelectedDataSourceIndex != this.combo.getSelectionIndex()) {
                DataSetHandle datasetHandle = (DataSetHandle)this.getContainer().getModel();
                datasetHandle.setDataSource(this.combo.getItem(this.combo.getSelectionIndex()));
                ((DataSetEditor)this.getContainer()).updateDataSetDesign((IPropertyPage)this);
                if (datasetHandle instanceof OdaDataSetHandle && datasetHandle.getProperty("resultSet") != null) {
                    datasetHandle.clearProperty("resultSet");
                }
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        return super.canLeave();
    }

    public boolean performOk() {
        try {
            if (this.combo != null && !this.combo.isDisposed() && this.combo.getSelectionIndex() > -1) {
                if (this.lastSelectedDataSourceIndex != this.combo.getSelectionIndex()) {
                    DataSetHandle datasetHandle = (DataSetHandle)this.getContainer().getModel();
                    datasetHandle.setDataSource(this.combo.getItem(this.combo.getSelectionIndex()));
                    ((DataSetEditor)this.getContainer()).updateDataSetDesign((IPropertyPage)this);
                    if (datasetHandle instanceof OdaDataSetHandle && datasetHandle.getProperty("resultSet") != null) {
                        datasetHandle.clearProperty("resultSet");
                    }
                }
                ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        return super.performOk();
    }

    public boolean performCancel() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return true;
    }

    public String getToolTip() {
        return Messages.getString((String)"dataset.editor.dataSource.Tooltip");
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
    }
}

