/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.ViewerColumnsDialog;
import org.eclipse.ui.views.markers.MarkerField;

public class MarkersViewColumnsDialog
extends ViewerColumnsDialog {
    private ExtendedMarkersView extendedView;

    public MarkersViewColumnsDialog(ExtendedMarkersView view) {
        super(view.getSite().getShell());
        this.extendedView = view;
        this.initialize(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(JFaceResources.getString((String)"ConfigureColumnsDialog_Title"));
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        return control;
    }

    protected void okPressed() {
        this.extendedView.setVisibleFields(this.getVisibleFields(), this.getNewWidths());
        super.okPressed();
    }

    private int[] getNewWidths() {
        List visible = this.getVisible();
        int[] widths = new int[visible.size()];
        int i = 0;
        Iterator iterator = visible.iterator();
        while (iterator.hasNext()) {
            widths[i] = ((FieldEntry)iterator.next()).width;
            ++i;
        }
        return widths;
    }

    private Collection getVisibleFields() {
        List visible = this.getVisible();
        ArrayList<MarkerField> list = new ArrayList<MarkerField>(visible.size());
        Iterator iterator = visible.iterator();
        while (iterator.hasNext()) {
            list.add(((FieldEntry)iterator.next()).field);
        }
        return list;
    }

    protected void performDefaults() {
        this.initialize(true);
        super.performDefaults();
    }

    void initialize(boolean defaultWidths) {
        MarkerField[] allFields = this.extendedView.getBuilder().getGenerator().getAllFields();
        MarkerField[] visibleFields = null;
        visibleFields = defaultWidths ? this.extendedView.getBuilder().getGenerator().getInitialVisible() : this.extendedView.getBuilder().getGenerator().getVisibleFields();
        List visible = this.getVisible();
        List nonVisible = this.getNonVisible();
        visible.clear();
        nonVisible.clear();
        FieldEntry entry = null;
        int i = 0;
        while (i < allFields.length) {
            if (!this.contains(visibleFields, allFields[i])) {
                entry = new FieldEntry(allFields[i], -1);
                entry.width = this.extendedView.getFieldWidth(entry.field, defaultWidths ? 0 : -1, !defaultWidths);
                entry.visible = false;
                nonVisible.add(entry);
            }
            ++i;
        }
        i = 0;
        while (i < visibleFields.length) {
            entry = new FieldEntry(visibleFields[i], -1);
            entry.width = this.extendedView.getFieldWidth(entry.field, defaultWidths ? 0 : -1, !defaultWidths);
            entry.visible = true;
            visible.add(entry);
            ++i;
        }
    }

    private boolean contains(MarkerField[] visibleFields, MarkerField field) {
        int i = 0;
        while (i < visibleFields.length) {
            if (visibleFields[i].equals(field)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected ITableLabelProvider getLabelProvider() {
        return new ViewerColumnsDialog.TableLabelProvider(this){

            public String getText(Object element) {
                return ((FieldEntry)element).field.getName();
            }
        };
    }

    protected ViewerColumnsDialog.IColumnInfoProvider getColumnInfoProvider() {
        return new ViewerColumnsDialog.IColumnInfoProvider(){

            public int getColumnIndex(Object columnObj) {
                return MarkersViewColumnsDialog.this.getVisible().indexOf(columnObj);
            }

            public int getColumnWidth(Object columnObj) {
                FieldEntry field = (FieldEntry)columnObj;
                if (field.width <= 0) {
                    field.width = MarkersViewColumnsDialog.this.extendedView.getFieldWidth(field.field, field.width, false);
                }
                return field.width;
            }

            public boolean isColumnVisible(Object columnObj) {
                return ((FieldEntry)columnObj).visible;
            }

            public boolean isColumnMovable(Object columnObj) {
                return true;
            }

            public boolean isColumnResizable(Object columnObj) {
                return true;
            }
        };
    }

    protected ViewerColumnsDialog.IColumnUpdater getColumnUpdater() {
        return new ViewerColumnsDialog.IColumnUpdater(){

            public void setColumnVisible(Object columnObj, boolean visible) {
                ((FieldEntry)columnObj).visible = visible;
            }

            public void setColumnMovable(Object columnObj, boolean movable) {
            }

            public void setColumnIndex(Object columnObj, int index) {
            }

            public void setColumnResizable(Object columnObj, boolean resizable) {
            }

            public void setColumnWidth(Object columnObj, int newWidth) {
                ((FieldEntry)columnObj).width = newWidth;
            }
        };
    }

    static class FieldEntry {
        final MarkerField field;
        int width;
        boolean visible;

        FieldEntry(MarkerField field, int width) {
            this.field = field;
            this.width = width;
            this.visible = false;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldEntry other = (FieldEntry)obj;
            return !(this.field == null ? other.field != null : !this.field.equals(other.field));
        }
    }
}

