/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.sql.yaml.bean;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sql.yaml.bean.Expect;
import hiro.yoshioka.sql.yaml.bean.ResultExpect;
import hiro.yoshioka.util.StringUtil;

public class Case {
    public String title = "";
    public int repeatCount;
    public boolean withExplainPlan;
    public String sql_statement = "";
    public ResultExpect[] result_expects = new ResultExpect[]{new ResultExpect()};

    public String validate(ResultSetDataHolder rdh) {
        if (this.hasResultExpect()) {
            StringBuilder buf = new StringBuilder();
            ResultExpect[] resultExpectArray = this.result_expects;
            int n = this.result_expects.length;
            int n2 = 0;
            while (n2 < n) {
                ResultExpect expect = resultExpectArray[n2];
                String result = expect.validate(rdh);
                if (result != null) {
                    buf.append(result).append(StringUtil.LINE_SEPARATOR);
                }
                ++n2;
            }
            if (buf.length() == 0) {
                return null;
            }
            return buf.toString();
        }
        return null;
    }

    public boolean hasResultExpect() {
        if (this.result_expects == null || this.result_expects.length == 0) {
            return false;
        }
        ResultExpect[] resultExpectArray = this.result_expects;
        int n = this.result_expects.length;
        int n2 = 0;
        while (n2 < n) {
            ResultExpect expect = resultExpectArray[n2];
            if (!expect.getResultSetValidatorType().isNone()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("title:%s  ", this.title));
        buf.append(String.format("repeatCount:%d  ", this.repeatCount));
        if (this.result_expects != null) {
            ResultExpect[] resultExpectArray = this.result_expects;
            int n = this.result_expects.length;
            int n2 = 0;
            while (n2 < n) {
                ResultExpect expect = resultExpectArray[n2];
                buf.append(String.format(" expect:%s  ", expect));
                ++n2;
            }
        }
        return buf.toString();
    }

    public String getTitle() {
        return this.title;
    }

    public String getSqlStatement() {
        return this.sql_statement;
    }

    public static String escQuot(String s) {
        if (StringUtil.isEmpty((Object)s)) {
            return s;
        }
        return s.replaceAll("\"", "\\\\\"");
    }

    public void dump(StringBuilder ret) {
        ret.append(String.format("  - title: \"%s\"%n", Case.escQuot(this.title)));
        ret.append(String.format("    repeatCount: %d%n", this.repeatCount));
        ret.append(String.format("    withExplainPlan: %b%n", this.withExplainPlan));
        ret.append(String.format("    sql_statement: |%n", new Object[0]));
        String[] lines = StringUtil.getLines((String)this.sql_statement);
        Object[] objectArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = objectArray[n2];
            ret.append(String.format("      %s %n", line));
            ++n2;
        }
        ret.append(String.format("       %n", new Object[0]));
        if (this.hasResultExpect()) {
            ret.append(String.format("    result_expects: %n", new Object[0]));
            objectArray = this.result_expects;
            n = this.result_expects.length;
            n2 = 0;
            while (n2 < n) {
                Object r = objectArray[n2];
                if (!((ResultExpect)r).getResultSetValidatorType().isNone()) {
                    ret.append(String.format("      - type: \"%s\"%n", ((ResultExpect)r).getResultSetValidatorType().name()));
                    ret.append(String.format("        numericFlg: %b%n", ((ResultExpect)r).numericFlg));
                    ret.append(String.format("        operator: \"%s\"%n", ((Expect)r).getOperatorType().getTypeString()));
                    ret.append(String.format("        rowcol: \"%s\"%n", ((ResultExpect)r).rowcol));
                    ret.append(String.format("        value: \"%s\"%n", ((ResultExpect)r).value));
                }
                ++n2;
            }
        }
    }

    public void clearResultExpect() {
        this.result_expects = new ResultExpect[0];
    }
}

