/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands;

import java.util.List;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.AbstractCrosstabCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class AddMultipleMeasureCommand
extends AbstractCrosstabCommand {
    private CrosstabCellAdapter handleAdpter;
    private List list;
    private Object after = null;
    int position = -1;
    private static final String NAME = Messages.getString("AddMeasureViewHandleCommand.TransName");

    public AddMultipleMeasureCommand(CrosstabCellAdapter handleAdpter, List list, Object after) {
        super(handleAdpter.getDesignElementHandle());
        this.handleAdpter = handleAdpter;
        this.list = list;
        this.after = after;
        this.setLabel(NAME);
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        this.transStart(NAME);
        try {
            int i = 0;
            while (i < this.list.size()) {
                Object obj = this.list.get(i);
                if (obj instanceof MeasureHandle) {
                    this.addMeasureHandle((MeasureHandle)obj);
                }
                if (obj instanceof MeasureGroupHandle) {
                    List children = ((MeasureGroupHandle)obj).getContents("measures");
                    int j = 0;
                    while (j < children.size()) {
                        Object temp = children.get(j);
                        if (temp instanceof MeasureHandle) {
                            this.addMeasureHandle((MeasureHandle)temp);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (SemanticException e) {
            this.rollBack();
            ExceptionUtil.handle((Throwable)e);
        }
        this.transEnd();
    }

    private void addMeasureHandle(MeasureHandle measureHandle) throws SemanticException {
        CrosstabReportItemHandle reportHandle = this.handleAdpter.getCrosstabCellHandle().getCrosstab();
        if (this.isContainMeasureHandle(measureHandle)) {
            return;
        }
        if (this.position == -1) {
            this.position = this.findPosition();
        }
        CrosstabAdaptUtil.addMeasureHandle(reportHandle, measureHandle, this.position);
        ++this.position;
    }

    private boolean isContainMeasureHandle(MeasureHandle measureHandle) {
        CrosstabReportItemHandle reportHandle = this.handleAdpter.getCrosstabCellHandle().getCrosstab();
        int count = reportHandle.getMeasureCount();
        int i = 0;
        while (i < count) {
            MeasureViewHandle temp = reportHandle.getMeasure(i);
            if (temp.getCubeMeasure() == measureHandle) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int findPosition() {
        int index;
        int base = CrosstabAdaptUtil.getMeasureViewHandle((ExtendedItemHandle)this.handleAdpter.getCrosstabCellHandle().getModelHandle()).getModelHandle().getIndex();
        if (this.after instanceof DesignElementHandle && (index = ((DesignElementHandle)this.after).getIndex()) == 0) {
            return base;
        }
        return base + 1;
    }
}

