/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model.schematic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;

public class GridHandleAdapter
extends TableHandleAdapter {
    public GridHandleAdapter(GridHandle grid, IModelAdapterHelper mark) {
        super((ReportItemHandle)grid, mark);
    }

    public List getChildren() {
        ArrayList children = new ArrayList();
        SlotHandle rows = this.getGridHandle().getRows();
        Iterator it = rows.iterator();
        while (it.hasNext()) {
            children.addAll(((RowHandle)it.next()).getCells().getContents());
        }
        this.removePhantomCells(children);
        return children;
    }

    public List getColumns() {
        return this.getGridHandle().getColumns().getContents();
    }

    private GridHandle getGridHandle() {
        return (GridHandle)this.getHandle();
    }

    protected void buildRowInfo() {
        this.insertRowInfo(this.getGridHandle().getRows(), "", "");
    }

    public boolean canMerge(List list) {
        return list != null && list.size() > 1;
    }

    public boolean hasSlotHandleRow(int id) {
        return false;
    }

    public String getDefinedHeight() {
        DimensionHandle handle = ((ReportItemHandle)this.getHandle()).getHeight();
        if (handle.getUnits() == null || handle.getUnits().length() == 0) {
            return null;
        }
        if ("%".equals(handle.getUnits())) {
            return null;
        }
        int px = (int)DEUtil.convertoToPixel(handle);
        if (DEUtil.isFixLayout(this.getHandle()) && px == 0 && handle.isSet()) {
            px = 1;
        }
        if (px <= 0) {
            return null;
        }
        return String.valueOf(px);
    }

    public boolean isSupportHeight() {
        return true;
    }
}

