/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.IDropAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

public class VariableDropAdapter
implements IDropAdapter {
    public static final String TRANS_NAME = Messages.getString((String)"VariableDropAdapter.TranasctionName");

    public int canDrop(Object transfer, Object target, int operation, DNDLocation location) {
        if (transfer instanceof VariableElementHandle && target instanceof EditPart) {
            EditPart editPart = (EditPart)target;
            editPart.getRoot().getModel();
            if (editPart.getModel() instanceof ReportDesignHandle || editPart.getModel() instanceof DesignElementHandle || editPart.getModel() instanceof SlotHandle) {
                if (editPart.getModel() instanceof SlotHandle) {
                    int slot_id = ((SlotHandle)editPart.getModel()).getSlotID();
                    if (slot_id == 0 || slot_id == 1) {
                        if (((SlotHandle)editPart.getModel()).getCount() > 0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (slot_id == 0) {
                        return 1;
                    }
                }
                if (this.getMasterPageHandle(editPart) != null || "report".equals(((VariableElementHandle)transfer).getType())) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    private Object getMasterPageHandle(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        if (editPart.getParent() != null && (editPart.getParent().getModel() instanceof MasterPageHandle || editPart.getParent().getModel() instanceof ModuleHandle)) {
            return editPart.getParent().getModel();
        }
        return this.getMasterPageHandle(editPart.getParent());
    }

    public boolean performDrop(Object transfer, Object target, int operation, DNDLocation location) {
        EditPart editPart = (EditPart)target;
        VariableElementHandle variable = (VariableElementHandle)transfer;
        DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(null);
        try {
            ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)dataHandle, (String)variable.getName());
            bindingColumn.setDataType("string");
            ExpressionUtility.setBindingColumnExpression(variable, bindingColumn, true);
            bindingColumn.setDisplayName(variable.getDisplayLabel());
            dataHandle.addColumnBinding(bindingColumn, false);
            dataHandle.setResultSetColumn(bindingColumn.getName());
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        CreateRequest request = new CreateRequest();
        request.getExtendedData().put("newObject", dataHandle);
        request.setLocation(location.getPoint());
        Command command = editPart.getCommand((Request)request);
        if (command != null && command.canExecute()) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(TRANS_NAME);
            editPart.getViewer().getEditDomain().getCommandStack().execute(command);
            stack.commit();
            return true;
        }
        return false;
    }
}

