/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseStylePreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.StylePreferenceStore;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractFieldEditor
extends FieldEditor {
    protected boolean isLoaded = false;
    private boolean isDirty = false;
    private String oldValue = "";
    private String propValue = "";
    private String displayValue = "";
    private String defaultUnit = "";
    private static boolean refresh = false;

    public String getDisplayValue() {
        return this.displayValue;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    public AbstractFieldEditor() {
    }

    public AbstractFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public void setDefaultUnit(String defaultUnit) {
        this.defaultUnit = defaultUnit;
    }

    public String getDefaultUnit() {
        return this.defaultUnit;
    }

    public void load() {
        if (this.getPreferenceStore() != null) {
            this.setPresentsDefaultValue(false);
            this.isLoaded = false;
            this.doLoad();
            this.isLoaded = true;
            this.refreshValidState();
        }
    }

    public void loadDefault() {
        if (this.getPreferenceStore() != null) {
            this.setPresentsDefaultValue(true);
            this.doLoadDefault();
            this.refreshValidState();
        }
    }

    protected void doStore() {
        if (this.isDirty()) {
            if (this.propValue != null && this.propValue.length() > 0) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), this.propValue);
            } else {
                this.getPreferenceStore().setValue(this.getPreferenceName(), null);
            }
        }
    }

    public void store() {
        if (this.getPreferenceStore() == null) {
            return;
        }
        this.doStore();
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getPropValue() {
        return this.propValue;
    }

    protected void setOldValue(String oldValue) {
        this.oldValue = oldValue;
        this.propValue = oldValue;
        this.displayValue = oldValue;
        this.markDirty(false);
    }

    protected void setPropValue(String newValue) {
        this.oldValue = this.displayValue;
        this.propValue = newValue;
        this.displayValue = newValue;
    }

    protected void setDefaultValue(String newValue) {
        this.oldValue = this.displayValue;
        this.propValue = null;
        this.displayValue = newValue;
    }

    protected abstract String getStringValue();

    protected void valueChanged(String name) {
        if (!this.isLoaded) {
            return;
        }
        String curValue = this.getPropValue();
        String newValue = this.getStringValue();
        this.setPresentsDefaultValue(false);
        if (curValue != null && !curValue.equals(newValue) || curValue == null && newValue != null) {
            this.fireValueChanged(name, curValue, newValue);
            this.setPropValue(newValue);
            this.markDirty(true);
        }
    }

    protected void markDirty(boolean value) {
        this.isDirty = value;
        if (this.getPage() instanceof BaseStylePreferencePage) {
            if (refresh) {
                return;
            }
            refresh = true;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if ((BaseStylePreferencePage)AbstractFieldEditor.this.getPage() == null) {
                        return;
                    }
                    if (((BaseStylePreferencePage)AbstractFieldEditor.this.getPage()).getBuilder() == null || ((BaseStylePreferencePage)AbstractFieldEditor.this.getPage()).getBuilder().getShell() == null || ((BaseStylePreferencePage)AbstractFieldEditor.this.getPage()).getBuilder().getShell().isDisposed()) {
                        return;
                    }
                    ((BaseStylePreferencePage)AbstractFieldEditor.this.getPage()).getBuilder().refreshPagesStatus();
                    refresh = false;
                }
            });
        }
    }

    protected boolean isDirty() {
        return this.isDirty;
    }

    public boolean hasLocaleValue() {
        if (this.propValue == null) {
            return false;
        }
        if (this.isDirty) {
            return true;
        }
        if (this.getPreferenceStore() instanceof StylePreferenceStore) {
            StylePreferenceStore store = (StylePreferenceStore)this.getPreferenceStore();
            return store.hasLocalValue(this.getPreferenceName());
        }
        return true;
    }
}

