/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;

public final class PropertyHandleTableViewer {
    private TableViewer viewer;
    private Composite mainControl;
    private Button btnRemove;
    private Button btnUp;
    private Button btnDown;
    private MenuItem itmRemove;
    private MenuItem itmRemoveAll;
    private Menu menu;
    protected Logger logger = Logger.getLogger(PropertyHandleTableViewer.class.getName());

    public PropertyHandleTableViewer(Composite parent, boolean showMenus, boolean showButtons, boolean enableKeyStrokes) {
        this.mainControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.mainControl.setLayout((Layout)layout);
        GridData data = null;
        this.viewer = new TableViewer(this.mainControl, 67584);
        data = new GridData(1808);
        this.viewer.getControl().setLayoutData((Object)data);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        if (showButtons) {
            Composite btnComposite = new Composite(this.mainControl, 0);
            data = new GridData();
            data.verticalAlignment = 0x1000000;
            btnComposite.setLayoutData((Object)data);
            GridLayout btnLayout = new GridLayout();
            layout.verticalSpacing = 20;
            btnComposite.setLayout((Layout)btnLayout);
            GridData btnData = new GridData(2);
            btnData.widthHint = 20;
            btnData.heightHint = 20;
            this.btnUp = new Button(btnComposite, 132);
            this.btnUp.setLayoutData((Object)btnData);
            this.btnUp.setToolTipText(Messages.getString((String)"PropertyHandleTableViewer.Menu.Up"));
            this.btnUp.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int index = PropertyHandleTableViewer.this.viewer.getTable().getSelectionIndex();
                    PropertyHandle handle = (PropertyHandle)PropertyHandleTableViewer.this.viewer.getInput();
                    if (index > 0 && handle.getListValue() != null && index < handle.getListValue().size()) {
                        PropertyHandleTableViewer.this.viewer.cancelEditing();
                        try {
                            handle.moveItem(index, index - 1);
                        }
                        catch (PropertyValueException e1) {
                            ExceptionHandler.handle(e1);
                        }
                        PropertyHandleTableViewer.this.viewer.refresh();
                        PropertyHandleTableViewer.this.viewer.getTable().select(index - 1);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            btnData = new GridData(2);
            btnData.widthHint = 20;
            btnData.heightHint = 20;
            this.btnRemove = new Button(btnComposite, 8);
            this.btnRemove.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
            this.btnRemove.setLayoutData((Object)btnData);
            this.btnRemove.setToolTipText(Messages.getString((String)"PropertyHandleTableViewer.Menu.Remove"));
            this.btnRemove.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PropertyHandleTableViewer.this.removeSelectedItem();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            btnData = new GridData(2);
            btnData.widthHint = 20;
            btnData.heightHint = 20;
            this.btnDown = new Button(btnComposite, 1028);
            this.btnDown.setLayoutData((Object)btnData);
            this.btnDown.setToolTipText(Messages.getString((String)"PropertyHandleTableViewer.Menu.Down"));
            this.btnDown.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int index = PropertyHandleTableViewer.this.viewer.getTable().getSelectionIndex();
                    PropertyHandle handle = (PropertyHandle)PropertyHandleTableViewer.this.viewer.getInput();
                    if (index > -1 && handle.getListValue() != null && index < handle.getListValue().size() - 1) {
                        PropertyHandleTableViewer.this.viewer.cancelEditing();
                        try {
                            handle.moveItem(index, index + 1);
                        }
                        catch (PropertyValueException e1) {
                            ExceptionHandler.handle(e1);
                        }
                        PropertyHandleTableViewer.this.viewer.refresh();
                        PropertyHandleTableViewer.this.viewer.getTable().select(index + 1);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (showMenus) {
            this.menu = new Menu((Control)this.viewer.getTable());
            this.menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    PropertyHandleTableViewer.this.viewer.cancelEditing();
                }
            });
            this.itmRemove = new MenuItem(this.menu, 0);
            this.itmRemove.setText(Messages.getString((String)"PropertyHandleTableViewer.Menu.Remove"));
            this.itmRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PropertyHandleTableViewer.this.removeSelectedItem();
                }
            });
            this.itmRemoveAll = new MenuItem(this.menu, 0);
            this.itmRemoveAll.setText(Messages.getString((String)"PropertyHandleTableViewer.Menu.RemoveAll"));
            this.itmRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        PropertyHandle handle = (PropertyHandle)PropertyHandleTableViewer.this.viewer.getInput();
                        handle.clearValue();
                        PropertyHandleTableViewer.this.viewer.refresh();
                    }
                    catch (SemanticException e1) {
                        PropertyHandleTableViewer.this.logger.log(Level.SEVERE, e1.getMessage(), e1);
                    }
                }
            });
            this.viewer.getTable().setMenu(this.menu);
        }
        if (enableKeyStrokes) {
            this.viewer.getTable().addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 127) {
                        PropertyHandleTableViewer.this.removeSelectedItem();
                    }
                }
            });
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public Composite getControl() {
        return this.mainControl;
    }

    public Button getUpButton() {
        return this.btnUp;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public Button getDownButton() {
        return this.btnDown;
    }

    public Button getRemoveButton() {
        return this.btnRemove;
    }

    public MenuItem getRemoveMenuItem() {
        return this.itmRemove;
    }

    public MenuItem getRemoveAllMenuItem() {
        return this.itmRemoveAll;
    }

    private final void removeSelectedItem() {
        int count;
        int index = this.viewer.getTable().getSelectionIndex();
        PropertyHandle handle = (PropertyHandle)this.viewer.getInput();
        int n = count = handle.getListValue() == null ? 0 : handle.getListValue().size();
        if (index > -1 && index < count) {
            try {
                handle.removeItem(index);
            }
            catch (PropertyValueException e1) {
                ExceptionHandler.handle(e1);
            }
            this.viewer.refresh();
            this.viewer.getTable().select(index);
        }
    }
}

