/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.IContainer;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.TableSelectionGuideTracker;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Handle;

public class ColumnTracker
extends TableSelectionGuideTracker {
    IContainer container;

    public ColumnTracker(TableEditPart sourceEditPart, int column, IContainer container) {
        super(sourceEditPart, column);
        this.container = container;
    }

    public void select() {
        if (this.container.isSelect() && this.getCurrentInput().isMouseButtonDown(3)) {
            return;
        }
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        if (this.getCurrentInput().isShiftKeyDown()) {
            EditPart child;
            int columnNumber = this.getNumber();
            int number = part.getOriColumnNumber();
            List list = part.getViewer().getSelectedEditParts();
            if (list.size() == 0) {
                number = 1;
            }
            if (!((child = (EditPart)list.get(0)).getModel() instanceof ColumnHandle) || !((ColumnHandle)child.getModel()).getContainer().equals(part.getModel())) {
                number = 1;
            }
            this.selectColumns(number, columnNumber);
        } else {
            part.selectColumn(new int[]{this.getNumber()});
            part.setOriColumnNumber(this.getNumber());
        }
    }

    protected boolean handleButtonUp(int button) {
        boolean rlt = super.handleButtonUp(button);
        if (button == 1 && this.container != null && this.container.contains(this.getLocation())) {
            this.getSourceEditPart().getViewer().getContextMenu().getMenu().setVisible(true);
        }
        return rlt;
    }

    public boolean isDealwithDrag() {
        Handle handle = this.getHandleUnderMouse();
        if (handle instanceof org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.ColumnHandle) {
            return ((org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.ColumnHandle)handle).getOwner() == this.getSourceEditPart();
        }
        return false;
    }

    public void selectDrag() {
        org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.ColumnHandle handle = (org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.ColumnHandle)this.getHandleUnderMouse();
        int columnNumber = handle.getColumnNumber();
        int number = this.getNumber();
        this.selectColumns(number, columnNumber);
    }

    private void selectColumns(int number, int columnNumber) {
        int[] columns = new int[]{};
        int i = number;
        while (i <= number + Math.abs(number - columnNumber)) {
            int lenegth = columns.length;
            int[] temp = new int[lenegth + 1];
            System.arraycopy(columns, 0, temp, 0, lenegth);
            temp[lenegth] = number > columnNumber ? number - (i - number) : i;
            columns = temp;
            ++i;
        }
        if (columns.length > 0) {
            TableEditPart tableEditpart = (TableEditPart)this.getSourceEditPart();
            tableEditpart.selectColumn(columns);
        }
    }
}

