/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.script.JSObjectMetaData;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfoList;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;

public class ExtensionClassJSObject
implements JSObjectMetaData {
    private IClassInfo classInfo;
    private JSObjectMetaData.JSMethod[] cacheMethods;
    private JSObjectMetaData.JSField[] cacheFields;

    public ExtensionClassJSObject(IClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public String getName() {
        return this.classInfo.getName();
    }

    public JSObjectMetaData.JSMethod[] getMethods() {
        if (this.cacheMethods == null) {
            ArrayList<ExtensionClassMethod> jsMethods = new ArrayList<ExtensionClassMethod>();
            List methods = this.classInfo.getMethods();
            int i = 0;
            while (i < methods.size()) {
                jsMethods.add(new ExtensionClassMethod((IMethodInfo)methods.get(i)));
                ++i;
            }
            Collections.sort(jsMethods);
            this.cacheMethods = jsMethods.toArray(new JSObjectMetaData.JSMethod[jsMethods.size()]);
        }
        return this.cacheMethods;
    }

    public JSObjectMetaData.JSField[] getFields() {
        if (this.cacheFields == null) {
            ArrayList<ExtensionClassField> jsFields = new ArrayList<ExtensionClassField>();
            List members = this.classInfo.getMembers();
            int i = 0;
            while (i < members.size()) {
                jsFields.add(new ExtensionClassField((IMemberInfo)members.get(i)));
                ++i;
            }
            Collections.sort(jsFields);
            this.cacheFields = jsFields.toArray(new JSObjectMetaData.JSField[jsFields.size()]);
        }
        return this.cacheFields;
    }

    public String toString() {
        return this.classInfo.getName();
    }

    public String getDescription() {
        return null;
    }

    public int getVisibility() {
        return 0;
    }

    private Object getSimpleName(String name) {
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public JSObjectMetaData getComponentType() {
        return null;
    }

    private class ExtensionClassField
    implements JSObjectMetaData.JSField,
    Comparable {
        private JSObjectMetaData type;
        private String typeName;
        private IMemberInfo field;
        private String displayText;

        public ExtensionClassField(IMemberInfo field) {
            this.field = field;
            this.typeName = field.getDataType();
            IClassInfo typeInfo = field.getClassType();
            if (typeInfo != null) {
                this.type = new ExtensionClassJSObject(typeInfo);
            }
        }

        public String getName() {
            return this.field.getName();
        }

        public JSObjectMetaData getType() {
            return this.type;
        }

        public String getDisplayText() {
            if (this.displayText == null) {
                StringBuffer strbuf = new StringBuffer(this.getName());
                strbuf.append(" ");
                if (this.field != null && this.field.getDataType() != null) {
                    strbuf.append(ExtensionClassJSObject.this.getSimpleName(this.field.getDataType()));
                    strbuf.append(" - ");
                } else if (this.typeName != null) {
                    strbuf.append(ExtensionClassJSObject.this.getSimpleName(this.typeName));
                    strbuf.append(" - ");
                } else if (this.type != null) {
                    strbuf.append(ExtensionClassJSObject.this.getSimpleName(this.type.getName()));
                    strbuf.append(" - ");
                }
                strbuf.append(ExtensionClassJSObject.this.getSimpleName(ExtensionClassJSObject.this.classInfo.getName()));
                this.displayText = strbuf.toString();
                Object var1_1 = null;
            }
            return this.displayText;
        }

        public String getDescription() {
            return null;
        }

        public int getVisibility() {
            return 0;
        }

        public int compareTo(Object obj) {
            if (obj instanceof ExtensionClassField && ((ExtensionClassField)obj).getName() != null) {
                return this.getName().compareToIgnoreCase(((ExtensionClassField)obj).getName());
            }
            return 0;
        }
    }

    private class ExtensionClassMethod
    implements JSObjectMetaData.JSMethod,
    Comparable {
        private JSObjectMetaData returnType;
        private IMethodInfo method;
        private String displayText;

        public ExtensionClassMethod(IMethodInfo method) {
            this.method = method;
            IClassInfo typeInfo = method.getClassReturnType();
            if (typeInfo != null) {
                this.returnType = new ExtensionClassJSObject(typeInfo);
            }
        }

        public String getName() {
            return this.method.getName();
        }

        public JSObjectMetaData getReturn() {
            return this.returnType;
        }

        public JSObjectMetaData[] getArguments() {
            Iterator itr = this.method.argumentListIterator();
            if (itr != null && itr.hasNext()) {
                IArgumentInfoList ail = (IArgumentInfoList)itr.next();
                ArrayList<ExtensionClassJSObject> args = new ArrayList<ExtensionClassJSObject>();
                Iterator aitr = ail.argumentsIterator();
                while (aitr.hasNext()) {
                    IArgumentInfo aif = (IArgumentInfo)aitr.next();
                    args.add(new ExtensionClassJSObject(aif.getClassType()));
                }
                return args.toArray(new JSObjectMetaData[args.size()]);
            }
            return null;
        }

        public String getDisplayText() {
            if (this.displayText == null) {
                StringBuffer strbuf = new StringBuffer(this.getName());
                strbuf.append("(");
                Iterator argListItr = this.method.argumentListIterator();
                if (argListItr.hasNext()) {
                    IArgumentInfoList ail = (IArgumentInfoList)argListItr.next();
                    int i = 0;
                    Iterator itr = ail.argumentsIterator();
                    while (itr.hasNext()) {
                        if (i > 0) {
                            strbuf.append(", ");
                        }
                        IArgumentInfo ai = (IArgumentInfo)itr.next();
                        strbuf.append(ExtensionClassJSObject.this.getSimpleName(ai.getType())).append(" ").append("arg").append(i + 1);
                        ++i;
                    }
                }
                strbuf.append(") ");
                strbuf.append(ExtensionClassJSObject.this.getSimpleName(this.method.getReturnType()));
                strbuf.append(" - ");
                strbuf.append(ExtensionClassJSObject.this.getSimpleName(ExtensionClassJSObject.this.classInfo.getName()));
                this.displayText = strbuf.toString();
                Object var1_1 = null;
            }
            return this.displayText;
        }

        public String getDescription() {
            return null;
        }

        public int getVisibility() {
            return 0;
        }

        public int compareTo(Object obj) {
            if (obj instanceof ExtensionClassMethod && ((ExtensionClassMethod)obj).getName() != null) {
                return this.getName().compareToIgnoreCase(((ExtensionClassMethod)obj).getName());
            }
            return 0;
        }
    }
}

