/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.script;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.script.EngineClassJSObject;
import org.eclipse.birt.report.designer.internal.ui.script.ExtensionClassJSObject;
import org.eclipse.birt.report.designer.internal.ui.script.JSObjectMetaData;
import org.eclipse.birt.report.designer.internal.ui.script.JavaClassJSObject;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSSyntaxContext {
    private static Map<String, JSObjectMetaData> engineObjectMap = new HashMap<String, JSObjectMetaData>();
    private static Map<String, JSObjectMetaData> javaObjectMap = new HashMap<String, JSObjectMetaData>();
    private Map<String, JSObjectMetaData> objectMetaMap = new HashMap<String, JSObjectMetaData>();

    static {
        List engineClassesList = DEUtil.getClasses();
        for (IClassInfo element : engineClassesList) {
            engineObjectMap.put(element.getName(), new EngineClassJSObject(element));
        }
    }

    public static JSObjectMetaData getEnginJSObject(String classType) {
        return engineObjectMap.containsKey(classType) ? engineObjectMap.get(classType) : null;
    }

    public static JSObjectMetaData[] getAllEnginJSObjects() {
        return engineObjectMap.values().toArray(new JSObjectMetaData[engineObjectMap.values().size()]);
    }

    public static JSObjectMetaData getJavaClassMeta(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        JSObjectMetaData meta = null;
        if (!javaObjectMap.containsKey(clazz.getName())) {
            meta = new JavaClassJSObject(clazz);
            javaObjectMap.put(clazz.getName(), meta);
        } else {
            meta = javaObjectMap.get(clazz.getName());
        }
        return meta;
    }

    public static JSObjectMetaData getJavaClassMeta(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        JSObjectMetaData meta = null;
        if (!javaObjectMap.containsKey(className)) {
            meta = new JavaClassJSObject(className);
            javaObjectMap.put(className, meta);
        } else {
            meta = javaObjectMap.get(className);
        }
        return meta;
    }

    public boolean setVariable(String name, String className) {
        JSObjectMetaData engineObj = JSSyntaxContext.getEnginJSObject(className);
        if (engineObj != null) {
            this.objectMetaMap.put(name, engineObj);
            return true;
        }
        try {
            this.objectMetaMap.put(name, JSSyntaxContext.getJavaClassMeta(className));
            return true;
        }
        catch (Exception exception) {
            this.removeVariable(name);
            return false;
        }
    }

    public void setVariable(String name, Class<?> clazz) throws ClassNotFoundException {
        this.objectMetaMap.put(name, new JavaClassJSObject(clazz));
    }

    public void setVariable(String name, IClassInfo classInfo) {
        if (classInfo == null) {
            this.objectMetaMap.put(name, null);
        } else {
            this.objectMetaMap.put(name, new ExtensionClassJSObject(classInfo));
        }
    }

    public void removeVariable(String name) {
        this.objectMetaMap.remove(name);
    }

    public void clear() {
        this.objectMetaMap.clear();
    }

    public JSObjectMetaData getVariableMeta(String variableName) {
        if (this.objectMetaMap.containsKey(variableName)) {
            return this.objectMetaMap.get(variableName);
        }
        return JSSyntaxContext.getEnginJSObject(variableName);
    }
}

