/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ContextSelectionAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.ui.IWorkbenchPart;

public class CopyFormatAction
extends ContextSelectionAction {
    public static final String ID = "org.eclipse.birt.report.designer.internal.ui.views.actions.CopyFormatAction";
    public static final String ACTION_TEXT = Messages.getString((String)"CopyFormatAction.text");
    public static ElementFormatWrapper publicElementFormat;
    private static int instanceCount;
    private ElementFormatWrapper elementFormat;
    private boolean isDisposed;

    public static DesignElementHandle getDesignElementHandle() {
        return publicElementFormat == null ? null : publicElementFormat.getElement();
    }

    public CopyFormatAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(ACTION_TEXT);
        this.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor("CopyFormat"));
        ++instanceCount;
    }

    public boolean calculateEnabled() {
        Object object;
        if (this.getSelectedObjects().size() == 1 && (object = this.getSelectedObjects().get(0)) instanceof ReportElementEditPart) {
            return ((ReportElementEditPart)((Object)object)).getModel() instanceof DesignElementHandle;
        }
        return false;
    }

    public void run() {
        Object object = this.getSelectedObjects().get(0);
        if (object instanceof ReportElementEditPart) {
            if (this.elementFormat != null) {
                this.elementFormat.dispose();
            }
            if (publicElementFormat != null) {
                publicElementFormat.dispose();
            }
            publicElementFormat = this.elementFormat = new ElementFormatWrapper((DesignElementHandle)((ReportElementEditPart)((Object)object)).getModel());
        }
    }

    public void dispose() {
        super.dispose();
        if (!this.isDisposed) {
            if (this.elementFormat != null) {
                this.elementFormat.dispose();
            }
            if (instanceCount > 0) {
                if (instanceCount == 1 && publicElementFormat != null) {
                    publicElementFormat.dispose();
                }
                --instanceCount;
            }
            this.isDisposed = true;
        }
    }

    private static class ElementFormatWrapper
    implements Listener {
        private DesignElementHandle element;

        public ElementFormatWrapper(DesignElementHandle element) {
            this.element = element;
            element.addListener((Listener)this);
        }

        public DesignElementHandle getElement() {
            if (this.element != null && this.element.getContainer() != null) {
                return this.element;
            }
            return null;
        }

        public void dispose() {
            if (this.element != null) {
                this.element.removeListener((Listener)this);
            }
            this.element = null;
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.element = null;
        }
    }
}

