/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.internal.adapter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.ModelAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ColumnAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ParameterAdapter;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.OdaResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.SortHintHandle;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;

public class DataAdapterUtil {
    public static void adaptBaseDataSource(DataSourceHandle source, BaseDataSourceDesign dest) {
        dest.setBeforeOpenScript(source.getBeforeOpen());
        dest.setAfterOpenScript(source.getAfterOpen());
        dest.setBeforeCloseScript(source.getBeforeClose());
        dest.setAfterCloseScript(source.getAfterClose());
    }

    public static void adaptBaseDataSet(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet, ModelAdapter adapter) throws BirtException {
        if (!(modelDataSet instanceof JointDataSetHandle) && modelDataSet.getDataSource() == null) {
            throw new AdapterException("datasource.null.error", dteDataSet.getName());
        }
        if (!(modelDataSet instanceof JointDataSetHandle)) {
            dteDataSet.setDataSource(modelDataSet.getDataSource().getQualifiedName());
            dteDataSet.setBeforeOpenScript(modelDataSet.getBeforeOpen());
            dteDataSet.setAfterOpenScript(modelDataSet.getAfterOpen());
            dteDataSet.setOnFetchScript(modelDataSet.getOnFetch());
            dteDataSet.setBeforeCloseScript(modelDataSet.getBeforeClose());
            dteDataSet.setAfterCloseScript(modelDataSet.getAfterClose());
        }
        DataAdapterUtil.populateParameter(adapter, modelDataSet, dteDataSet);
        DataAdapterUtil.populateComputedColumn(adapter, modelDataSet, dteDataSet);
        DataAdapterUtil.populateFilter(modelDataSet, dteDataSet, adapter);
        DataAdapterUtil.populateSortHint(adapter, modelDataSet, dteDataSet);
        dteDataSet.setRowFetchLimit(modelDataSet.getRowFetchLimit());
        DataAdapterUtil.mergeHints(modelDataSet, dteDataSet);
    }

    private static void populateSortHint(ModelAdapter adapter, DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) {
        Iterator elmtIter = modelDataSet.sortHintsIterator();
        if (elmtIter != null) {
            while (elmtIter.hasNext()) {
                SortHintHandle modelFilter = (SortHintHandle)elmtIter.next();
                dteDataSet.addSortHint((ISortDefinition)adapter.adaptSortHint(modelFilter));
            }
        }
    }

    private static void populateParameter(IModelAdapter adapter, DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) throws AdapterException {
        HashMap<String, ScriptExpression> paramBindingCandidates = new HashMap<String, ScriptExpression>();
        Iterator elmtIter = modelDataSet.parametersIterator();
        if (elmtIter != null) {
            while (elmtIter.hasNext()) {
                DataSetParameterHandle modelParam = (DataSetParameterHandle)elmtIter.next();
                if (modelParam.isInput()) {
                    String defaultValueExpr = null;
                    if (modelParam instanceof OdaDataSetParameterHandle && ((OdaDataSetParameterHandle)modelParam).getParamName() != null) {
                        defaultValueExpr = ExpressionUtil.createJSParameterExpression((String)((OdaDataSetParameterHandle)modelParam).getParamName());
                        dteDataSet.addParameter((IParameterDefinition)new ParameterAdapter(modelParam));
                        paramBindingCandidates.put(modelParam.getName(), adapter.adaptExpression(defaultValueExpr, modelParam.getDataType()));
                        continue;
                    }
                    ExpressionHandle handle = modelParam.getExpressionProperty("defaultValue");
                    dteDataSet.addParameter((IParameterDefinition)new ParameterAdapter(modelParam));
                    paramBindingCandidates.put(modelParam.getName(), adapter.adaptExpression((Expression)handle.getValue(), modelParam.getDataType()));
                    continue;
                }
                dteDataSet.addParameter((IParameterDefinition)new ParameterAdapter(modelParam));
            }
        }
        if ((elmtIter = modelDataSet.paramBindingsIterator()) != null) {
            while (elmtIter.hasNext()) {
                ParamBindingHandle modelParamBinding = (ParamBindingHandle)elmtIter.next();
                if (modelParamBinding.getExpression() == null) continue;
                paramBindingCandidates.put(modelParamBinding.getParamName(), adapter.adaptExpression((Expression)modelParamBinding.getExpressionListHandle().getListValue().get(0)));
            }
        }
        if (paramBindingCandidates.size() > 0) {
            for (Object paramName : paramBindingCandidates.keySet()) {
                assert (paramName != null && paramName instanceof String);
                IScriptExpression expression = (IScriptExpression)paramBindingCandidates.get(paramName);
                dteDataSet.addInputParamBinding((IInputParameterBinding)new InputParameterBinding((String)paramName, (IBaseExpression)expression));
            }
        }
    }

    private static void populateComputedColumn(IModelAdapter adapter, DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) throws AdapterException {
        Iterator elmtIter = modelDataSet.computedColumnsIterator();
        if (elmtIter != null) {
            while (elmtIter.hasNext()) {
                ComputedColumnHandle modelCmptdColumn = (ComputedColumnHandle)elmtIter.next();
                dteDataSet.addComputedColumn((IComputedColumn)adapter.adaptComputedColumn(modelCmptdColumn));
            }
        }
    }

    private static void populateFilter(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet, ModelAdapter adapter) throws AdapterException {
        Iterator elmtIter = modelDataSet.filtersIterator();
        if (elmtIter != null) {
            while (elmtIter.hasNext()) {
                FilterConditionHandle modelFilter = (FilterConditionHandle)elmtIter.next();
                dteDataSet.addFilter((IFilterDefinition)adapter.adaptFilter(modelFilter));
            }
        }
    }

    private static void mergeHints(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) {
        OdaResultSetColumnHandle modelColumn;
        Iterator elmtIter;
        if (modelDataSet instanceof OdaDataSetHandle && (elmtIter = modelDataSet.resultSetIterator()) != null) {
            while (elmtIter.hasNext()) {
                modelColumn = (OdaResultSetColumnHandle)elmtIter.next();
                if (modelColumn.getColumnName().equals(modelColumn.getNativeName())) continue;
                dteDataSet.addResultSetHint((IColumnDefinition)new ColumnAdapter((ResultSetColumnHandle)modelColumn));
            }
        }
        if ((elmtIter = modelDataSet.resultSetHintsIterator()) != null) {
            while (elmtIter.hasNext()) {
                modelColumn = (ResultSetColumnHandle)elmtIter.next();
                dteDataSet.addResultSetHint((IColumnDefinition)new ColumnAdapter((ResultSetColumnHandle)modelColumn));
            }
        }
        if ((elmtIter = modelDataSet.columnHintsIterator()) != null) {
            List columnDefns = dteDataSet.getResultSetHints();
            while (elmtIter.hasNext()) {
                ColumnHintHandle modelColumnHint = (ColumnHintHandle)elmtIter.next();
                ColumnDefinition existDefn = DataAdapterUtil.findColumnDefn(columnDefns, modelColumnHint.getColumnName());
                if (existDefn != null) {
                    DataAdapterUtil.updateColumnDefn(existDefn, modelColumnHint);
                    continue;
                }
                dteDataSet.addResultSetHint((IColumnDefinition)new ColumnAdapter(modelColumnHint));
            }
        }
        if (modelDataSet instanceof OdaDataSetHandle && (elmtIter = modelDataSet.resultSetIterator()) != null) {
            while (elmtIter.hasNext()) {
                modelColumn = (OdaResultSetColumnHandle)elmtIter.next();
                ColumnDefinition columnDefn = DataAdapterUtil.findColumnDefn(dteDataSet.getResultSetHints(), modelColumn.getColumnName());
                if (columnDefn != null) {
                    columnDefn.setColumnNativeName(modelColumn.getNativeName());
                    columnDefn.setColumnPosition(modelColumn.getPosition().intValue());
                    columnDefn.setDataType(org.eclipse.birt.report.data.adapter.api.DataAdapterUtil.adaptModelDataType(modelColumn.getDataType()));
                    continue;
                }
                ColumnAdapter adapter = new ColumnAdapter((ResultSetColumnHandle)modelColumn);
                adapter.setColumnNativeName(modelColumn.getNativeName());
                adapter.setColumnPosition(modelColumn.getPosition());
                dteDataSet.addResultSetHint((IColumnDefinition)adapter);
            }
        }
    }

    public static void updateColumnDefn(ColumnDefinition dteColumn, ColumnHintHandle modelColumnHint) {
        String searchConstant;
        assert (dteColumn.getColumnName().equals(modelColumnHint.getColumnName()));
        dteColumn.setAlias(modelColumnHint.getAlias());
        dteColumn.setAnalysisType(ColumnAdapter.acquireAnalysisType(modelColumnHint.getAnalysis()));
        dteColumn.setAnalysisColumn(modelColumnHint.getAnalysisColumn());
        dteColumn.setIndexColumn(modelColumnHint.isIndexColumn());
        dteColumn.setCompressedColumn(modelColumnHint.isCompressed());
        String exportConstant = modelColumnHint.getExport();
        if (exportConstant != null) {
            int exportHint = 1;
            if (exportConstant.equals("if-realized")) {
                exportHint = 2;
            } else if (exportConstant.equals("always")) {
                exportHint = 3;
            } else assert (exportConstant.equals("none"));
            dteColumn.setExportHint(exportHint);
        }
        if ((searchConstant = modelColumnHint.getSearching()) != null) {
            int searchHint = 3;
            if (searchConstant.equals("indexed")) {
                searchHint = 2;
            } else if (searchConstant.equals("any")) {
                searchHint = 1;
            } else assert (searchConstant.equals("none"));
            dteColumn.setSearchHint(searchHint);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static ColumnDefinition findColumnDefn(List columnDefns, String columnName) {
        if (!DataAdapterUtil.$assertionsDisabled && columnName == null) {
            throw new AssertionError();
        }
        if (columnDefns == null) {
            return null;
        }
        iter = columnDefns.iterator();
        if (iter != null) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            column = (ColumnDefinition)iter.next();
            if (!columnName.equals(column.getColumnName())) continue;
            return column;
lbl11:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl12:
        // 1 sources

        return null;
    }

    public static Map getExtensionProperties(ReportElementHandle dataHandle, List driverPropList) {
        if (driverPropList == null || driverPropList.isEmpty()) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (IPropertyDefn modelExtProp : driverPropList) {
            String propName = modelExtProp.getName();
            assert (propName != null && propName.length() > 0);
            Object propValueObj = dataHandle.getProperty(modelExtProp.getName());
            String propValue = propValueObj == null ? null : propValueObj.toString();
            properties.put(propName, propValue);
        }
        return properties;
    }

    public static Expression getExpression(ExpressionHandle handle) {
        if (handle == null || handle.getValue() == null) {
            return null;
        }
        return (Expression)handle.getValue();
    }
}

