/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ChartCheckbox
extends Composite
implements Listener,
SelectionListener {
    public static final int STATE_GRAYED = 0;
    public static final int STATE_SELECTED = 1;
    public static final int STATE_UNSELECTED = 2;
    protected Button button;
    protected List<SelectionListener> selectListenerList = new ArrayList<SelectionListener>(2);
    protected boolean bDefaultSelection = false;

    public ChartCheckbox(Composite container, int styles) {
        this(container, styles, false);
    }

    public ChartCheckbox(Composite container, int styles, boolean defaultSelection) {
        super(container, 0);
        this.bDefaultSelection = defaultSelection;
        this.placeComponents(styles);
        this.initListeners();
    }

    protected void initListeners() {
    }

    protected void placeComponents(int styles) {
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginTop = 0;
        gl.marginBottom = 0;
        this.setLayout((Layout)gl);
        this.button = new Button((Composite)this, 0x20 | styles);
        GridData gd = new GridData(1808);
        this.button.setLayoutData((Object)gd);
    }

    public void setDefaultSelection(boolean defSelection) {
        this.bDefaultSelection = defSelection;
    }

    public void setText(String text) {
        this.button.setText(text);
    }

    public int getSelectionState() {
        if (this.button.getGrayed()) {
            return this.bDefaultSelection ? 1 : 2;
        }
        if (this.button.getSelection()) {
            return 1;
        }
        return 2;
    }

    public void setSelectionState(int state) {
        switch (state) {
            case 0: {
                this.button.setSelection(this.bDefaultSelection);
                break;
            }
            case 1: {
                this.button.setSelection(true);
                break;
            }
            case 2: {
                this.button.setSelection(false);
            }
        }
    }

    public void addListener(int eventType, Listener listener) {
        super.addListener(eventType, listener);
        if (this.button != null) {
            this.button.addListener(eventType, (Listener)this);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectListenerList.add(listener);
        this.button.addSelectionListener((SelectionListener)this);
    }

    public Button getButton() {
        return this.button;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.button) {
            event.widget = this;
            Listener[] lis = this.getListeners(event.type);
            int i = lis.length - 1;
            while (i >= 0) {
                lis[i].handleEvent(event);
                --i;
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.button) {
            Event e = new Event();
            e.detail = event.detail;
            e.data = event.data;
            e.display = event.display;
            e.doit = event.doit;
            e.height = event.height;
            e.item = event.item;
            e.stateMask = event.stateMask;
            e.text = event.text;
            e.time = event.time;
            e.width = event.width;
            e.widget = this;
            e.x = event.x;
            e.y = event.y;
            SelectionEvent se = new SelectionEvent(e);
            int i = this.selectListenerList.size() - 1;
            while (i >= 0) {
                this.selectListenerList.get(i).widgetSelected(se);
                --i;
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }
}

