/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.DefaultSelectDataComponent;
import org.eclipse.birt.chart.ui.swt.HelpContentImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IHelpContent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChartTypeImpl
implements IChartType {
    protected String chartTitle = "";

    @Override
    public String getDisplayName() {
        return "";
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public Collection<IChartSubType> getChartSubtypes(String Dimension, Orientation orientation) {
        return new Vector<IChartSubType>();
    }

    @Override
    public boolean canAdapt(Chart cModel, Hashtable htModelHints) {
        return false;
    }

    @Override
    public Chart getModel(String sType, Orientation Orientation2, String Dimension, Chart currentChart) {
        return null;
    }

    @Override
    public String[] getSupportedDimensions() {
        return new String[]{TWO_DIMENSION_TYPE};
    }

    @Override
    public String getDefaultDimension() {
        return TWO_DIMENSION_TYPE;
    }

    @Override
    public boolean supportsTransposition() {
        return false;
    }

    @Override
    public boolean supportsTransposition(String dimension) {
        return this.supportsTransposition();
    }

    @Override
    public Orientation getDefaultOrientation() {
        return Orientation.VERTICAL_LITERAL;
    }

    @Override
    public IHelpContent getHelp() {
        return new HelpContentImpl("{Title}", "{Description}");
    }

    @Override
    public ISelectDataComponent getBaseUI(Chart chart, ISelectDataCustomizeUI selectDataUI, ChartWizardContext context, String sTitle) {
        return new DefaultSelectDataComponent();
    }

    @Override
    public boolean isDimensionSupported(String dimensionType, ChartWizardContext context, int nbOfAxes, int nbOfSeries) {
        boolean isSupported = false;
        String[] supportedDimensions = this.getSupportedDimensions();
        int i = 0;
        while (i < supportedDimensions.length) {
            if (supportedDimensions[i].equals(dimensionType)) {
                isSupported = true;
                break;
            }
            ++i;
        }
        if (isSupported && THREE_DIMENSION_TYPE.equals(dimensionType)) {
            if (context.getDataServiceProvider().checkState(32)) {
                return false;
            }
            isSupported = nbOfAxes <= 1;
        }
        return isSupported;
    }

    @Override
    public Series getSeries() {
        return this.getSeries(true);
    }

    protected Series getConvertedSeriesAsFirst(Series series, int seriesIndex, Series firstSeries) {
        if (series.getClass().getName().equals(SeriesImpl.class.getName())) {
            return series;
        }
        Series tmpseries = ChartCacheManager.getInstance().findSeries(firstSeries.getClass().getName(), seriesIndex);
        if (tmpseries == null) {
            tmpseries = firstSeries.copyInstance();
        }
        ChartUIUtil.copyGeneralSeriesAttributes(series, tmpseries);
        if (firstSeries instanceof BarSeriesImpl) {
            ((BarSeriesImpl)tmpseries).setRiser(((BarSeriesImpl)firstSeries).getRiser());
        }
        return tmpseries;
    }

    protected SampleData getConvertedSampleData(SampleData currentSampleData, AxisType xAxisType, AxisType yAxisType) {
        EList bsdList = currentSampleData.getBaseSampleData();
        Vector<BaseSampleData> vNewBaseSampleData = this.getConvertedBaseSampleDataRepresentation((EList<BaseSampleData>)bsdList, xAxisType);
        currentSampleData.getBaseSampleData().clear();
        currentSampleData.getBaseSampleData().addAll(vNewBaseSampleData);
        EList osdList = currentSampleData.getOrthogonalSampleData();
        Vector<OrthogonalSampleData> vNewOrthogonalSampleData = new Vector<OrthogonalSampleData>();
        int i = 0;
        while (i < osdList.size()) {
            OrthogonalSampleData osd = (OrthogonalSampleData)osdList.get(i);
            osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation(yAxisType, osd.getDataSetRepresentation(), i));
            vNewOrthogonalSampleData.add(osd);
            ++i;
        }
        currentSampleData.getOrthogonalSampleData().clear();
        currentSampleData.getOrthogonalSampleData().addAll(vNewOrthogonalSampleData);
        return currentSampleData;
    }

    protected SampleData getConvertedSampleData(SampleData currentSampleData, AxisType xAxisType, List<AxisType> yAxisTypes) {
        EList bsdList = currentSampleData.getBaseSampleData();
        Vector<BaseSampleData> vNewBaseSampleData = this.getConvertedBaseSampleDataRepresentation((EList<BaseSampleData>)bsdList, xAxisType);
        currentSampleData.getBaseSampleData().clear();
        currentSampleData.getBaseSampleData().addAll(vNewBaseSampleData);
        EList osdList = currentSampleData.getOrthogonalSampleData();
        Vector<OrthogonalSampleData> vNewOrthogonalSampleData = this.getConvertedOrthogonalSampleDataRepresentation((EList<OrthogonalSampleData>)osdList, yAxisTypes);
        currentSampleData.getOrthogonalSampleData().clear();
        currentSampleData.getOrthogonalSampleData().addAll(vNewOrthogonalSampleData);
        return currentSampleData;
    }

    private Vector<BaseSampleData> getConvertedBaseSampleDataRepresentation(EList<BaseSampleData> bsdList, AxisType xAxisType) {
        Vector<BaseSampleData> vNewBaseSampleData = new Vector<BaseSampleData>();
        int i = 0;
        while (i < bsdList.size()) {
            BaseSampleData bsd = (BaseSampleData)bsdList.get(i);
            bsd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation(xAxisType, bsd.getDataSetRepresentation(), i));
            vNewBaseSampleData.add(bsd);
            ++i;
        }
        return vNewBaseSampleData;
    }

    private Vector<OrthogonalSampleData> getConvertedOrthogonalSampleDataRepresentation(EList<OrthogonalSampleData> osdList, List<AxisType> axisTypes) {
        Vector<OrthogonalSampleData> vNewOrthogonalSampleData = new Vector<OrthogonalSampleData>();
        int i = 0;
        while (i < axisTypes.size()) {
            OrthogonalSampleData osd = (OrthogonalSampleData)osdList.get(i);
            osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation(axisTypes.get(i), osd.getDataSetRepresentation(), i));
            vNewOrthogonalSampleData.add(osd);
            ++i;
        }
        return vNewOrthogonalSampleData;
    }

    @Override
    public boolean canCombine() {
        return false;
    }

    @Override
    public String getDefaultTitle() {
        return this.chartTitle;
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    protected void copyChartProperties(Chart oldChart, Chart newChart) {
        newChart.setBlock(oldChart.getBlock());
        newChart.setDescription(oldChart.getDescription());
        if (newChart.isSetGridColumnCount()) {
            newChart.setGridColumnCount(oldChart.getGridColumnCount());
        }
        newChart.setSampleData(oldChart.getSampleData());
        newChart.setScript(oldChart.getScript());
        newChart.setUnits(oldChart.getUnits());
        if (oldChart.isSetSeriesThickness()) {
            newChart.setSeriesThickness(oldChart.getSeriesThickness());
        }
        newChart.getExtendedProperties().clear();
        newChart.getExtendedProperties().addAll((Collection)oldChart.getExtendedProperties());
        if (oldChart.getInteractivity() != null) {
            if (oldChart.getInteractivity().isSetEnable()) {
                newChart.getInteractivity().setEnable(oldChart.getInteractivity().isEnable());
            }
            if (oldChart.getInteractivity().isSetLegendBehavior()) {
                newChart.getInteractivity().setLegendBehavior(oldChart.getInteractivity().getLegendBehavior());
            }
        }
    }

    @Override
    public String getValueDefinitionName() {
        return Messages.getString("DefaultChartTypeImpl.Label.ValueDefinitionName");
    }

    @Override
    public boolean isChartWithAxes() {
        return true;
    }

    @Override
    public Series getSeries(boolean needInitialing) {
        return null;
    }
}

