/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.ICloseListener;
import org.eclipse.birt.data.engine.cache.Constants;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.impl.DataEngineSession;

public class BasicCachedList
implements List,
ICloseListener {
    protected static final int NULL_VALUE = Integer.MAX_VALUE;
    protected static final int OBJECT_VALUE = 1;
    protected int cacheSize = 4000;
    private static Logger logger = Logger.getLogger(BasicCachedList.class.getName());
    private static int UNIQUE_ID;
    private int currentCacheNo;
    private List currentCache;
    private String fileNamePrefix;
    private int size;
    private List fileList = new ArrayList();
    private File dir;
    private String tempDir;
    protected ClassLoader loader;

    public BasicCachedList(String tempDir, ClassLoader loader) {
        this.cacheSize = Constants.LIST_BUFFER_SIZE;
        this.tempDir = tempDir;
        this.currentCacheNo = 0;
        this.size = 0;
        this.setFileNamePrefix();
        this.currentCache = new ArrayList();
        this.loader = loader;
    }

    private void setFileNamePrefix() {
        this.fileNamePrefix = "CachedList_" + Long.valueOf(System.nanoTime()).toString() + "_" + BasicCachedList.getID() + "_" + Integer.toHexString(this.hashCode());
    }

    private static synchronized int getID() {
        return ++UNIQUE_ID;
    }

    public BasicCachedList(String tempDir, ClassLoader loader, List list) {
        this(tempDir, loader);
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            this.add(list.get(i));
            ++i;
        }
    }

    public boolean add(Object o) {
        if (this.currentCache.size() >= this.cacheSize) {
            try {
                this.saveToDisk();
            }
            catch (DataException e) {
                e.printStackTrace();
            }
            this.currentCache.clear();
            if (this.size % this.cacheSize == 0) {
                this.currentCacheNo = this.fileList.size();
            } else {
                try {
                    this.currentCacheNo = this.fileList.size() - 1;
                    this.loadFromDisk();
                }
                catch (DataException dataException) {}
            }
        }
        this.currentCache.add(o);
        ++this.size;
        return true;
    }

    private void saveToDisk() throws DataException {
        FileOutputStream fos = null;
        FilterOutputStream oos = null;
        try {
            File cacheFile = null;
            if (this.currentCacheNo < this.fileList.size()) {
                cacheFile = (File)this.fileList.get(this.currentCacheNo);
            } else {
                cacheFile = this.getCacheFile(this.currentCacheNo);
                this.fileList.add(cacheFile);
            }
            fos = FileSecurity.createFileOutputStream(cacheFile);
            oos = new DataOutputStream(new BufferedOutputStream(fos));
            this.writeList((DataOutputStream)oos, this.currentCache);
            oos.close();
        }
        catch (FileNotFoundException e) {
            logger.severe("Exception happened when save data to disk in CachedList. Exception message: " + e.toString());
        }
        catch (IOException e) {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException iOException) {}
            logger.severe("Exception happened when save data to disk in CachedList. Exception message: " + e.toString());
        }
    }

    private void writeList(DataOutputStream oos, List list) throws IOException {
        IOUtil.writeInt((OutputStream)oos, (int)list.size());
        int i = 0;
        while (i < list.size()) {
            this.writeObject(oos, list.get(i));
            ++i;
        }
    }

    protected void writeObject(DataOutputStream oos, Object object) throws IOException {
        if (object == null) {
            IOUtil.writeInt((OutputStream)oos, (int)Integer.MAX_VALUE);
            return;
        }
        IOUtil.writeInt((OutputStream)oos, (int)1);
        IOUtil.writeObject((DataOutputStream)oos, (Object)object);
    }

    public Object get(int index) {
        this.RangeCheck(index);
        if (index / this.cacheSize != this.currentCacheNo) {
            try {
                this.saveToDisk();
            }
            catch (DataException dataException) {}
            this.currentCacheNo = index / this.cacheSize;
            try {
                this.loadFromDisk();
            }
            catch (DataException dataException) {}
        }
        return this.currentCache.get(index - this.currentCacheNo * this.cacheSize);
    }

    private void loadFromDisk() throws DataException {
        FileInputStream fis = null;
        FilterInputStream ois = null;
        try {
            fis = FileSecurity.createFileInputStream(this.getCacheFile(this.currentCacheNo));
            ois = new DataInputStream(new BufferedInputStream(fis));
            this.currentCache = this.readList((DataInputStream)ois);
            ois.close();
        }
        catch (FileNotFoundException e) {
            logger.severe("Exception happened when load data from disk in CachedList. Exception message: " + e.toString());
        }
        catch (IOException e) {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException iOException) {}
            logger.severe("Exception happened when load data from disk in CachedList. Exception message: " + e.toString());
        }
    }

    private List readList(DataInputStream dis) throws IOException {
        ArrayList<Object> reList = new ArrayList<Object>();
        int objectCount = IOUtil.readInt((InputStream)dis);
        int i = 0;
        while (i < objectCount) {
            reList.add(this.readObject(dis));
            ++i;
        }
        return reList;
    }

    protected Object readObject(DataInputStream dis) throws IOException {
        int fieldCount = IOUtil.readInt((InputStream)dis);
        if (fieldCount == Integer.MAX_VALUE) {
            return null;
        }
        return IOUtil.readObject((DataInputStream)dis, (ClassLoader)DataEngineSession.getCurrentClassLoader());
    }

    private File getCacheFile(int cacheIndex) {
        String tempDirStr = String.valueOf(this.tempDir) + this.fileNamePrefix;
        if (this.dir == null) {
            this.dir = new File(tempDirStr);
            FileSecurity.fileMakeDirs(this.dir);
        }
        return new File(String.valueOf(tempDirStr) + File.separatorChar + cacheIndex + ".tmp");
    }

    public int size() {
        return this.size;
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException("add( int index, Object element ) method in CacheList is not supported!");
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("addAll method in CacheList is not supported!");
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException("addAll method in CacheList is not supported!");
    }

    public void clear() {
        this.clearTempDir();
        this.currentCacheNo = 0;
        this.size = 0;
        this.setFileNamePrefix();
        this.currentCache = new ArrayList();
    }

    public boolean contains(Object o) {
        throw new UnsupportedOperationException("the contains( Object o ) method in CacheList is not supported!");
    }

    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException("the containsAll( Collection c ) method in CacheList is not supported!");
    }

    public int indexOf(Object o) {
        throw new UnsupportedOperationException("the indexOf( Object o ) method in CacheList is not supported!");
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Iterator iterator() {
        throw new UnsupportedOperationException("the iterator( ) method in CacheList is not supported!");
    }

    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("the lastIndexOf( Object o ) method in CacheList is not supported!");
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException("the listIterator( ) method in CacheList is not supported!");
    }

    public ListIterator listIterator(int index) {
        throw new UnsupportedOperationException("the listIterator( int index ) method in CacheList is not supported!");
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException("the remove( int index ) method in CacheList is not supported!");
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("the remove( Object o ) method in CacheList is not supported!");
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("the removeAll( Collection c ) method in CacheList is not supported!");
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("the retainAll( Collection c ) method in CacheList is not supported!");
    }

    public Object set(int index, Object element) {
        this.RangeCheck(index);
        Object oldValue = this.get(index);
        this.currentCache.set(index - this.currentCacheNo * this.cacheSize, element);
        return oldValue;
    }

    private void RangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("the subList( int fromIndex, int toIndex ) method in CacheList is not supported!");
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException("method in CacheList is not supported!");
    }

    public Object[] toArray(Object[] a) {
        throw new UnsupportedOperationException("method in CacheList is not supported!");
    }

    public void clearTempDir() {
        int i = 0;
        while (i < this.fileList.size()) {
            File file = (File)this.fileList.get(i);
            if (FileSecurity.fileExist(file)) {
                FileSecurity.fileDelete(file);
            }
            ++i;
        }
        this.fileList.clear();
        if (this.dir != null && FileSecurity.fileExist(this.dir)) {
            FileSecurity.fileDelete(this.dir);
            this.dir = null;
        }
    }

    public void close() {
        this.clearTempDir();
    }
}

