/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.dscache;

import java.util.ArrayList;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory;
import org.eclipse.birt.data.engine.executor.dscache.ISaveUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.IIncreCacheDataSetDesign;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class DataSetToCache {
    private IResultClass rsMeta;
    private ResultSet odaDataSet;
    private ICustomDataSet customDataSet;
    private IDataSetPopulator populator;
    private int cacheCount;
    private ISaveUtil saveUtil;
    private DataEngineSession session;
    private Integer increCacheMode;

    public DataSetToCache(ResultSet odaDataSet, IResultClass rsMeta, DataEngineSession session) throws DataException {
        assert (odaDataSet != null);
        assert (rsMeta != null);
        this.odaDataSet = odaDataSet;
        this.init(rsMeta, session);
    }

    public DataSetToCache(IDataSetPopulator populator, IResultClass rsMeta, DataEngineSession session) throws DataException {
        assert (populator != null);
        assert (rsMeta != null);
        this.populator = populator;
        this.init(rsMeta, session);
    }

    public DataSetToCache(ICustomDataSet customDataSet, IResultClass rsMeta, DataEngineSession session) throws DataException {
        assert (customDataSet != null);
        assert (rsMeta != null);
        this.customDataSet = customDataSet;
        this.init(rsMeta, session);
    }

    private void init(IResultClass rsMeta, DataEngineSession session) throws DataException {
        this.rsMeta = DataSetToCache.rebuildResultClass(rsMeta);
        this.session = session;
        this.cacheCount = this.getCacheCapability();
        this.populateCacheMode(session);
    }

    private static IResultClass rebuildResultClass(IResultClass meta) throws DataException {
        ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
        int i = 1;
        while (i <= meta.getFieldCount()) {
            if (!meta.getFieldName(i).matches("\\Q_{$TEMP\\E.*\\d*\\Q$}_\\E")) {
                ResultFieldMetadata field = new ResultFieldMetadata(0, meta.getFieldName(i), meta.getFieldLabel(i), meta.getFieldValueClass(i), meta.getFieldNativeTypeName(i), meta.isCustomField(i), meta.getAnalysisType(i), meta.getAnalysisColumn(i), meta.isIndexColumn(i), meta.isCompressedColumn(i));
                field.setAlias(meta.getFieldAlias(i));
                projectedColumns.add(field);
            }
            ++i;
        }
        ResultClass result = new ResultClass(projectedColumns);
        return result;
    }

    private void populateCacheMode(DataEngineSession session) {
        DataSetCacheManager cacheManager = session.getDataSetCacheManager();
        IBaseDataSetDesign dataSetDesign = cacheManager.getCurrentDataSetDesign();
        if (dataSetDesign instanceof IIncreCacheDataSetDesign) {
            IIncreCacheDataSetDesign icDataSetDesign = (IIncreCacheDataSetDesign)dataSetDesign;
            this.increCacheMode = icDataSetDesign.getCacheMode();
        }
    }

    public IResultObject fetch() throws DataException {
        return this.fetchFromDataSet();
    }

    public void saveDataSetResult(IResultIterator itr) throws DataException {
        try {
            try {
                int saved = 0;
                IResultObject resultObject = null;
                this.saveInit();
                itr.first(0);
                while (itr.getCurrentResult() != null) {
                    resultObject = itr.getCurrentResult();
                    this.saveUtil.saveObject(resultObject);
                    if (this.increCacheMode == null && ++saved >= this.cacheCount) break;
                    if (this.session.getStopSign().isStopped()) {
                        this.removeCacheObject();
                        break;
                    }
                    itr.next();
                }
                this.saveClose();
            }
            catch (DataException de) {
                this.removeCacheObject();
                throw de;
            }
        }
        catch (Throwable throwable) {
            try {
                itr.first(0);
            }
            catch (DataException dataException) {}
            throw throwable;
        }
        try {
            itr.first(0);
        }
        catch (DataException dataException) {}
    }

    private void removeCacheObject() throws DataException {
        DataSetCacheManager dataSetCacheManager = this.getDataSetCacheManager();
        dataSetCacheManager.clearCache(dataSetCacheManager.getCurrentDataSourceDesign(), dataSetCacheManager.getCurrentDataSetDesign());
    }

    private IResultObject fetchFromDataSet() throws DataException {
        IResultObject resultObject = null;
        if (this.odaDataSet != null) {
            resultObject = this.odaDataSet.fetch();
        } else if (this.customDataSet != null) {
            resultObject = this.customDataSet.fetch();
        } else if (this.populator != null) {
            resultObject = this.populator.next();
        }
        return resultObject;
    }

    public void close() throws DataException {
    }

    private void saveInit() throws DataException {
        this.saveUtil = CacheUtilFactory.createSaveUtil(this.getCacheObject(), this.rsMeta, this.session);
    }

    private void saveClose() throws DataException {
        if (this.saveUtil != null) {
            this.saveUtil.close();
            this.saveUtil = null;
        }
    }

    private DataSetCacheManager getDataSetCacheManager() {
        return this.session.getDataSetCacheManager();
    }

    private int getCacheCapability() throws DataException {
        return this.getDataSetCacheManager().getCacheCapability();
    }

    private IDataSetCacheObject getCacheObject() throws DataException {
        return this.getDataSetCacheManager().getCacheObject();
    }
}

