/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

public class QueryResultIDUtil {
    private static final String QURE_ID_PREFIX = "QuRs";
    private static final String QURE_ID_SEPARATOR = "_";
    private static final String STREAM_ID_SEPARATOR = "/";
    private static final String SUBQUERY_ID_SEPARATOR = "/";
    private int currentId;

    public QueryResultIDUtil() {
    }

    public QueryResultIDUtil(int startingID) {
        this.currentId = startingID;
    }

    public String nextID() {
        return QURE_ID_PREFIX + this.currentId++;
    }

    public static String buildID(String _1partQueryResultID, String _2partQueryResultID) {
        String newID = _1partQueryResultID;
        newID = newID != null ? String.valueOf(newID) + QURE_ID_SEPARATOR + _2partQueryResultID : _2partQueryResultID;
        return newID;
    }

    public static String get1PartID(String queryResultID) {
        if (queryResultID == null) {
            return null;
        }
        int slashIndex = queryResultID.indexOf(QURE_ID_SEPARATOR);
        if (slashIndex < 0) {
            return null;
        }
        String nextStr = queryResultID.substring(slashIndex + 1);
        if (nextStr.startsWith(QURE_ID_PREFIX)) {
            return queryResultID.substring(0, slashIndex);
        }
        return null;
    }

    public static String get2PartID(String queryResultID) {
        if (queryResultID == null) {
            return null;
        }
        int slashIndex = queryResultID.indexOf(QURE_ID_SEPARATOR);
        if (slashIndex < 0) {
            return null;
        }
        String nextStr = queryResultID.substring(slashIndex + 1);
        if (nextStr.startsWith(QURE_ID_PREFIX)) {
            return queryResultID.substring(slashIndex + 1);
        }
        return queryResultID;
    }

    public static String getRealStreamID(String _1partQueryResultID, String _2partQueryResultID) {
        if (_1partQueryResultID == null) {
            return _2partQueryResultID;
        }
        if (_2partQueryResultID == null) {
            return _1partQueryResultID;
        }
        return String.valueOf(_1partQueryResultID) + "/" + _2partQueryResultID;
    }

    public static String buildSubQueryID(String subQueryName, int subQueryIndex) {
        return String.valueOf(subQueryName) + "/" + subQueryIndex;
    }

    public int getCurrentQueryId() {
        return this.currentId;
    }
}

