/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.Map;
import java.util.Properties;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManager;
import org.eclipse.birt.data.engine.odaconsumer.ExceptionHandler;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.services.impl.ProviderUtil;
import org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.ValueExpression;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ExtensionContributor;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ResultExtensionExplorer;
import org.eclipse.datatools.connectivity.oda.spec.result.AggregateExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.FilterExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.ResultProjection;
import org.eclipse.datatools.connectivity.oda.spec.result.ResultSetSpecification;
import org.eclipse.datatools.connectivity.oda.spec.result.SortSpecification;
import org.eclipse.datatools.connectivity.oda.spec.util.QuerySpecificationHelper;
import org.eclipse.datatools.connectivity.oda.spec.util.ValidatorUtil;

public class QuerySpecHelper {
    QuerySpecificationHelper m_specFactoryHelper;

    public QuerySpecHelper(String odaDataSourceId, String odaDataSetId) {
        ExtensionContributor[] contributors = null;
        try {
            contributors = ResultExtensionExplorer.getInstance().getContributorsOfDataSet(odaDataSourceId, odaDataSetId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (OdaException odaException) {}
        ExtensionContributor resultSetContributor = null;
        if (contributors != null && contributors.length > 0) {
            resultSetContributor = contributors[0];
        }
        this.m_specFactoryHelper = new QuerySpecificationHelper(resultSetContributor);
    }

    public QuerySpecHelper(String dynamicResultSetExtnId) {
        this.m_specFactoryHelper = new QuerySpecificationHelper(dynamicResultSetExtnId);
    }

    public QuerySpecificationHelper getFactoryHelper() {
        return this.m_specFactoryHelper;
    }

    public static void setParameterValue(QuerySpecification querySpec, ParameterHint paramHint, Object inputValue) throws DataException {
        boolean hasParamPos;
        if (querySpec == null || paramHint == null) {
            return;
        }
        boolean hasNativeName = PreparedStatement.hasValue(paramHint.getNativeName());
        boolean bl = hasParamPos = paramHint.getPosition() > 0;
        if (!paramHint.isInputMode() || !hasNativeName && !hasParamPos) {
            String errorCode;
            String string = errorCode = paramHint.isInputMode() ? "odaconsumer.ParameterNameCannotBeEmptyOrNull" : "odaconsumer.CannotFindInParameter";
            String errMsgArg = paramHint.isInputMode() ? null : (hasNativeName ? paramHint.getNativeName() : Integer.valueOf(paramHint.getPosition()));
            throw ExceptionHandler.newException(errorCode, errMsgArg, new IllegalArgumentException());
        }
        QuerySpecification.ParameterIdentifier paramIdentifier = null;
        if (hasNativeName) {
            QuerySpecification.ParameterIdentifier parameterIdentifier;
            if (hasParamPos) {
                QuerySpecification querySpecification = querySpec;
                querySpecification.getClass();
                parameterIdentifier = new QuerySpecification.ParameterIdentifier(querySpecification, paramHint.getNativeName(), paramHint.getPosition());
            } else {
                QuerySpecification querySpecification = querySpec;
                querySpecification.getClass();
                parameterIdentifier = new QuerySpecification.ParameterIdentifier(querySpecification, paramHint.getNativeName());
            }
            paramIdentifier = parameterIdentifier;
        } else {
            QuerySpecification querySpecification = querySpec;
            querySpecification.getClass();
            paramIdentifier = new QuerySpecification.ParameterIdentifier(querySpecification, paramHint.getPosition());
        }
        querySpec.setParameterValue(paramIdentifier, inputValue);
    }

    public static void setValidationConnectionContext(ValidationContext validationContext, Properties connProperties, Map appContext) throws DataException {
        String profileStoreResolvedPath;
        if (validationContext == null) {
            throw new IllegalArgumentException("ValidationContext");
        }
        Properties effectiveProps = QuerySpecHelper.getEffectiveProperties(connProperties, appContext);
        if (effectiveProps != null && !effectiveProps.equals(connProperties) && (profileStoreResolvedPath = effectiveProps.getProperty("org.eclipse.datatools.connectivity.oda_transient.profileStorePath")) != null && profileStoreResolvedPath.length() > 0) {
            effectiveProps.setProperty("OdaConnProfileStorePath", profileStoreResolvedPath);
        }
        if (validationContext.getConnection() != null) {
            validationContext.getConnection().setProperties(effectiveProps);
        } else {
            ValidationContext validationContext2 = validationContext;
            validationContext2.getClass();
            validationContext.setConnection(new ValidationContext.Connection(validationContext2, effectiveProps));
        }
    }

    private static Properties getEffectiveProperties(Properties connProperties, Map appContext) throws DataException {
        appContext = ConnectionManager.addProfileProviderService(appContext);
        try {
            return ProviderUtil.getEffectiveProperties((Properties)connProperties, (Object)appContext);
        }
        catch (OdaException ex) {
            throw ExceptionHandler.newException("odaconsumer.CannotOpenConnection", ex);
        }
    }

    private static IConnectionProfile createTransientProfile(String odaDataSourceId, Properties connProperties, Map appContext) throws DataException {
        IConnectionProfile connProfile;
        Properties effectiveProps = QuerySpecHelper.getEffectiveProperties(connProperties, appContext);
        try {
            connProfile = OdaProfileExplorer.getInstance().createTransientProfile(odaDataSourceId, effectiveProps);
        }
        catch (OdaException ex) {
            throw ExceptionHandler.newException("odaconsumer.CannotOpenConnection", ex);
        }
        return connProfile;
    }

    public static boolean isInvalidResultSetSpec(ResultSetSpecification resultSetSpec, DataException dataEx) {
        if (!QuerySpecHelper.hasOdaException(dataEx)) {
            return false;
        }
        return ValidatorUtil.isInvalidResultSetSpec((ResultSetSpecification)resultSetSpec, (OdaException)((OdaException)dataEx.getCause()));
    }

    public static boolean isInvalidFilterExpression(FilterExpression filterExpr, DataException dataEx) {
        if (!QuerySpecHelper.hasOdaException(dataEx)) {
            return false;
        }
        return ValidatorUtil.isInvalidFilterExpression((FilterExpression)filterExpr, (OdaException)((OdaException)dataEx.getCause()));
    }

    public static boolean isInvalidSortSpec(SortSpecification sortSpec, DataException dataEx) {
        if (!QuerySpecHelper.hasOdaException(dataEx)) {
            return false;
        }
        return ValidatorUtil.isInvalidSortSpec((SortSpecification)sortSpec, (OdaException)((OdaException)dataEx.getCause()));
    }

    public static boolean isInvalidSortKey(int sortKeySequenceOrder, DataException dataEx) {
        if (!QuerySpecHelper.hasOdaException(dataEx)) {
            return false;
        }
        return ValidatorUtil.isInvalidSortKey((int)sortKeySequenceOrder, (OdaException)((OdaException)dataEx.getCause()));
    }

    public static boolean isInvalidResultProjection(ResultProjection resultProj, DataException dataEx) {
        if (!QuerySpecHelper.hasOdaException(dataEx)) {
            return false;
        }
        return ValidatorUtil.isInvalidResultProjection((ResultProjection)resultProj, (OdaException)((OdaException)dataEx.getCause()));
    }

    public static boolean isInvalidAggregateExpression(AggregateExpression aggrExpr, DataException dataEx) {
        if (!QuerySpecHelper.hasOdaException(dataEx)) {
            return false;
        }
        return ValidatorUtil.isInvalidAggregateExpression((AggregateExpression)aggrExpr, (OdaException)((OdaException)dataEx.getCause()));
    }

    public static boolean isInvalidValueExpression(ValueExpression valueExpr, DataException dataEx) {
        if (!QuerySpecHelper.hasOdaException(dataEx)) {
            return false;
        }
        return ValidatorUtil.isInvalidValueExpression((ValueExpression)valueExpr, (OdaException)((OdaException)dataEx.getCause()));
    }

    private static boolean hasOdaException(DataException dataEx) {
        if (dataEx == null) {
            return false;
        }
        return dataEx.getCause() instanceof OdaException;
    }
}

