/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.olap.data.document.BlockRandomAccessObject;
import org.eclipse.birt.data.engine.olap.data.document.BufferedRandomDataAccessObject;
import org.eclipse.birt.data.engine.olap.data.document.DocumentObject;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.document.IObjectAllocTable;
import org.eclipse.birt.data.engine.olap.data.document.ObjectStructure;
import org.eclipse.birt.data.engine.olap.data.util.BufferedRandomAccessFile;

public class FileDocumentManager
implements IDocumentManager,
IObjectAllocTable {
    private int dataFileCacheSize = 0;
    private BufferedRandomAccessFile objectAccessFile = null;
    private BufferedRandomAccessFile oatAccessFile = null;
    private BufferedRandomAccessFile dataAccessFile = null;
    private File objectFile = null;
    private File oatFile = null;
    private File dataFile = null;
    private HashMap documentObjectMap = null;

    static FileDocumentManager createManager(String dirName, String managerName) throws DataException, IOException {
        return FileDocumentManager.createManager(dirName, managerName, 0);
    }

    static FileDocumentManager createManager(String dirName, String managerName, int cacheSize) throws DataException, IOException {
        File tmpDir = new File(dirName);
        if (!FileSecurity.fileExist(tmpDir) || !FileSecurity.fileIsDirectory(tmpDir)) {
            FileSecurity.fileMakeDirs(tmpDir);
        }
        FileDocumentManager manager = new FileDocumentManager(cacheSize);
        manager.create(dirName, managerName);
        return manager;
    }

    static FileDocumentManager loadManager(String dirName, String managerName) throws DataException, IOException {
        FileDocumentManager manager = new FileDocumentManager();
        manager.load(dirName, managerName);
        return manager;
    }

    private FileDocumentManager() {
        this.dataFileCacheSize = 0;
    }

    private FileDocumentManager(int fileCacheSize) {
        this.dataFileCacheSize = fileCacheSize * 1024 * 1024;
    }

    private void create(String dirName, String managerName) throws IOException, DataException {
        this.documentObjectMap = new HashMap();
        this.objectFile = new File(String.valueOf(dirName) + File.separatorChar + managerName + "obj");
        this.objectAccessFile = new BufferedRandomAccessFile(this.objectFile, "rw", 1024, this.dataFileCacheSize / 5);
        this.objectAccessFile.setLength(0L);
        this.oatFile = new File(String.valueOf(dirName) + File.separatorChar + managerName + "Oat");
        this.oatAccessFile = new BufferedRandomAccessFile(this.oatFile, "rw", 1024, this.dataFileCacheSize / 10);
        this.oatAccessFile.setLength(0L);
        this.dataFile = new File(String.valueOf(dirName) + File.separatorChar + managerName + "data");
        this.dataAccessFile = new BufferedRandomAccessFile(this.dataFile, "rw", 1024, this.dataFileCacheSize);
        this.dataAccessFile.setLength(0L);
    }

    private void load(String dirName, String managerName) throws IOException, DataException {
        this.documentObjectMap = new HashMap();
        File file = new File(String.valueOf(dirName) + File.separatorChar + managerName + "obj");
        this.objectAccessFile = new BufferedRandomAccessFile(file, "rw", 1024, this.dataFileCacheSize / 5);
        if (!FileSecurity.fileExist(file)) {
            throw new DataException("data.olap.OlapFileNotFound", file.getAbsolutePath());
        }
        file = new File(String.valueOf(dirName) + File.separatorChar + managerName + "Oat");
        if (!FileSecurity.fileExist(file)) {
            throw new DataException("data.olap.OlapFileNotFound", file.getAbsolutePath());
        }
        this.oatAccessFile = new BufferedRandomAccessFile(file, "rw", 1024, this.dataFileCacheSize / 10);
        file = new File(String.valueOf(dirName) + File.separatorChar + managerName + "data");
        if (!FileSecurity.fileExist(file)) {
            throw new DataException("data.olap.OlapFileNotFound", file.getAbsolutePath());
        }
        this.dataAccessFile = new BufferedRandomAccessFile(file, "rw", 1024, this.dataFileCacheSize);
        this.objectAccessFile.seek(0L);
        try {
            while (true) {
                ObjectStructure structure = this.readObjectStructure();
                if (structure.firstBlock < 0) continue;
                this.documentObjectMap.put(structure.name, structure);
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public void close() throws IOException {
        this.objectAccessFile.close();
        this.oatAccessFile.close();
        this.dataAccessFile.close();
        this.clearTmpFile();
    }

    public void clearTmpFile() {
        if (this.objectFile != null) {
            FileSecurity.fileDeleteOnExit(this.objectFile);
            this.objectFile = null;
        }
        if (this.oatFile != null) {
            FileSecurity.fileDeleteOnExit(this.oatFile);
            this.oatFile = null;
        }
        if (this.dataFile != null) {
            FileSecurity.fileDeleteOnExit(this.dataFile);
            this.dataFile = null;
        }
    }

    public IDocumentObject createDocumentObject(String documentObjectName) throws IOException {
        ObjectStructure objectStructure = new ObjectStructure();
        objectStructure.name = documentObjectName;
        objectStructure.firstBlock = this.findFreeBlock();
        objectStructure.length = 0L;
        this.writeObjectStructure(objectStructure);
        this.documentObjectMap.put(objectStructure.name, objectStructure);
        return new DocumentObject(new BufferedRandomDataAccessObject(new BlockRandomAccessObject(this.dataAccessFile, documentObjectName, objectStructure.firstBlock, objectStructure.length, this), 1024));
    }

    private void writeObjectStructure(ObjectStructure structure) throws IOException {
        this.objectAccessFile.seek(this.objectAccessFile.length());
        structure.fileOffset = (int)this.objectAccessFile.getFilePointer();
        this.objectAccessFile.writeLong(structure.length);
        this.objectAccessFile.writeInt(structure.firstBlock);
        this.objectAccessFile.writeUTF(structure.name);
    }

    private ObjectStructure readObjectStructure() throws IOException {
        ObjectStructure structure = new ObjectStructure();
        structure.fileOffset = (int)this.objectAccessFile.getFilePointer();
        structure.length = this.objectAccessFile.readLong();
        structure.firstBlock = this.objectAccessFile.readInt();
        structure.name = this.objectAccessFile.readUTF();
        return structure;
    }

    private int findFreeBlock() throws IOException {
        int oldLength = (int)this.oatAccessFile.length();
        this.oatAccessFile.setLength(oldLength + 4);
        return oldLength / 4;
    }

    public IDocumentObject openDocumentObject(String documentObjectName) throws IOException {
        ObjectStructure objectStructure = (ObjectStructure)this.documentObjectMap.get(documentObjectName);
        if (objectStructure == null) {
            return null;
        }
        return new DocumentObject(new BufferedRandomDataAccessObject(new BlockRandomAccessObject(this.dataAccessFile, documentObjectName, objectStructure.firstBlock, objectStructure.length, this), 1024));
    }

    public boolean exist(String documentObjectName) {
        return this.documentObjectMap.get(documentObjectName) != null;
    }

    public int getNextBlock(int blockNo) throws IOException {
        this.oatAccessFile.seek((long)blockNo * 4L);
        return this.oatAccessFile.readInt();
    }

    public int allocateBlock(int blockNo) throws IOException {
        int newBlock = this.findFreeBlock();
        this.oatAccessFile.seek((long)blockNo * 4L);
        this.oatAccessFile.writeInt(newBlock);
        return newBlock;
    }

    public void setObjectLength(String documentObjectName, long length) throws IOException {
        ObjectStructure objectStructure = (ObjectStructure)this.documentObjectMap.get(documentObjectName);
        if (objectStructure == null) {
            return;
        }
        objectStructure.length = length;
        this.objectAccessFile.seek(objectStructure.fileOffset);
        this.objectAccessFile.writeLong(length);
    }

    public void flush() throws IOException {
        this.objectAccessFile.flush();
        this.oatAccessFile.flush();
        this.dataAccessFile.flush();
    }
}

