/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;

public class DrilledAggregation {
    private int[] sortType;
    private List<AggregationDefinition> originalAggregationList;
    private DimLevel[] targetLevels;

    public DrilledAggregation(DimLevel[] targetLevels, ICubeQueryDefinition cubeQueryDefinition) {
        this.targetLevels = targetLevels;
        this.originalAggregationList = new ArrayList<AggregationDefinition>();
        this.sortType = new int[targetLevels.length];
        int index = 0;
        while (index < targetLevels.length) {
            try {
                this.sortType[index] = CubeQueryDefinitionUtil.getSortDirection(targetLevels[index], cubeQueryDefinition);
            }
            catch (DataException dataException) {
                this.sortType[index] = -1;
            }
            ++index;
        }
    }

    public void addOriginalAggregation(AggregationDefinition aggregation) {
        this.originalAggregationList.add(aggregation);
    }

    public boolean usedByAggregation(AggregationDefinition aggregation) {
        return this.originalAggregationList.contains(aggregation);
    }

    public boolean matchTargetlevels(DimLevel[] levels) {
        if (levels == this.targetLevels) {
            return true;
        }
        if (levels == null) {
            return false;
        }
        if (this.targetLevels.length != levels.length) {
            return false;
        }
        int i = 0;
        while (i < this.targetLevels.length) {
            if (!this.targetLevels[i].equals(levels[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public DimLevel[] getTargetLevels() {
        return this.targetLevels;
    }

    public int[] getSortType() {
        return this.sortType;
    }

    public AggregationFunctionDefinition[] getAggregationFunctionDefinition() {
        AggregationFunctionDefinition[] aggr;
        HashMap<String, AggregationFunctionDefinition> functionMap = new HashMap<String, AggregationFunctionDefinition>();
        int i = 0;
        while (i < this.originalAggregationList.size()) {
            aggr = this.originalAggregationList.get(i);
            int j = 0;
            while (j < aggr.getAggregationFunctions().length) {
                if (!functionMap.containsKey(aggr.getAggregationFunctions()[j].getName())) {
                    functionMap.put(aggr.getAggregationFunctions()[j].getName(), aggr.getAggregationFunctions()[j]);
                }
                ++j;
            }
            ++i;
        }
        Iterator iter = functionMap.entrySet().iterator();
        aggr = new AggregationFunctionDefinition[functionMap.size()];
        int index = 0;
        while (iter.hasNext()) {
            aggr[index] = (AggregationFunctionDefinition)iter.next().getValue();
            ++index;
        }
        return aggr;
    }
}

