/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.dimension;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimesionMemberCreator;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.birt.data.engine.olap.data.util.IComparableStructure;
import org.eclipse.birt.data.engine.olap.data.util.IStructureCreator;

public class DimensionRow
implements IComparableStructure {
    private static IStructureCreator creator = null;
    private Member[] members;
    private static Logger logger = Logger.getLogger(DimensionRow.class.getName());

    public DimensionRow(Member[] members) {
        logger.entering(DimensionRow.class.getName(), "DimensionRow", members);
        this.members = members;
        logger.exiting(DimensionRow.class.getName(), "DimensionRow");
    }

    public Object[] getFieldValues() {
        ArrayList<Object> fieldList = new ArrayList<Object>();
        fieldList.add(this.members.length);
        int i = 0;
        while (i < this.members.length) {
            Object[] fieldValues = this.members[i].getFieldValues();
            fieldList.add(fieldValues.length);
            int j = 0;
            while (j < fieldValues.length) {
                fieldList.add(fieldValues[j]);
                ++j;
            }
            ++i;
        }
        return fieldList.toArray();
    }

    public static IStructureCreator getCreator() {
        if (creator == null) {
            creator = new DimesionMemberCreator();
        }
        return creator;
    }

    public int compareTo(Object o) {
        assert (o != null);
        assert (o instanceof DimensionRow);
        DimensionRow other = (DimensionRow)o;
        if (this.members.length == 0) {
            return 0;
        }
        return CompareUtil.compare(this.members[this.members.length - 1].getKeyValues(), other.members[this.members.length - 1].getKeyValues());
    }

    public Member[] getMembers() {
        return this.members;
    }

    public void setMembers(Member[] members) {
        this.members = members;
    }
}

