/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v3;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.internal.document.IPageHintReader;
import org.eclipse.birt.report.engine.internal.document.PageIndexReader;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;
import org.eclipse.birt.report.engine.presentation.PageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageHintReaderV3
implements IPageHintReader {
    protected IDocArchiveReader reader;
    protected RAInputStream indexStream;
    protected RAInputStream hintsStream;
    protected PageIndexReader pageIndexReader;
    protected long totalPage = -1L;
    protected ArrayList<PageVariable> pageVariables;
    protected int version;

    public PageHintReaderV3(IDocArchiveReader reader) throws IOException {
        this.reader = reader;
        try {
            this.hintsStream = reader.getStream("/pages");
            this.indexStream = reader.getStream("/pages_index");
            this.pageIndexReader = new PageIndexReader(reader);
            this.version = PageHintReaderV3.readHintVersion(this.hintsStream);
            if (this.version != 3 && this.version != 4 && this.version != 5 && this.version != 6) {
                throw new IOException("unsupported hint version:" + this.version);
            }
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public static int readHintVersion(RAInputStream hintStream) throws IOException {
        hintStream.seek(0L);
        int version = hintStream.readInt();
        if (version == 0) {
            return 1;
        }
        return version;
    }

    @Override
    public void close() {
        try {
            if (this.hintsStream != null) {
                this.hintsStream.close();
                this.hintsStream = null;
            }
            if (this.indexStream != null) {
                this.indexStream.close();
                this.indexStream = null;
            }
            if (this.pageIndexReader != null) {
                this.pageIndexReader.close();
                this.pageIndexReader = null;
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public synchronized long getTotalPage() throws IOException {
        this.indexStream.refresh();
        this.indexStream.seek(0L);
        this.totalPage = this.indexStream.readLong();
        return this.totalPage;
    }

    @Override
    public synchronized Collection<PageVariable> getPageVariables() throws IOException {
        if (this.pageVariables == null) {
            this.pageVariables = new ArrayList();
            if (this.version == 6) {
                this.indexStream.seek(8L);
                long offset = this.indexStream.readLong();
                if (offset != -1L) {
                    this.hintsStream.seek(offset);
                    this.readPageVariables(new DataInputStream((InputStream)this.hintsStream), this.pageVariables);
                }
            }
        }
        return this.pageVariables;
    }

    private long getHintOffset(long pageNumber) {
        switch (this.version) {
            case 3: 
            case 4: 
            case 5: {
                return pageNumber * 8L;
            }
            case 6: {
                return (pageNumber + 1L) * 8L;
            }
        }
        assert (false);
        return -1L;
    }

    @Override
    public synchronized IPageHint getPageHint(long pageNumber) throws IOException {
        long indexOffset = this.getHintOffset(pageNumber);
        this.indexStream.seek(indexOffset);
        long offset = this.indexStream.readLong();
        this.hintsStream.seek(offset);
        return this.readPageHint(this.version, new DataInputStream((InputStream)this.hintsStream));
    }

    protected IPageHint readPageHint(int version, DataInputStream in) throws IOException {
        switch (version) {
            case 4: {
                return this.readPageHintV4(in);
            }
            case 5: {
                return this.readPageHintV5(in);
            }
            case 6: {
                return this.readPageHintV6(in);
            }
        }
        throw new IOException("Unsupported page hint version " + version);
    }

    public PageHint readPageHintV6(DataInputStream in) throws IOException {
        PageHint hint = this.readPageHintV5(in);
        Collection<PageVariable> variables = hint.getPageVariables();
        this.readPageVariables(in, variables);
        return hint;
    }

    public PageHint readPageHintV5(DataInputStream in) throws IOException {
        PageHint hint = this.readPageHintV4(in);
        int columnHintSize = IOUtil.readInt((InputStream)in);
        int i = 0;
        while (i < columnHintSize) {
            String tableId = IOUtil.readString((DataInputStream)in);
            int start = IOUtil.readInt((InputStream)in);
            int columnCount = IOUtil.readInt((InputStream)in);
            hint.addTableColumnHint(new TableColumnHint(tableId, start, columnCount));
            ++i;
        }
        return hint;
    }

    public PageHint readPageHintV4(DataInputStream in) throws IOException {
        long pageNumber = IOUtil.readLong((DataInputStream)in);
        String masterPage = IOUtil.readString((DataInputStream)in);
        PageHint hint = new PageHint(pageNumber, masterPage);
        hint.setOffset(this.pageIndexReader.getPageOffset(masterPage));
        int sectionCount = IOUtil.readInt((InputStream)in);
        int i = 0;
        while (i < sectionCount) {
            PageSection section = new PageSection();
            section.starts = this.readInstanceIndex(in);
            section.ends = this.readInstanceIndex(in);
            section.startOffset = section.starts[section.starts.length - 1].getOffset();
            section.endOffset = section.ends[section.ends.length - 1].getOffset();
            hint.addSection(section);
            ++i;
        }
        int hintSize = IOUtil.readInt((InputStream)in);
        int i2 = 0;
        while (i2 < hintSize) {
            UnresolvedRowHint rowHint = new UnresolvedRowHint();
            rowHint.readObject(new DataInputStream(in));
            hint.addUnresolvedRowHint(rowHint);
            ++i2;
        }
        return hint;
    }

    protected InstanceIndex[] readInstanceIndex(DataInputStream in) throws IOException {
        int length = IOUtil.readInt((InputStream)in);
        InstanceIndex[] indexes = new InstanceIndex[length];
        int i = 0;
        while (i < length) {
            String id = IOUtil.readString((DataInputStream)in);
            long offset = IOUtil.readLong((DataInputStream)in);
            indexes[i] = new InstanceIndex(InstanceID.parse(id), offset);
            ++i;
        }
        return indexes;
    }

    @Override
    public long getPageOffset(long pageNumber, String masterPage) throws IOException {
        return this.pageIndexReader.getPageOffset(masterPage);
    }

    protected void readPageVariables(DataInputStream in, Collection<PageVariable> variables) throws IOException {
        int count = IOUtil.readInt((InputStream)in);
        int i = 0;
        while (i < count) {
            PageVariable variable = this.readPageVariable(in);
            variables.add(variable);
            ++i;
        }
    }

    private PageVariable readPageVariable(DataInputStream in) throws IOException {
        String name = IOUtil.readString((DataInputStream)in);
        String scope = IOUtil.readString((DataInputStream)in);
        Object value = IOUtil.readObject((DataInputStream)in);
        return new PageVariable(name, scope, value);
    }
}

