/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.pdf.BaseFont;

public class FontInfo {
    private BaseFont bf;
    private float fontSize;
    private int fontStyle;
    private int fontWeight;
    private boolean simulation;
    private float lineWidth;
    private float fontHeight;
    private float baselinePosition;
    private float underlinePosition;
    private float linethroughPosition;
    private float overlinePosition;

    public FontInfo(BaseFont bf, float fontSize, int fontStyle, int fontWeight, boolean simulation) {
        this.bf = bf;
        this.fontStyle = fontStyle;
        this.simulation = simulation;
        this.fontSize = fontSize;
        this.fontWeight = fontWeight;
        this.setupFontSize();
    }

    public FontInfo(FontInfo fontInfo) {
        this.bf = fontInfo.bf;
        this.fontStyle = fontInfo.fontStyle;
        this.simulation = fontInfo.simulation;
        this.fontSize = fontInfo.fontSize;
        this.fontWeight = fontInfo.fontWeight;
        this.setupFontSize();
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
        this.setupFontSize();
    }

    protected void setupFontSize() {
        if (this.bf == null) {
            this.lineWidth = 1.0f;
            this.fontHeight = this.fontSize;
            this.baselinePosition = this.fontSize;
            this.underlinePosition = this.fontSize;
            this.linethroughPosition = this.fontSize / 2.0f;
            this.overlinePosition = 0.0f;
            return;
        }
        float ascent = this.bf.getFontDescriptor(9, this.fontSize);
        float descent = this.bf.getFontDescriptor(10, this.fontSize);
        if (this.bf.getFontType() == 0) {
            ascent = this.bf.getFontDescriptor(8, this.fontSize);
            descent = this.bf.getFontDescriptor(6, this.fontSize);
        }
        if (descent > 0.0f) {
            descent = -descent;
        }
        float baseline = this.bf.getFontDescriptor(13, this.fontSize);
        float baseline_thickness = this.bf.getFontDescriptor(14, this.fontSize);
        float strike = this.bf.getFontDescriptor(15, this.fontSize);
        float strike_thickness = this.bf.getFontDescriptor(16, this.fontSize);
        this.lineWidth = baseline_thickness;
        if (this.lineWidth == 0.0f) {
            this.lineWidth = strike_thickness;
            if (this.lineWidth == 0.0f) {
                this.lineWidth = this.fontSize / 20.0f;
            }
        }
        this.fontHeight = ascent - descent;
        this.baselinePosition = ascent - this.lineWidth / 2.0f;
        this.underlinePosition = ascent - baseline - this.lineWidth / 2.0f;
        this.linethroughPosition = strike == 0.0f ? this.fontHeight / 2.0f - this.lineWidth / 2.0f : ascent - strike - this.lineWidth / 2.0f;
        this.overlinePosition = 0.0f;
    }

    public void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }

    public BaseFont getBaseFont() {
        return this.bf;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public int getFontWeight() {
        return this.fontWeight;
    }

    public boolean getSimulation() {
        return this.simulation;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public int getOverlinePosition() {
        return (int)(this.overlinePosition * 1000.0f);
    }

    public int getUnderlinePosition() {
        return (int)(this.underlinePosition * 1000.0f);
    }

    public int getLineThroughPosition() {
        return (int)(this.linethroughPosition * 1000.0f);
    }

    public int getBaseline() {
        return (int)(this.baselinePosition * 1000.0f);
    }

    public float getWordWidth(String word) {
        if (word == null) {
            return 0.0f;
        }
        if (this.bf == null) {
            return (float)word.length() * (this.fontSize / 2.0f);
        }
        return this.bf.getWidthPoint(word, this.fontSize);
    }

    public float getWordHeight() {
        return this.fontHeight;
    }

    public String getFontName() {
        assert (this.bf != null);
        String[][] familyFontNames = this.bf.getFamilyFontName();
        String[] family = familyFontNames[familyFontNames.length - 1];
        return family[family.length - 1];
    }
}

