/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.ILayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineTextExtension;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineTextRenderListener;
import org.eclipse.birt.report.engine.nLayout.area.impl.SizeBasedContent;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextAreaLayout;

public class InlineTextArea
extends InlineContainerArea
implements ILayout {
    private InlineTextRenderListener listener = null;

    public InlineTextArea(ContainerArea parent, LayoutContext context, IContent content) {
        super(parent, context, content);
        SizeBasedContent hint;
        InstanceID id;
        if (context.isInHtmlRender() && (id = content.getInstanceID()) != null && (hint = context.getHtmlLayoutContext().getPageHintManager().getSizeBasedContentMapping().get(id.toUniqueString())) != null) {
            this.setX(hint.floatPos);
            this.listener = new InlineTextRenderListener(this, hint.offsetInContent, hint.dimension);
        }
    }

    public InlineTextArea(InlineTextArea area) {
        super(area);
    }

    public void layout() throws BirtException {
        this.initialize();
        this.removeHyperlinkForBlankText();
        TextAreaLayout inlineText = new TextAreaLayout(this, this.context, this.content);
        inlineText.initialize();
        if (this.context.isInHtmlRender()) {
            inlineText.addListener(this.listener);
        }
        inlineText.layout();
        inlineText.close();
        this.updateTextContent();
        this.close();
    }

    private void removeHyperlinkForBlankText() {
        String text = ((ITextContent)this.content).getText();
        if (text == null || text.length() == 0) {
            this.setAction(null);
        }
    }

    public InlineTextArea cloneArea() {
        InlineTextArea newArea = new InlineTextArea(this);
        return newArea;
    }

    protected void addToExtension(InlineContainerArea area) {
        this.addLineToExtension((InlineTextArea)area);
    }

    private void addLineToExtension(InlineTextArea area) {
        InlineTextExtension ext = this.getContentExtension();
        if (ext != null) {
            ext.addLine(area);
        }
    }

    private void replaceLine(InlineTextArea oldArea, InlineTextArea newArea) {
        InlineTextExtension ext = this.getContentExtension();
        if (ext != null) {
            ext.replaceLine(oldArea, newArea);
        }
    }

    private void addLineBreakToExtension() {
        InlineTextExtension ext = this.getContentExtension();
        if (ext != null) {
            ext.addLineBreak();
        }
    }

    private void addLineBreakToExtension(InlineTextArea area) {
        InlineTextExtension ext = this.getContentExtension();
        if (ext != null) {
            ext.addLineBreak(area);
        }
    }

    private InlineTextExtension getContentExtension() {
        if (this.context.isFixedLayout() && this.context.getEngineTaskType() == 1) {
            InlineTextExtension ext = (InlineTextExtension)this.content.getExtension(1);
            if (ext == null) {
                ext = new InlineTextExtension();
                this.content.setExtension(1, ext);
            }
            return ext;
        }
        return null;
    }

    private void updateTextContent() {
        if (this.context.isInHtmlRender()) {
            ((ITextContent)this.content).setText(this.listener.getSplitText());
        }
    }

    protected void close(boolean isLastLine) throws BirtException {
        super.close(isLastLine);
        if (isLastLine) {
            this.addLineToExtension(this);
            this.addLineBreakToExtension(this);
        }
        this.checkDisplayNone();
    }

    protected boolean checkPageBreak() throws BirtException {
        boolean ret = false;
        if (!this.isInInlineStacking && this.context.isAutoPageBreak()) {
            int aHeight = this.getAllocatedHeight();
            while (aHeight + this.parent.getAbsoluteBP() > this.context.getMaxBP()) {
                this.addLineBreakToExtension();
                if (!this.parent.autoPageBreak()) {
                    return false;
                }
                aHeight = this.getAllocatedHeight();
                ret = true;
            }
        }
        return ret;
    }

    public ContainerArea.SplitResult split(int height, boolean force) throws BirtException {
        if (force) {
            InlineTextArea newArea = this.cloneArea();
            this.addLineToExtension(newArea);
            newArea.children.addAll(this.children);
            this.children.clear();
            this.height = 0;
            this.replaceLine(this, newArea);
            this.addLineBreakToExtension(newArea);
            return new ContainerArea.SplitResult(newArea, 0);
        }
        this.addLineBreakToExtension();
        return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
    }
}

