/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import org.eclipse.birt.report.designer.internal.ui.util.SortMap;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IFormProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.FormSection;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class FormPage
extends AttributePage {
    private int style;
    protected IFormProvider provider;
    private boolean withDialog = false;
    private boolean isTabbed = false;
    private FormSection formSection;
    private Composite composite;
    boolean needRebuild = false;

    public FormPage(int style, IFormProvider provider) {
        this.style = style;
        this.provider = provider;
    }

    public FormPage(int style, IFormProvider provider, boolean withDialog) {
        this.style = style;
        this.provider = provider;
        this.withDialog = withDialog;
    }

    public FormPage(int style, IFormProvider provider, boolean withDialog, boolean isTabbed) {
        this.style = style;
        this.provider = provider;
        this.withDialog = withDialog;
        this.isTabbed = isTabbed;
    }

    public void buildUI(Composite parent) {
        this.container = new ScrolledComposite(parent, 768);
        this.container.setLayoutData((Object)new GridData(1808));
        ((ScrolledComposite)this.container).setExpandHorizontal(true);
        ((ScrolledComposite)this.container).setExpandVertical(true);
        this.container.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                FormPage.this.computeSize();
            }
        });
        this.container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FormPage.this.deRegisterEventManager();
            }
        });
        this.composite = new Composite(this.container, 0);
        this.composite.setLayoutData((Object)new GridData(1808));
        if (this.sections == null) {
            this.sections = new SortMap();
        }
        this.composite.setLayout((Layout)WidgetUtil.createGridLayout(1));
        this.createFormSection();
        this.createSections();
        this.layoutSections();
        ((ScrolledComposite)this.container).setContent((Control)this.composite);
    }

    protected void createFormSection() {
        this.formSection = new FormSection(this.provider.getDisplayName(), this.composite, true, this.isTabbed);
        this.formSection.setProvider(this.provider);
        this.formSection.setButtonWithDialog(this.withDialog);
        this.formSection.setStyle(this.style);
        this.formSection.setHeight(160);
        this.formSection.setFillForm(true);
        this.addSection("FORM_FORM", this.formSection);
    }

    private void computeSize() {
        Point size = this.composite.computeSize(-1, -1);
        ((ScrolledComposite)this.container).setMinSize(size.x, size.y + 10);
        this.container.layout();
    }

    public void addElementEvent(DesignElementHandle focus, NotificationEvent ev) {
        if (this.checkControl(this.formSection)) {
            if (this.provider.needRebuilded(ev)) {
                this.needRebuild = true;
                return;
            }
            this.formSection.getFormControl().addElementEvent(focus, ev);
        }
    }

    protected void rebuildUI() {
        Control[] children = this.composite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this.sections.clear();
        this.createFormSection();
        this.createSections();
        this.layoutSections();
        this.composite.layout();
        this.refresh();
    }

    public void clear() {
        this.needRebuild = false;
        if (this.checkControl(this.formSection)) {
            this.formSection.getFormControl().clear();
        }
    }

    private boolean checkControl(FormSection form) {
        return form != null && form.getFormControl() != null && !form.getFormControl().getControl().isDisposed();
    }

    public void postElementEvent() {
        if (this.checkControl(this.formSection)) {
            if (this.needRebuild) {
                this.rebuildUI();
                this.needRebuild = false;
            }
            this.formSection.getFormControl().postElementEvent();
        }
    }
}

