/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.dialogs.PreviewLabel;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IFastConsumerProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PreviewPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PreviewPropertyDescriptor
extends PropertyDescriptor
implements IFastConsumerProcessor {
    protected TableViewer fTableViewer;
    protected Button fAddButton;
    protected Button fDeleteButton;
    protected Button fMoveUpButton;
    protected Button fMoveDownButton;
    protected PreviewLabel previewLabel;
    protected PreviewPropertyDescriptorProvider provider;
    private Composite content;
    private Button fDuplicateButton;

    public PreviewPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(true);
    }

    public Control createControl(Composite parent) {
        this.content = new Composite(parent, 0);
        GridLayout layout = UIUtil.createGridLayoutWithoutMargin((int)2, (boolean)false);
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        layout.horizontalSpacing = 10;
        this.content.setLayout((Layout)layout);
        this.content.setLayoutData((Object)new GridData(1808));
        Composite buttons = new Composite(this.content, 0);
        GridData data = new GridData(768);
        buttons.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 6;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        Label lb = FormWidgetFactory.getInstance().createLabel(buttons, this.isFormStyle());
        lb.setText(this.provider.getText(-1));
        lb.setLayoutData((Object)new GridData(800));
        this.fAddButton = FormWidgetFactory.getInstance().createButton(buttons, 8, this.isFormStyle());
        this.fAddButton.setText(this.provider.getText(1));
        data = new GridData(128);
        data.widthHint = Math.max(60, this.fAddButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fAddButton.setLayoutData((Object)data);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewPropertyDescriptor.this.handleAddSelectedEvent();
            }
        });
        this.fDeleteButton = FormWidgetFactory.getInstance().createButton(buttons, 8, this.isFormStyle());
        this.fDeleteButton.setText(this.provider.getText(2));
        data = new GridData(128);
        data.widthHint = Math.max(60, this.fDeleteButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fDeleteButton.setLayoutData((Object)data);
        this.fDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewPropertyDescriptor.this.handleDeleteSelectedEvent();
            }
        });
        this.fMoveUpButton = FormWidgetFactory.getInstance().createButton(buttons, 8, this.isFormStyle());
        this.fMoveUpButton.setText(this.provider.getText(3));
        this.fMoveUpButton.setToolTipText(this.provider.getText(4));
        data = new GridData(128);
        data.widthHint = Math.max(60, this.fMoveUpButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fMoveUpButton.setLayoutData((Object)data);
        this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewPropertyDescriptor.this.handleMoveUpSelectedEvent();
            }
        });
        this.fMoveDownButton = FormWidgetFactory.getInstance().createButton(buttons, 8, this.isFormStyle());
        this.fMoveDownButton.setText(this.provider.getText(5));
        this.fMoveDownButton.setToolTipText(this.provider.getText(6));
        data = new GridData(128);
        data.widthHint = Math.max(60, this.fMoveDownButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fMoveDownButton.setLayoutData((Object)data);
        this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewPropertyDescriptor.this.handleMoveDownSelectedEvent();
            }
        });
        this.fDuplicateButton = FormWidgetFactory.getInstance().createButton(buttons, 8, this.isFormStyle());
        this.fDuplicateButton.setText(this.provider.getText(10));
        this.fDuplicateButton.setToolTipText(this.provider.getText(11));
        data = new GridData(128);
        data.widthHint = Math.max(60, this.fDuplicateButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fDuplicateButton.setLayoutData((Object)data);
        this.fDuplicateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewPropertyDescriptor.this.handleDuplicateButtonSelectedEvent();
            }
        });
        FormWidgetFactory.getInstance().createLabel(this.content, this.isFormStyle()).setText(this.provider.getText(7));
        int style = 65536;
        if (!this.isFormStyle()) {
            style |= 0x800;
        }
        Table table = FormWidgetFactory.getInstance().createTable(this.content, style);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(this.provider.getText(8));
        column.setWidth(400);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.provider.getLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)this.provider.getContentProvider((IModelEventProcessor)this));
        this.fTableViewer.setSorter(null);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PreviewPropertyDescriptor.this.updateButtons();
                PreviewPropertyDescriptor.this.refreshTableItemView();
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PreviewPropertyDescriptor.this.handleEditEvent();
            }
        });
        this.fTableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    PreviewPropertyDescriptor.this.handleDeleteSelectedEvent();
                }
            }
        });
        style = 2048;
        if (this.isFormStyle()) {
            style = 0;
        }
        this.previewLabel = new PreviewLabel(this.content, style);
        this.previewLabel.setText(this.provider.getText(9));
        GridData gd = new GridData(1040);
        gd.widthHint = 300;
        this.previewLabel.setLayoutData((Object)gd);
        FormWidgetFactory.getInstance().adapt((Composite)this.previewLabel);
        this.updateButtons();
        return this.content;
    }

    protected void handleDuplicateButtonSelectedEvent() {
        if (this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount()) {
            int idx = this.fTableViewer.getTable().getSelectionIndex();
            if (this.provider.duplicate(idx)) {
                int itemCount = this.fTableViewer.getTable().getItemCount();
                this.fTableViewer.getTable().deselectAll();
                this.fTableViewer.getTable().select(itemCount - 1);
                this.fTableViewer.getTable().setFocus();
            }
            this.updateButtons();
            this.refreshTableItemView();
        }
    }

    public Control getControl() {
        return this.content;
    }

    protected void handleEditEvent() {
        if (this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount()) {
            int idx = this.fTableViewer.getTable().getSelectionIndex();
            this.fTableViewer.getTable().setFocus();
            if (this.provider.edit(this.fTableViewer.getTable().getItem(this.fTableViewer.getTable().getSelectionIndex()).getData(), this.fTableViewer.getTable().getItemCount())) {
                this.fTableViewer.getTable().select(idx);
                this.fTableViewer.getTable().setFocus();
                this.updateButtons();
                this.refreshTableItemView();
            }
        }
    }

    protected void handleMoveDownSelectedEvent() {
        int index = this.fTableViewer.getTable().getSelectionIndex();
        if (this.provider.moveDown(index)) {
            this.fTableViewer.getTable().select(index + 1);
            this.fTableViewer.getTable().setFocus();
        }
        this.updateButtons();
        this.refreshTableItemView();
    }

    protected void handleMoveUpSelectedEvent() {
        int index = this.fTableViewer.getTable().getSelectionIndex();
        if (this.provider.moveUp(index)) {
            this.fTableViewer.getTable().select(index - 1);
            this.fTableViewer.getTable().setFocus();
        }
        this.updateButtons();
        this.refreshTableItemView();
    }

    protected void handleDeleteSelectedEvent() {
        int idx;
        if (this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount() && this.provider.delete(idx = this.fTableViewer.getTable().getSelectionIndex())) {
            if (idx >= this.fTableViewer.getTable().getItemCount()) {
                --idx;
            }
            this.fTableViewer.getTable().select(idx);
            this.fTableViewer.getTable().setFocus();
        }
        this.updateButtons();
        this.refreshTableItemView();
    }

    protected void handleAddSelectedEvent() {
        int itemCount = this.fTableViewer.getTable().getItemCount();
        if (this.provider.add(itemCount)) {
            itemCount = this.fTableViewer.getTable().getItemCount();
            this.fTableViewer.getTable().deselectAll();
            this.fTableViewer.getTable().select(itemCount - 1);
            this.fTableViewer.getTable().setFocus();
        }
        this.updateButtons();
        this.refreshTableItemView();
    }

    protected void updateButtons() {
        if (this.fTableViewer.getTable().isDisposed()) {
            return;
        }
        this.fDeleteButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount());
        this.fMoveUpButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() > 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount());
        this.fMoveDownButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount() - 1);
        this.fDuplicateButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount());
    }

    protected void refreshTableItemView() {
        if (this.fTableViewer.getTable().isDisposed()) {
            return;
        }
        int i = 0;
        while (i < this.fTableViewer.getTable().getItemCount()) {
            TableItem ti = this.fTableViewer.getTable().getItem(i);
            ti.setText(0, this.provider.getColumnText(ti.getData(), 1));
            ++i;
        }
        if (this.fTableViewer.getTable().getSelectionIndex() >= 0) {
            this.updatePreview(this.fTableViewer.getTable().getItem(this.fTableViewer.getTable().getSelectionIndex()).getData());
        } else {
            this.updatePreview(null);
        }
    }

    protected void updatePreview(Object handle) {
    }

    protected void enableUI(boolean enabled) {
        if (this.fTableViewer != null) {
            this.fAddButton.setEnabled(enabled);
            this.fDeleteButton.setEnabled(enabled);
            this.fMoveUpButton.setEnabled(enabled);
            this.fMoveDownButton.setEnabled(enabled);
            this.fDeleteButton.setEnabled(enabled);
            this.fTableViewer.getTable().setEnabled(enabled);
            if (enabled) {
                this.updateButtons();
            }
        }
    }

    public void load() {
        if (DEUtil.getInputSize((Object)this.input) != 1) {
            this.enableUI(false);
            return;
        }
        this.enableUI(true);
        this.fTableViewer.setInput((Object)DEUtil.getInputElements((Object)this.input));
        this.refreshTableItemView();
    }

    public void save(Object obj) throws SemanticException {
    }

    public void setInput(Object input) {
        this.input = input;
        this.getDescriptorProvider().setInput(input);
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (provider instanceof PreviewPropertyDescriptorProvider) {
            this.provider = (PreviewPropertyDescriptorProvider)provider;
        }
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (this.fTableViewer != null) {
            if (this.fTableViewer.getContentProvider() == null) {
                return;
            }
            this.fTableViewer.setInput(this.input);
            this.refreshTableItemView();
        }
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.content, isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.content.setVisible(isVisible);
    }

    public void addElementEvent(DesignElementHandle focus, NotificationEvent ev) {
    }

    public void clear() {
    }

    public boolean isOverdued() {
        return this.fTableViewer == null || this.fTableViewer.getContentProvider() == null || this.fTableViewer.getControl() == null || this.fTableViewer.getControl().isDisposed();
    }

    public void postElementEvent() {
        if (this.fTableViewer == null || this.fTableViewer.getContentProvider() == null) {
            return;
        }
        if (this.fTableViewer != null) {
            this.fTableViewer.setInput(this.input);
            this.refreshTableItemView();
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

