/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AggregateOnBindingPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.BindingPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.FormPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.PreviewPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.HighlightDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.MapDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.SortingHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.HighlightPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.MapPropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.attributes.AbstractPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.TabPage;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;

public abstract class BasePageGenerator
extends AbstractPageGenerator {
    protected TabPage buildTabContent(String tabKey) {
        AttributePage page = null;
        if (tabKey.equals(BINDINGTITLE)) {
            page = this.isSupportAggregationBinding() ? new AggregateOnBindingPage() : new BindingPage();
        } else if (tabKey.equals(SORTINGTITLE)) {
            page = new FormPage(3, new SortingHandleProvider(), true, true);
        } else if (tabKey.equals(FILTERTITLE)) {
            AbstractFilterHandleProvider filterProvider = (AbstractFilterHandleProvider)ElementAdapterManager.getAdapter((Object)this, AbstractFilterHandleProvider.class);
            if (filterProvider == null) {
                filterProvider = new FilterHandleProvider();
            }
            page = new FormPage(3, filterProvider, true, true);
        } else if (tabKey.equals(HIGHLIGHTSTITLE)) {
            page = new PreviewPage(true);
            ((PreviewPage)page).setPreview(new HighlightPropertyDescriptor(true));
            ((PreviewPage)page).setProvider(new HighlightDescriptorProvider());
        } else if (tabKey.equals(MAPTITLE)) {
            page = new PreviewPage(true);
            ((PreviewPage)page).setPreview(new MapPropertyDescriptor(true));
            ((PreviewPage)page).setProvider(new MapDescriptorProvider());
        }
        return page;
    }

    protected void buildItemContent(CTabItem item) {
        if (this.itemMap.containsKey(item) && this.itemMap.get(item) == null) {
            String title = this.tabFolder.getSelection().getText();
            TabPage page = this.buildTabContent(title);
            if (page != null) {
                this.setPageInput(page);
                this.refresh((Composite)this.tabFolder, page, true);
                item.setControl(page.getControl());
                this.itemMap.put(item, page);
            }
        } else if (this.itemMap.get(item) != null) {
            this.setPageInput(this.itemMap.get(item));
            this.refresh((Composite)this.tabFolder, this.itemMap.get(item), false);
        }
    }

    public void createTabItems(List input) {
        super.createTabItems(input);
        this.input = input;
        this.addSelectionListener(this);
        this.createTabItems();
        if (this.tabFolder.getSelection() != null) {
            this.buildItemContent(this.tabFolder.getSelection());
        }
    }

    protected boolean isSupportAggregationBinding() {
        return false;
    }

    protected abstract void createTabItems();
}

