/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.ui.swt.ColumnBindingInfo;
import org.eclipse.birt.chart.ui.swt.DefaultExpressionValidator;
import org.eclipse.birt.chart.ui.swt.interfaces.IAssistField;
import org.eclipse.birt.chart.ui.swt.interfaces.IExpressionButton;
import org.eclipse.birt.chart.ui.swt.interfaces.IExpressionValidator;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ChartExpressionButtonUtil {
    public static IExpressionButton createExpressionButton(Composite parent, Control control, ExtendedItemHandle eih, IExpressionProvider ep) {
        boolean isCube = ChartCubeUtil.getBindingCube((DesignElementHandle)eih) != null;
        boolean isCombo = control instanceof Combo || control instanceof CCombo;
        ChartExpressionHelper eHelper = isCombo ? new ChartExpressionComboHelper(isCube) : new ChartExpressionHelper(isCube);
        return new ChartExpressionButton(parent, control, eih, ep, eHelper);
    }

    private static class BindingExpressionDescriptor
    extends ExpressionDescriptor {
        private final String bindingName;
        private final String tooltip;
        private final boolean isCube;

        public BindingExpressionDescriptor(String bindingName, String tooltip, boolean isCube) {
            this.bindingName = bindingName;
            this.tooltip = tooltip;
            this.isCube = isCube;
            this.exprCodec.setBindingName(bindingName, isCube, UIUtil.getDefaultScriptType());
        }

        public void setExpressionType(String type) {
            if (!this.exprCodec.getType().equals(type)) {
                this.exprCodec.setBindingName(this.bindingName, this.isCube, type);
            }
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public boolean isColumnBinding() {
            return true;
        }

        public String getBindingName() {
            return this.bindingName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChartExpressionButton
    implements IExpressionButton {
        private final ChartExpressionUtil.ExpressionCodec lastExpr = ChartModelHelper.instance().createExpressionCodec();
        protected final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
        protected final ExpressionButton eb;
        protected final ChartExpressionHelper eHelper;
        protected final Vector<Listener> listeners = new Vector();
        protected ChartUIUtil.EAttributeAccessor<String> accessor;

        public ChartExpressionButton(Composite parent, Control control, ExtendedItemHandle eih, IExpressionProvider ep, ChartExpressionHelper eHelper) {
            this.eHelper = eHelper;
            this.eb = ExpressionButtonUtil.createExpressionButton((Composite)parent, (Control)control, (IExpressionProvider)ep, (Object)eih, (Listener)new Listener(){

                public void handleEvent(Event event) {
                    ChartExpressionButton.this.onChange();
                }
            }, (boolean)false, (int)8, (ExpressionButtonUtil.ExpressionHelper)eHelper);
            ExpressionButtonUtil.initExpressionButtonControl((Control)control, null);
            eHelper.initialize();
            ControlListener controlListener = new ControlListener();
            control.addListener(16, (Listener)controlListener);
            control.addListener(13, (Listener)controlListener);
            control.addListener(1, (Listener)controlListener);
        }

        private void save() {
            if (this.accessor != null) {
                String expr = this.eHelper.getExpression().length() == 0 ? null : this.getExpression();
                this.accessor.save((Object)expr);
            }
        }

        private void load() {
            if (this.accessor != null) {
                this.setExpression((String)this.accessor.load());
            }
        }

        protected boolean hasChanged() {
            String oldExpr = this.lastExpr.getExpression();
            String newExpr = this.eHelper.getExpression();
            String oldType = this.lastExpr.getType();
            String newType = this.eHelper.getExpressionType();
            if (oldExpr == null) {
                return newType != null || !oldType.equals(newType);
            }
            return !oldExpr.equals(newExpr) || !oldType.equals(newType);
        }

        private void onChange() {
            if (this.hasChanged()) {
                this.notifyChangeEvent();
            }
        }

        protected void notifyChangeEvent() {
            String newExpr = this.eHelper.getExpression();
            String newType = this.eHelper.getExpressionType();
            Event event = new Event();
            event.widget = this.eb.getControl();
            event.detail = 24;
            String[] data = new String[]{this.lastExpr.getExpression(), newExpr, this.lastExpr.getType(), newType};
            event.data = data;
            for (Listener listener : this.listeners) {
                listener.handleEvent(event);
            }
            this.save();
        }

        public void addListener(Listener listener) {
            if (listener != null) {
                this.listeners.add(listener);
            }
        }

        public String getExpression() {
            this.exprCodec.setExpression(this.eHelper.getExpression());
            this.exprCodec.setType(this.eHelper.getExpressionType());
            return this.exprCodec.encode();
        }

        public void setExpression(String expr) {
            this.setExpression(expr, false);
        }

        public String getDisplayExpression() {
            return this.eHelper.getExpression();
        }

        public boolean isEnabled() {
            return this.eb.isEnabled();
        }

        public void setEnabled(boolean bEnabled) {
            this.eb.setEnabled(bEnabled);
        }

        public void setAccessor(ChartUIUtil.EAttributeAccessor<String> accessor) {
            this.accessor = accessor;
            this.load();
        }

        public String getExpressionType() {
            return this.eHelper.getExpressionType();
        }

        public boolean isCube() {
            return this.eHelper.isCube();
        }

        public void setBindingName(String bindingName, boolean bNotifyEvents) {
            if (bindingName != null && bindingName.length() > 0) {
                this.exprCodec.setBindingName(bindingName, this.isCube(), this.eHelper.getExpressionType());
                this.eHelper.setExpression(this.exprCodec.getExpression());
            } else {
                this.eHelper.setExpression(bindingName);
            }
            this.eb.refresh();
            if (bNotifyEvents) {
                this.notifyChangeEvent();
            }
            this.lastExpr.setExpression(this.eHelper.getExpression());
            this.lastExpr.setType(this.eHelper.getExpressionType());
        }

        public void setExpression(String expr, boolean bNotifyEvents) {
            if (expr != null && expr.length() > 0) {
                this.exprCodec.decode(expr);
                this.eHelper.setExpressionType(this.exprCodec.getType());
                this.eHelper.setExpression(this.exprCodec.getExpression());
            } else {
                this.eHelper.setExpression(expr);
            }
            this.eb.refresh();
            if (bNotifyEvents) {
                this.notifyChangeEvent();
            }
            this.lastExpr.setExpression(this.eHelper.getExpression());
            this.lastExpr.setType(this.eHelper.getExpressionType());
        }

        public void setAssitField(IAssistField assistField) {
            this.eHelper.setAssitField(assistField);
        }

        public void setPredefinedQuery(Object[] predefinedQuery) {
            if (predefinedQuery == null) {
                return;
            }
            boolean isCube = this.isCube();
            LinkedHashSet<IExpressionDescriptor> set = new LinkedHashSet<IExpressionDescriptor>();
            Object[] objectArray = predefinedQuery;
            int n = predefinedQuery.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                set.add(ExpressionDescriptor.getInstance(obj, isCube));
                ++n2;
            }
            this.eHelper.setPredefinedQuerys(this.filterDuplicate(set));
        }

        private Collection<IExpressionDescriptor> filterDuplicate(Collection<IExpressionDescriptor> exprDescs) {
            LinkedHashSet<IExpressionDescriptor> set = new LinkedHashSet<IExpressionDescriptor>();
            LinkedHashSet<String> bindingNames = new LinkedHashSet<String>();
            LinkedList<IExpressionDescriptor> otherDescs = new LinkedList<IExpressionDescriptor>();
            for (IExpressionDescriptor desc : exprDescs) {
                if (desc.isColumnBinding()) {
                    set.add(desc);
                    bindingNames.add(desc.getBindingName());
                    continue;
                }
                otherDescs.add(desc);
            }
            for (IExpressionDescriptor desc : otherDescs) {
                String bindingName = desc.getBindingName();
                if (bindingNames.contains(bindingName)) continue;
                set.add(desc);
            }
            return set;
        }

        public ChartExpressionHelper getExpressionHelper() {
            return this.eHelper;
        }

        private class ControlListener
        implements Listener {
            private ControlListener() {
            }

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: {
                        if (event.keyCode != 13 && event.keyCode != 0x1000050) break;
                        ChartExpressionButton.this.onChange();
                        break;
                    }
                    case 13: 
                    case 16: {
                        ChartExpressionButton.this.onChange();
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChartExpressionComboHelper
    extends ChartExpressionHelper {
        protected final boolean bCacheUserInput = true;

        ChartExpressionComboHelper(boolean isCube) {
            super(isCube);
        }

        @Override
        public void setExpressionType(String exprType) {
            if (this.getExpressionType().equals(exprType)) {
                return;
            }
            super.setExpressionType(exprType);
            ChartUIUtil.ComboProxy cp = ChartUIUtil.ComboProxy.getInstance((Control)this.control);
            if (cp != null) {
                String[] itemsOld = cp.getItems();
                String userExpr = cp.getText();
                cp.removeAll();
                String[] stringArray = itemsOld;
                int n = itemsOld.length;
                int n2 = 0;
                while (n2 < n) {
                    String oldItem = stringArray[n2];
                    IExpressionDescriptor desc = (IExpressionDescriptor)cp.getData(oldItem);
                    if (desc != null) {
                        this.addComboItem(cp, desc);
                    } else {
                        cp.add(oldItem);
                    }
                    ++n2;
                }
                cp.setText(userExpr);
            }
        }

        private void addComboItem(ChartUIUtil.ComboProxy cp, IExpressionDescriptor desc) {
            String key = desc.getDisplayText();
            cp.add(key);
            cp.setData(key, (Object)desc);
        }

        @Override
        public void setExpression(String expression) {
            ChartUIUtil.ComboProxy cp;
            if (expression != null && expression.length() > 0 && (cp = ChartUIUtil.ComboProxy.getInstance((Control)this.control)).getData(expression) instanceof IExpressionDescriptor) {
                IExpressionDescriptor desc = (IExpressionDescriptor)cp.getData(expression);
                this.control.setToolTipText(desc.getTooltip());
            }
            super.setExpression(expression);
        }

        @Override
        public void initialize() {
            this.control.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ChartUIUtil.ComboProxy cp = ChartUIUtil.ComboProxy.getInstance((Control)ChartExpressionComboHelper.this.control);
                    if (cp != null && cp.getSelectionIndex() >= 0) {
                        IExpressionDescriptor desc = (IExpressionDescriptor)cp.getData(cp.getText());
                        if (desc != null) {
                            ChartExpressionComboHelper.this.setExpressionType(desc.getExpressionType());
                        }
                        ChartExpressionComboHelper.this.button.refresh();
                    }
                }
            });
        }

        @Override
        public void setPredefinedQuerys(Collection<IExpressionDescriptor> exprs) {
            super.setPredefinedQuerys(exprs);
            ChartUIUtil.ComboProxy cp = ChartUIUtil.ComboProxy.getInstance((Control)this.control);
            if (cp != null) {
                cp.removeAll();
                for (IExpressionDescriptor desc : this.predefinedQuerys) {
                    this.addComboItem(cp, desc);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChartExpressionHelper
    extends ExpressionButtonUtil.ExpressionHelper {
        protected final boolean isCube;
        protected IAssistField assistField;
        protected Set<IExpressionDescriptor> predefinedQuerys = new LinkedHashSet<IExpressionDescriptor>();
        private IExpressionValidator exprValidator = new DefaultExpressionValidator();

        public ChartExpressionHelper(boolean isCube) {
            this.isCube = isCube;
        }

        public boolean isCube() {
            return this.isCube;
        }

        public void setAssitField(IAssistField assistField) {
            this.assistField = assistField;
            this.updateAssistFieldContents();
        }

        public void setPredefinedQuerys(Collection<IExpressionDescriptor> exprs) {
            this.predefinedQuerys.clear();
            this.predefinedQuerys.addAll(exprs);
            this.setPredefinedQueryType(this.getExpressionType());
            this.updateAssistFieldContents();
        }

        private void updateAssistFieldContents() {
            if (this.assistField != null) {
                ArrayList<String> list = new ArrayList<String>();
                for (IExpressionDescriptor desc : this.predefinedQuerys) {
                    list.add(desc.getDisplayText());
                }
                this.assistField.setContent(list.toArray(new String[list.size()]));
            }
        }

        private void setPredefinedQueryType(String type) {
            for (IExpressionDescriptor desc : this.predefinedQuerys) {
                desc.setExpressionType(type);
            }
        }

        public void notifyExpressionChangeEvent(String oldExpression, String newExpression) {
            if (this.listener != null) {
                Event event = new Event();
                event.widget = this.button.getControl();
                event.data = new String[]{oldExpression, newExpression};
                event.detail = 24;
                this.listener.handleEvent(event);
            }
        }

        public String getExpression() {
            if (this.control.isDisposed()) {
                return "";
            }
            String expr = ChartUIUtil.getText((Control)this.control).trim();
            if (this.exprValidator.isReservedString(expr)) {
                return "";
            }
            return expr;
        }

        public void setExpression(String expression) {
            if (this.control.isDisposed()) {
                return;
            }
            ChartUIUtil.setText((Control)this.control, (String)DEUtil.resolveNull((String)expression));
        }

        public void initialize() {
        }

        public String getExpressionType() {
            String type = super.getExpressionType();
            return type != null ? type : UIUtil.getDefaultScriptType();
        }

        public void setExpressionType(String exprType) {
            super.setExpressionType(exprType);
            this.setPredefinedQueryType(this.getExpressionType());
            this.updateAssistFieldContents();
        }

        public void setExpressionValidator(IExpressionValidator exprValidator) {
            this.exprValidator = exprValidator;
        }
    }

    public static class ExpressionDescriptor
    implements IExpressionDescriptor {
        protected final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();

        protected ExpressionDescriptor() {
        }

        protected ExpressionDescriptor(String encodedExpr) {
            this.exprCodec.decode(encodedExpr);
        }

        protected ExpressionDescriptor(String sExprText, String type) {
            this.exprCodec.setExpression(sExprText);
            this.exprCodec.setType(type);
        }

        public static IExpressionDescriptor getInstance(Object expr, boolean isCube) {
            if (expr instanceof String[]) {
                return new ExpressionDescriptor(((String[])expr)[0]);
            }
            if (expr instanceof String) {
                if (isCube) {
                    return new BindingExpressionDescriptor((String)expr, (String)expr, isCube);
                }
                return new ExpressionDescriptor((String)expr);
            }
            if (expr instanceof ColumnBindingInfo) {
                return new BindingExpressionDescriptor(((ColumnBindingInfo)expr).getName(), ((ColumnBindingInfo)expr).getTooltip(), isCube);
            }
            return null;
        }

        public static IExpressionDescriptor getInstance(String exprText, String exprType) {
            return new ExpressionDescriptor(exprText, exprType);
        }

        public String getExpression() {
            return this.exprCodec.encode();
        }

        public void setExpressionType(String type) {
        }

        public String getDisplayText() {
            return this.exprCodec.getExpression();
        }

        public String getExpressionType() {
            return this.exprCodec.getType();
        }

        public String getTooltip() {
            return this.exprCodec.getExpression();
        }

        public boolean isColumnBinding() {
            return false;
        }

        public String getBindingName() {
            return this.exprCodec.getBindingName();
        }
    }

    public static interface IExpressionDescriptor {
        public void setExpressionType(String var1);

        public String getExpressionType();

        public String getDisplayText();

        public String getExpression();

        public String getTooltip();

        public boolean isColumnBinding();

        public String getBindingName();
    }
}

