/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.action;

import hiro.yoshioka.gef.action.GefCommonAction;
import hiro.yoshioka.gef.action.Messages;
import hiro.yoshioka.gef.model.Table;
import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.ui.view.MultiResultSetView;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ImageManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IWorkbenchPart;

public class ExecuteDropDownAction
extends GefCommonAction {
    DatabaseType db_type;
    private String[] EMPTY = new String[0];
    private ArrayList<String> fSQLStatemetList = new ArrayList();
    private ArrayList<int[]> fPosList = new ArrayList();

    public ExecuteDropDownAction(IWorkbenchPart part) {
        super("Execution", ImageManager.getImageDescriptor("action/60execute.gif"), part);
    }

    public void run() {
        try {
            this.execute();
        }
        catch (Exception e) {
            this.fLogger.error((Object)"", (Throwable)e);
        }
    }

    void execute() throws Exception {
        this.execute(false);
    }

    void execute(boolean isVirtual) throws Exception {
        MyJob job = new MyJob(this.fTableSelectionEditor.getTitle(), isVirtual);
        this.db_type = this.fTableSelectionEditor.getConnectionPropeteis().getDatabaseType();
        List<Table> mc = this.fTableSelectionEditor.getSchema().getTables();
        ArrayList<Table> selList = new ArrayList<Table>();
        int i = 0;
        while (i < mc.size()) {
            if (mc.get(i).isExecute_select()) {
                selList.add(mc.get(i));
            }
            ++i;
        }
        this.fTableModels = selList.toArray(new Table[selList.size()]);
        job.setUser(true);
        job.schedule();
    }

    class MyJob
    extends Job
    implements Runnable {
        ResultSetDataHolder[] fResult;
        private boolean isVir;

        public MyJob(String name, boolean isVir) {
            super("SELECTION TABLES [" + name + "]");
            this.fResult = new ResultSetDataHolder[0];
            this.isVir = isVir;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus ret = Status.CANCEL_STATUS;
            try {
                ExecuteDropDownAction.this.fSQLStatemetList.clear();
                ExecuteDropDownAction.this.fPosList.clear();
                monitor.beginTask(Messages.getString("ExecuteDropDownAction.EXECUTE_SELECTION"), ExecuteDropDownAction.this.fTableModels.length + 1);
                ArrayList<ResultSetDataHolder2> rList = new ArrayList<ResultSetDataHolder2>();
                int i = 0;
                while (i < ExecuteDropDownAction.this.fTableModels.length) {
                    ITransactionSQL sql = SQLServerThread.getSQLServer().getTransactionSQL(ExecuteDropDownAction.this.fTableSelectionEditor.getConnectionPropeteis());
                    ResultSetDataHolder2 rdh = null;
                    try {
                        monitor.setTaskName("SELECT " + ExecuteDropDownAction.this.fTableModels[i].getNameWithComment());
                        ExecuteDropDownAction.this.fLogger.info((Object)("executePrepareQuery=" + ExecuteDropDownAction.this.fTableModels[i].getSelectStatement(ExecuteDropDownAction.this.db_type)));
                        sql.setMaxRowNum(ExecuteDropDownAction.this.fTableSelectionEditor.getMaxRowNum());
                        rdh = sql.executePrepareQuery(ExecuteDropDownAction.this.fTableModels[i].getSelectStatement(ExecuteDropDownAction.this.db_type), (Object[])ExecuteDropDownAction.this.EMPTY);
                        monitor.subTask(String.valueOf(ExecuteDropDownAction.this.fTableModels[i].getNameWithComment()) + "Select RowNum=" + rdh.getRowCount());
                        rdh.setNamedInformationFromIDBTable(ExecuteDropDownAction.this.fTableModels[i].getDBTable(), ExecuteDropDownAction.this.fTableSelectionEditor.getSchema().getName());
                        rList.add(rdh);
                        monitor.worked(1);
                        ExecuteDropDownAction.this.fSQLStatemetList.add(ExecuteDropDownAction.this.fTableModels[i].getSelectStatement(ExecuteDropDownAction.this.db_type));
                        ExecuteDropDownAction.this.fPosList.add(ExecuteDropDownAction.this.fTableModels[i].getMatchingColumnIndex());
                    }
                    catch (SQLException e) {
                        ExecuteDropDownAction.this.fLogger.warn((Object)e);
                        Application.openDialog(Messages.getString("ExecuteDropDownAction.SQLError"), String.valueOf(Messages.getString("ExecuteDropDownAction.MistakeOrders")) + ExecuteDropDownAction.this.fTableModels[i].getSelectStatement(ExecuteDropDownAction.this.db_type), 1);
                    }
                    ++i;
                }
                ExecuteDropDownAction.this.fLogger.info((Object)("rList.size()=" + rList.size()));
                this.fResult = (ResultSetDataHolder[])rList.toArray(new ResultSetDataHolder2[rList.size()]);
                monitor.setTaskName(Messages.getString("ExecuteDropDownAction.showResultSet"));
                monitor.worked(1);
                Application.exec(this);
            }
            catch (Throwable e) {
                e.printStackTrace();
                ExecuteDropDownAction.this.fLogger.error((Object)"", e);
                ret = Status.CANCEL_STATUS;
            }
            return ret;
        }

        @Override
        public void run() {
            try {
                MultiResultSetView part = Application.showAndCreateMultiRstView(ExecuteDropDownAction.this.fTableSelectionEditor.getTitle());
                part.setPartName(ExecuteDropDownAction.this.fTableSelectionEditor.getTitle());
                String disp = ExecuteDropDownAction.this.fTableSelectionEditor.getConnectionDisplayString();
                ExecuteDropDownAction.this.fLogger.info((Object)("part=" + part + "/disp:" + disp));
                part.setConnectionPropertiesDisplay(disp);
                ExecuteDropDownAction.this.fLogger.info((Object)("fResult=" + this.fResult));
                part.setInput(this.fResult, this.isVir);
                part.setMatchingPos((int[][])ExecuteDropDownAction.this.fPosList.toArray((T[])new int[ExecuteDropDownAction.this.fPosList.size()][]));
                part.showBusy(true);
            }
            catch (Throwable e) {
                ExecuteDropDownAction.this.fLogger.error((Object)"", e);
            }
        }
    }
}

