/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.action;

import hiro.yoshioka.gef.editor.SchemaDiagramEditor;
import hiro.yoshioka.gef.model.Table;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.LineListener;
import hiro.yoshioka.sql.SqlBasicListener;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.program.Program;

public class GEFCSVExportAction
extends Action
implements SqlBasicListener {
    protected Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ArrayList<String> fSQLStatemetList = new ArrayList();
    SchemaDiagramEditor fTableSelectionEditor;
    Table[] fTableModels;

    public GEFCSVExportAction() {
        super("", 1);
        SQLServerThread.getSQLServer().addConnectionListner((SqlBasicListener)this);
        this.update();
    }

    public void configureAction(String text, String toolTipText, ImageDescriptor image) {
        this.setText(text);
        this.setToolTipText(toolTipText);
        this.setImageDescriptor(image);
    }

    public void run() {
        MyJob job = new MyJob(this.fTableSelectionEditor.getTitle());
        List<Table> mc = this.fTableSelectionEditor.getSchema().getTables();
        ArrayList<Table> selList = new ArrayList<Table>();
        int i = 0;
        while (i < mc.size()) {
            if (mc.get(i).isExecute_select() && (mc.get(i).getDBTable().getName().length() > 0 || mc.get(i).getDBTable().getComment().length() > 0)) {
                selList.add(mc.get(i));
            }
            ++i;
        }
        this.fTableModels = selList.toArray(new Table[selList.size()]);
        job.setUser(true);
        job.schedule();
    }

    private void update() {
    }

    public void connected() {
        Application.exec(new MyUpdate());
    }

    public void disconnected() {
        Application.exec(new MyUpdate());
    }

    public void setEditor(SchemaDiagramEditor editor) {
        this.fTableSelectionEditor = editor;
        System.out.println(this.fTableSelectionEditor.getSchema().getTables());
    }

    class MyJob
    extends Job {
        ResultSetDataHolder[] fResult;

        public MyJob(String name) {
            super("SELECTION TABLES [" + name + "]");
            this.fResult = new ResultSetDataHolder[0];
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus ret = Status.CANCEL_STATUS;
            try {
                IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.csvFolder);
                folder = ResourceMarker.getFolder(folder, String.format("%tY%<tm%<td_%<tH%<tM", new Date()), true);
                GEFCSVExportAction.this.fSQLStatemetList.clear();
                monitor.beginTask("EXECUTE CSV EXPORT", GEFCSVExportAction.this.fTableModels.length + 1);
                int i = 0;
                while (i < GEFCSVExportAction.this.fTableModels.length) {
                    PrintWriter out = null;
                    String name = String.valueOf(GEFCSVExportAction.this.fTableModels[i].getDBTable().getUName()) + "." + ResourceMarker.csvFolder;
                    IFile iFile = ResourceMarker.createFile(folder, name);
                    File file = ResourceMarker.cnvFile(iFile);
                    try {
                        out = new PrintWriter(new BufferedWriter(new FileWriter(file), 3072));
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    ConnectionProperties p = GEFCSVExportAction.this.fTableSelectionEditor.getConnectionPropeteis();
                    ITransactionSQL sql = SQLServerThread.getSQLServer().getTransactionSQL(p);
                    try {
                        monitor.setTaskName("SELECT " + GEFCSVExportAction.this.fTableModels[i].getNameWithComment());
                        MyListener listner = new MyListener(out);
                        GEFCSVExportAction.this.fLogger.warn((Object)("fTableModels[i].getCSVSelectStatement()=" + GEFCSVExportAction.this.fTableModels[i].getCSVSelectStatement(p.getDatabaseType())));
                        sql.executePrepareQueryByLine(GEFCSVExportAction.this.fTableModels[i].getCSVSelectStatement(p.getDatabaseType()), (LineListener)listner);
                        out.close();
                        monitor.worked(1);
                    }
                    catch (SQLException e) {
                        GEFCSVExportAction.this.fLogger.warn((Object)e);
                        Application.openDialog("SQL Error", "Error " + GEFCSVExportAction.this.fTableModels[i].getSelectStatement(Application.getActiveSchemaDiagramDatabaseType()), 1);
                    }
                    ++i;
                }
                Program.launch((String)ResourceMarker.cnvFile(folder).getAbsolutePath());
            }
            catch (RuntimeException e) {
                GEFCSVExportAction.this.fLogger.warn((Object)e);
                ret = Status.CANCEL_STATUS;
            }
            return ret;
        }
    }

    class MyListener
    implements LineListener {
        int iColumnCount;
        boolean[] quot;
        final PrintWriter fout;

        public MyListener(PrintWriter out) {
            this.fout = out;
        }

        public void first(ResultSet rs) {
            try {
                ResultSetMetaData meta = rs.getMetaData();
                this.quot = new boolean[meta.getColumnCount()];
                this.iColumnCount = meta.getColumnCount();
                StringBuffer buf = new StringBuffer();
                int m = 1;
                while (m <= this.iColumnCount) {
                    buf.append("\"").append(meta.getColumnName(m)).append("\"").append(",");
                    this.quot[m - 1] = true;
                    switch (meta.getColumnType(m)) {
                        case 91: 
                        case 93: {
                            this.quot[m - 1] = false;
                            break;
                        }
                        case 92: {
                            this.quot[m - 1] = false;
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.quot[m - 1] = false;
                        }
                    }
                    ++m;
                }
                buf.setLength(buf.length() - 1);
                this.fout.println(buf);
            }
            catch (SQLException e) {
                GEFCSVExportAction.this.fLogger.warn((Object)e);
            }
        }

        public void next(ResultSet rs) {
            StringBuffer buf = new StringBuffer();
            try {
                int m = 1;
                while (m <= this.iColumnCount) {
                    if (this.quot[m - 1]) {
                        buf.append("\"").append(StringUtil.nvl((Object)rs.getString(m)).replaceAll("[^\\\\]\"", "\\\"")).append("\"").append(",");
                    } else {
                        buf.append(rs.getString(m)).append(",");
                    }
                    ++m;
                }
                buf.setLength(buf.length() - 1);
                this.fout.println(buf);
            }
            catch (SQLException e) {
                GEFCSVExportAction.this.fLogger.warn((Object)e);
            }
        }

        private int countResultSet(ResultSet rs) {
            int row = 0;
            try {
                while (rs.next()) {
                    ++row;
                }
            }
            catch (SQLException e) {
                GEFCSVExportAction.this.fLogger.warn((Object)e);
            }
            return row;
        }
    }

    class MyUpdate
    implements Runnable {
        MyUpdate() {
        }

        @Override
        public void run() {
            GEFCSVExportAction.this.update();
        }
    }
}

