/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.layout;

import hiro.yoshioka.gef.layout.GraphXYLayout;
import hiro.yoshioka.gef.model.Schema;
import hiro.yoshioka.gef.part.SchemaDiagramPart;
import hiro.yoshioka.gef.policy.SchemaXYLayoutPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;

public class DelegatingLayoutManager
implements LayoutManager {
    Log fLogger = LogFactory.getLog(this.getClass());
    private SchemaDiagramPart diagram;
    private LayoutManager activeLayoutManager;
    private GraphXYLayout xyLayoutManager;

    public DelegatingLayoutManager(SchemaDiagramPart diagram) {
        this.diagram = diagram;
        this.xyLayoutManager = new GraphXYLayout(diagram);
        this.activeLayoutManager = this.xyLayoutManager;
    }

    public void layout(IFigure container) {
        Schema schema = this.diagram.getSchema();
        if (this.activeLayoutManager != this.xyLayoutManager) {
            if (schema.isLayoutManualAllowed()) {
                this.setLayoutManager(container, (LayoutManager)this.xyLayoutManager);
                this.activeLayoutManager.layout(container);
            } else if (this.diagram.setTableFigureBounds(true)) {
                this.setLayoutManager(container, (LayoutManager)this.xyLayoutManager);
                this.activeLayoutManager.layout(container);
            } else {
                this.activeLayoutManager.layout(container);
                this.setLayoutManager(container, (LayoutManager)this.xyLayoutManager);
            }
        } else {
            this.setLayoutManager(container, (LayoutManager)this.xyLayoutManager);
            this.activeLayoutManager.layout(container);
        }
    }

    public Object getConstraint(IFigure child) {
        this.fLogger.warn((Object)("child:" + child));
        return this.activeLayoutManager.getConstraint(child);
    }

    public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
        return this.activeLayoutManager.getMinimumSize(container, wHint, hHint);
    }

    public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
        return this.activeLayoutManager.getPreferredSize(container, wHint, hHint);
    }

    public void invalidate() {
        this.activeLayoutManager.invalidate();
    }

    public void remove(IFigure child) {
        this.activeLayoutManager.remove(child);
    }

    public void setConstraint(IFigure child, Object constraint) {
        this.activeLayoutManager.setConstraint(child, constraint);
    }

    public void setXYLayoutConstraint(IFigure child, Rectangle constraint) {
        this.xyLayoutManager.setConstraint(child, constraint);
    }

    private void setLayoutManager(IFigure container, LayoutManager layoutManager) {
        container.setLayoutManager(layoutManager);
        this.activeLayoutManager = layoutManager;
        if (layoutManager == this.xyLayoutManager) {
            this.diagram.installEditPolicy("LayoutEditPolicy", (EditPolicy)new SchemaXYLayoutPolicy());
        } else {
            this.diagram.installEditPolicy("LayoutEditPolicy", null);
        }
    }

    public LayoutManager getActiveLayoutManager() {
        return this.activeLayoutManager;
    }
}

