/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.model;

import hiro.yoshioka.gef.model.CommonConditionModel;
import hiro.yoshioka.gef.model.PropertyAwareObject;
import hiro.yoshioka.gef.model.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class Schema
extends PropertyAwareObject {
    private String name;
    private ArrayList<Table> tablesList = new ArrayList();
    private ArrayList<CommonConditionModel> fCommonConditionModelList = new ArrayList();
    private boolean layoutManualDesired = true;
    private boolean layoutManualAllowed = false;

    public Schema() {
    }

    public Schema(String name) {
        if (name == null) {
            throw new NullPointerException("Name cannot be null");
        }
        this.name = name;
    }

    public void addTable(Table table) {
        this.tablesList.add(table);
        this.firePropertyChange("CHILD", null, table);
    }

    public void addCommonConditionModel(CommonConditionModel commonConditionModel) {
        this.fCommonConditionModelList.add(commonConditionModel);
        commonConditionModel.setSchema(this);
        this.firePropertyChange("CHILD", null, commonConditionModel);
    }

    public void addTable(Table table, int i) {
        this.tablesList.add(table);
        this.firePropertyChange("CHILD", null, table);
    }

    public void removeTable(Table table) {
        this.tablesList.remove(table);
        this.firePropertyChange("CHILD", table, null);
    }

    public Table getTable(Table name) {
        int i = 0;
        while (i < this.tablesList.size()) {
            if (this.tablesList.get(i).equals(name)) {
                return this.tablesList.get(i);
            }
            ++i;
        }
        return null;
    }

    public List<Table> getTables() {
        return this.tablesList;
    }

    public List<PropertyAwareObject> getAllModelList() {
        ArrayList<PropertyAwareObject> retList = new ArrayList<PropertyAwareObject>(this.tablesList);
        retList.addAll(this.fCommonConditionModelList);
        return retList;
    }

    public String getName() {
        return this.name;
    }

    public void setLayoutManualAllowed(boolean layoutManualAllowed) {
        this.layoutManualAllowed = layoutManualAllowed;
    }

    public boolean isLayoutManualDesired() {
        return this.layoutManualDesired;
    }

    public void setLayoutManualDesired(boolean layoutManualDesired) {
        this.layoutManualDesired = layoutManualDesired;
        this.firePropertyChange("LAYOUT", null, new Boolean(layoutManualDesired));
    }

    public boolean isLayoutManualAllowed() {
        return this.layoutManualAllowed;
    }

    public ArrayList<Table> getTablesList() {
        return this.tablesList;
    }

    public void setTablesList(ArrayList<Table> tablesList) {
        this.tablesList = tablesList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void removeCommonConditionModel(CommonConditionModel commonConditionModel) {
        this.fCommonConditionModelList.remove(commonConditionModel);
        this.firePropertyChange("CHILD", commonConditionModel, null);
    }

    public ArrayList<CommonConditionModel> getFCommonConditionModelList() {
        return this.fCommonConditionModelList;
    }

    public void setFCommonConditionModelList(ArrayList<CommonConditionModel> commonConditionModelList) {
        this.fCommonConditionModelList = commonConditionModelList;
    }

    public String[] getAllColumnNames() {
        TreeSet<String> retList = new TreeSet<String>();
        int i = 0;
        while (i < this.tablesList.size()) {
            int j = 0;
            while (j < this.tablesList.get(i).getColumns().size()) {
                retList.add(this.tablesList.get((int)i).getColumns().get((int)j).column.getName());
                ++j;
            }
            ++i;
        }
        return retList.toArray(new String[retList.size()]);
    }

    public String getCommonConditionString(Table table) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.fCommonConditionModelList.size()) {
            this.fCommonConditionModelList.get(i).appendConditionString(table, buff);
            ++i;
        }
        return buff.toString();
    }
}

